/*
 * Top-level interpreter API
 * (C) 2006, Pascal Schmidt <arena-language@ewetel.net>
 * see file doc/LICENSE for license
 */
#ifndef ARENA_API_H
#define ARENA_API_H

typedef void *arena_ctx;

arena_ctx arena_new_ctx(int argc, char **argv);
void arena_free_ctx(arena_ctx ctx);

typedef void *arena_script;

arena_script arena_new_script(char *name);
void arena_dump_script(arena_script script);
void arena_free_script(arena_script script);

void arena_execute_script(arena_ctx ctx, arena_script script);

#endif
