/*
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL TOM KNIENIEDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF TOM
 * KNIENIEDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * TOM KNIENIEDER SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND TOM KNIENIEDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <syslog.h>
#include <unistd.h>
#include <varargs.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/uio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/termios.h>

#include "apc_upsd.h"

/* ------------------------------------------------------------------ */

#define TOKEN_DEVICE    0
#define TOKEN_DEBUGMODE 1
#define TOKEN_SMARTMODE 2
#define TOKEN_TIME      3
#define TOKEN_EXECUTE   4
#define TOKEN_PIDFILE   5
#define TOKEN_INFOTIME  6
#define TOKEN_EXTENDED  7
#define TOKEN_TEST      8

/* ------------------------------------------------------------------ */

#define TYPE_BOOL       0
#define TYPE_INTEGER    1
#define TYPE_STRING     2

/* ------------------------------------------------------------------ */

struct token tokens[] = 
{
        {   TOKEN_DEVICE,   TYPE_STRING,    "device",       0, { NULL } },
        {   TOKEN_DEBUGMODE,TYPE_BOOL,      "debugmode",    0, { NULL } },
        {   TOKEN_SMARTMODE,TYPE_BOOL,      "smartmode",    0, { NULL } },
        {   TOKEN_TIME,     TYPE_INTEGER,   "time",         0, { NULL } },
        {   TOKEN_EXECUTE,  TYPE_STRING,    "execute",      0, { NULL } },
        {   TOKEN_PIDFILE,  TYPE_STRING,    "pidfile",      0, { NULL } },
        {   TOKEN_INFOTIME, TYPE_INTEGER,   "infotime",     0, { NULL } },
        {   TOKEN_EXTENDED, TYPE_BOOL,      "extendedsmart",0, { NULL } },
        {   TOKEN_TEST,     TYPE_BOOL,      "startuptest",  0, { NULL } },

        /* whatever will come ... */

        {       -1, 0, NULL, 0  }
};

/* ------------------------------------------------------------------ */

int     parser()
{
        /* poor mans parser ... */

        FILE    *in;
        long    line = 0L;
        char    buffer[0xff];   /* yes, this IS hardcoded ... */
        char    *p;
        int             i;
        int             found;

        if ( ( in = fopen(ups->filename, "r")) == NULL )
        {
                fprintf(stderr, "open: %s: %s\n", ups->filename, 
                        sys_errlist[errno]);
                return  0;
        }

        while ( fgets( buffer, sizeof(buffer)-1,in ) != NULL )
        {
                line ++;

                p = strchr(buffer,'\n');
                if ( p == NULL )
                {
                        fclose(in);
                        fprintf(stderr, "%s: line %ld to long.\n", ups->filename, line );
                        return  0;
                }
                *p = '\0';
                p  = buffer;
                while ( *p == ' ' || *p == '\t' )
                        p ++;

                if ( *p == '\0' || *p == '#' )
                        continue;

                for ( found = i = 0; tokens[i].str != NULL; i ++ )
                {
                        if ( strncmp( p, tokens[i].str, strlen( tokens[i].str )) == 0 )
                        {
                                found = tokens[i].set = 1;

                                p += strlen( tokens[i].str );
                                while ( *p == ' ' || *p == '\t' )
                                        p ++;

                                if ( strlen(p) == 0 )
                                {
                                        fclose(in);
                                        fprintf(stderr, 
                                                "%s: line %ld missing value.\n", 
                                                ups->filename, line );
                                        return  0;
                                }

                                /* Correct type ? */

                                switch( tokens[i].what )
                                {
                                case    TYPE_BOOL:
                                        if ( strncmp(p,"ON", 2 ) == 0 )
                                                tokens[i].u.ival = 1;
                                        else if ( strncmp(p,"OFF", 3 ) == 0 )
                                                tokens[i].u.ival = 0;
                                        else
                                        {
                                                fclose(in);
                                                fprintf(stderr, 
                                                        "%s: line %ld should be 'ON' or 'OFF'.\n", 
                                                        ups->filename, line );
                                                return  0;
                                        }
                                        break;

                                case    TYPE_INTEGER:
                                        tokens[i].u.ival = atoi(p);
                                        break;

                                case    TYPE_STRING:
                                        tokens[i].u.pval = strdup( p );
                                        if ( tokens[i].u.pval == NULL )
                                        {
                                                fclose(in);
                                                fprintf(stderr, 
                                                        "%s: line %ld out of core.\n", 
                                                        ups->filename, line );
                                                return  0;
                                        }
                                        break;
                                }
                                break;
                        }
                }

                if ( ! found )
                {
                        fclose(in);
                        fprintf(stderr, "%s: line %ld unknown statement '%s'.\n",       
                                ups->filename, line , p );
                        return  0;
                }
        }
        fclose(in);

        /* Everything defined ? */

        for ( i = 0; tokens[i].str != NULL; i ++ )
        {
                if ( ! tokens[i].set )
                {
                        fprintf(stderr, "%s: '%s' is not defined.\n",   
                                ups->filename, tokens[i].str );
                        return  0;
                }
        }

        /* put them in ... */
        /*  i know .., should move this in the token table ... */

        ups->device     = strdup( tokens[ TOKEN_DEVICE          ].u.pval );
        ups->pidfile    = strdup( tokens[ TOKEN_PIDFILE         ].u.pval );
        ups->exec               = strdup( tokens[ TOKEN_EXECUTE ].u.pval );
        ups->debug      = tokens[ TOKEN_DEBUGMODE       ].u.ival;
        ups->wait               = tokens[ TOKEN_TIME            ].u.ival;
        ups->infotime   = tokens[ TOKEN_INFOTIME        ].u.ival;
        ups->smartmode  = tokens[ TOKEN_SMARTMODE       ].u.ival;
        ups->extended   = tokens[ TOKEN_EXTENDED    ].u.ival; 
        ups->startuptest = tokens[ TOKEN_TEST       ].u.ival; 

        if ( ups->debug )
        {
                printf("\n\n%s, %ld lines:\n", ups->filename,line );
                printf("==========================================\n");
                printf("device ............... %s\n", ups->device  );
                printf("pidfile .............. %s\n", ups->pidfile );
                printf("exec script .......... %s\n", ups->exec    );
                printf("debug mode ........... %d\n", ups->debug  );
                printf("wait seconds ......... %d\n", ups->wait   );            
                printf("infotime seconds ..... %d\n", ups->infotime );
                printf("smartmode ............ %d\n", ups->smartmode );
                printf("extended smartinfo ... %d\n", ups->extended );
                printf("startuptest .......... %d\n", ups->startuptest );
        }
        return  1;
}

