/*
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL TOM KNIENIEDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF TOM
 * KNIENIEDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * TOM KNIENIEDER SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND TOM KNIENIEDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

/* ---------------------------------------------------------------------- */

#define UPS_DEFAULT_CONFIG_FILENAME     "/etc/apc-upsd.conf"
#define UPS_IDFILE                      "/var/run/apc-upsd.pid"
#define UPS_SCR                         "/sbin/halt"

/* ---------------------------------------------------------------------- */

struct token
{
        int     id;
        int     what;
        char    *str;
        int     set;
        union
        {
                char    *pval;
                int     ival;
        }       u;
};

extern  struct token    tokens[];

/* ---------------------------------------------------------------------- */

typedef struct
{
        int     testflag;
        int     startuptest;
        int     extended;
        int     debug;
        char    *filename;
        char    *myname;
        char    *device;
        int     smartmode;
        int     status;
        int     wait;
        FILE    *fd;
        char    *exec;
        char    *pidfile;
        int     pd;
        int     infotime;

        /* For APC dumb mode */

        int     zero;
        char    d5, d6, d7;
        int     pow;
        int     seconds;

        /* For APC smart mode */

        struct termios oldtio;
        struct termios newtio;

        double  BatLoad;   
        double  LineMin;   
        double  LineMax;   
        double  UPSLoad;   
        double  LineFreq;  
        double  LineVoltage;
        double  OutputVoltage;
        double  UPSTemp;
        double  BattVoltage;
        int     Status;

        int     battlow;   
        int     battery;

        int     log_counter;
        int     log_timer;

        /* Whatever will be added .... */

}       UPS;

extern  UPS     *ups;

/* ---------------------------------------------------------------------- */

void upsterm    ();
void upsdown    ();
void upsusage   ();
int  upsopen    ();
int  upsloop    ();
void upsfork    ();
void upspidfile ();
void upstest    ();

/* ---------------------------------------------------------------------- */

int     apc_dumb_open   ();
int     apc_dumb_loop   ();
void    apc_dumb_UPS_off();

/* ---------------------------------------------------------------------- */

int     apc_smart_open  ();
int     apc_smart_loop  ();
void    apc_smart_UPS_off();

/* ---------------------------------------------------------------------- */

int     parser  ();

/* ---------------------------------------------------------------------- */
