/*
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL TOM KNIENIEDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF TOM
 * KNIENIEDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * TOM KNIENIEDER SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND TOM KNIENIEDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <syslog.h>
#include <unistd.h>
#include <varargs.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/uio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/ttycom.h>
#include <sys/ioctl.h>
#include <sys/termios.h>

#include "apc_upsd.h"


/* ---------------------------------------------------------------------- */

int     apc_dumb_open   ()
{

        /* open monitor device */

        if((ups->pd = open( ups->device, O_RDWR | O_NDELAY)) < 0)
        {
                fprintf(stderr, "open: %s\n", sys_errlist[errno]);
                return  0;
        }
        return  1;
}

/* ---------------------------------------------------------------------- */


int     apc_dumb_loop   ()
{
        /* monitor device */

        if ( ups->debug )
                printf("\nsorry, not stats when debugging dumb mode.\n");

        while(1) 
        {
                /* clear bits */

                if(ioctl(ups->pd, TIOCMSET, &ups->zero) < 0) 
                {
                        fprintf(stderr, "ioctl: %s\n", sys_errlist[errno]);
                        exit(1);
                }

                /* get device status */

                if(ioctl(ups->pd, TIOCMGET, &ups->status) < 0) 
                {
                        fprintf(stderr, "ioctl: %s\n", sys_errlist[errno]);
                        exit(1);
                }

                /* determine status */
                ups->d5 = ups->status & 0x20;
                ups->d6 = ups->status & 0x40;
                ups->d7 = ups->status & 0x80;

                /* power up */

                if(!(ups->d7 + ups->d5))        
                {
                        if(!ups->pow)   
                        {
                                syslog(LOG_CRIT, "POWER UP");
                                ups->pow = 1;
                                ups->seconds = 0;
                        }
                } 
                else 
                {
                        /* power down */

                        if(ups->pow) 
                        {
                                syslog(LOG_CRIT, "POWER DOWN");
                                ups->pow = 0;
                        }
                        ups->seconds ++;
                }
        
                sleep(1);

                if ( ups->seconds > ups->wait )
                {
                        upsdown();
                }
        }
}

/* ---------------------------------------------------------------------- */

void    apc_dumb_UPS_off()
{
        ups->status = TIOCM_DTR;

        if(ioctl(ups->pd, TIOCMSET, &ups->status) < 0) 
        {
                fprintf(stderr, "ioctl: %s\n", sys_errlist[errno]);
                /* go on ... @#! */
        }
        sleep(1);
}

