/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ssh.LogListener;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHUserInfo;

public abstract class SSHBase
extends Task
implements LogListener {
    private static final int SSH_PORT = 22;
    private String host;
    private String keyfile;
    private String knownHosts;
    private int port = 22;
    private boolean failOnError = true;
    private boolean verbose;
    private SSHUserInfo userInfo = new SSHUserInfo();

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setFailonerror(boolean failure) {
        this.failOnError = failure;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setVerbose(boolean failure) {
        this.verbose = failure;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setUsername(String username) {
        this.userInfo.setName(username);
    }

    public void setPassword(String password) {
        this.userInfo.setPassword(password);
    }

    public void setKeyfile(String keyfile) {
        this.userInfo.setKeyfile(keyfile);
    }

    public void setPassphrase(String passphrase) {
        this.userInfo.setPassphrase(passphrase);
    }

    public void setKnownhosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    public void setTrust(boolean yesOrNo) {
        this.userInfo.setTrust(yesOrNo);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void init() throws BuildException {
        super.init();
        this.knownHosts = System.getProperty("user.home") + "/.ssh/known_hosts";
        this.port = 22;
    }

    protected Session openSession() throws JSchException {
        JSch jsch = new JSch();
        if (null != this.userInfo.getKeyfile()) {
            jsch.addIdentity(this.userInfo.getKeyfile());
        }
        if (!this.userInfo.getTrust() && this.knownHosts != null) {
            this.log("Using known hosts: " + this.knownHosts, 4);
            jsch.setKnownHosts(this.knownHosts);
        }
        Session session = jsch.getSession(this.userInfo.getName(), this.host, this.port);
        session.setUserInfo((UserInfo)this.userInfo);
        this.log("Connecting to " + this.host + ":" + this.port);
        session.connect();
        return session;
    }

    protected SSHUserInfo getUserInfo() {
        return this.userInfo;
    }
}

