/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.clearcase;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;

public abstract class ClearCase
extends Task {
    private String m_ClearToolDir = "";
    private String m_viewPath = null;
    private String m_objSelect = null;
    private static final String CLEARTOOL_EXE = "cleartool";
    public static final String COMMAND_UPDATE = "update";
    public static final String COMMAND_CHECKOUT = "checkout";
    public static final String COMMAND_CHECKIN = "checkin";
    public static final String COMMAND_UNCHECKOUT = "uncheckout";
    public static final String COMMAND_LOCK = "lock";
    public static final String COMMAND_UNLOCK = "unlock";
    public static final String COMMAND_MKBL = "mkbl";
    public static final String COMMAND_MKLABEL = "mklabel";
    public static final String COMMAND_MKLBTYPE = "mklbtype";
    public static final String COMMAND_RMTYPE = "rmtype";

    public final void setClearToolDir(String dir) {
        this.getProject();
        this.m_ClearToolDir = Project.translatePath((String)dir);
    }

    protected final String getClearToolCommand() {
        String toReturn = this.m_ClearToolDir;
        if (!toReturn.equals("") && !toReturn.endsWith("/")) {
            toReturn = toReturn + "/";
        }
        toReturn = toReturn + CLEARTOOL_EXE;
        return toReturn;
    }

    public final void setViewPath(String viewPath) {
        this.m_viewPath = viewPath;
    }

    public String getViewPath() {
        return this.m_viewPath;
    }

    public final void setObjSelect(String objSelect) {
        this.m_objSelect = objSelect;
    }

    public String getObjSelect() {
        return this.m_objSelect;
    }

    protected int run(Commandline cmd) {
        try {
            Project aProj = this.getProject();
            Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1));
            exe.setAntRun(aProj);
            exe.setWorkingDirectory(aProj.getBaseDir());
            exe.setCommandline(cmd.getCommandline());
            return exe.execute();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }
}

