/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.clearcase;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.optional.clearcase.ClearCase;
import org.apache.tools.ant.types.Commandline;

public class CCMklbtype
extends ClearCase {
    private String m_TypeName = null;
    private String m_VOB = null;
    private String m_Comment = null;
    private String m_Cfile = null;
    private boolean m_Replace = false;
    private boolean m_Global = false;
    private boolean m_Ordinary = true;
    private boolean m_Pbranch = false;
    private boolean m_Shared = false;
    public static final String FLAG_REPLACE = "-replace";
    public static final String FLAG_GLOBAL = "-global";
    public static final String FLAG_ORDINARY = "-ordinary";
    public static final String FLAG_PBRANCH = "-pbranch";
    public static final String FLAG_SHARED = "-shared";
    public static final String FLAG_COMMENT = "-c";
    public static final String FLAG_COMMENTFILE = "-cfile";
    public static final String FLAG_NOCOMMENT = "-nc";

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        Project aProj = this.getProject();
        int result = 0;
        if (this.getTypeName() == null) {
            throw new BuildException("Required attribute TypeName not specified");
        }
        commandLine.setExecutable(this.getClearToolCommand());
        commandLine.createArgument().setValue("mklbtype");
        this.checkOptions(commandLine);
        result = this.run(commandLine);
        if (Execute.isFailure((int)result)) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    private void checkOptions(Commandline cmd) {
        if (this.getReplace()) {
            cmd.createArgument().setValue(FLAG_REPLACE);
        }
        if (this.getOrdinary()) {
            cmd.createArgument().setValue(FLAG_ORDINARY);
        } else if (this.getGlobal()) {
            cmd.createArgument().setValue(FLAG_GLOBAL);
        }
        if (this.getPbranch()) {
            cmd.createArgument().setValue(FLAG_PBRANCH);
        }
        if (this.getShared()) {
            cmd.createArgument().setValue(FLAG_SHARED);
        }
        if (this.getComment() != null) {
            this.getCommentCommand(cmd);
        } else if (this.getCommentFile() != null) {
            this.getCommentFileCommand(cmd);
        } else {
            cmd.createArgument().setValue(FLAG_NOCOMMENT);
        }
        cmd.createArgument().setValue(this.getTypeSpecifier());
    }

    public void setTypeName(String tn) {
        this.m_TypeName = tn;
    }

    public String getTypeName() {
        return this.m_TypeName;
    }

    public void setVOB(String vob) {
        this.m_VOB = vob;
    }

    public String getVOB() {
        return this.m_VOB;
    }

    public void setReplace(boolean repl) {
        this.m_Replace = repl;
    }

    public boolean getReplace() {
        return this.m_Replace;
    }

    public void setGlobal(boolean glob) {
        this.m_Global = glob;
    }

    public boolean getGlobal() {
        return this.m_Global;
    }

    public void setOrdinary(boolean ordinary) {
        this.m_Ordinary = ordinary;
    }

    public boolean getOrdinary() {
        return this.m_Ordinary;
    }

    public void setPbranch(boolean pbranch) {
        this.m_Pbranch = pbranch;
    }

    public boolean getPbranch() {
        return this.m_Pbranch;
    }

    public void setShared(boolean shared) {
        this.m_Shared = shared;
    }

    public boolean getShared() {
        return this.m_Shared;
    }

    public void setComment(String comment) {
        this.m_Comment = comment;
    }

    public String getComment() {
        return this.m_Comment;
    }

    public void setCommentFile(String cfile) {
        this.m_Cfile = cfile;
    }

    public String getCommentFile() {
        return this.m_Cfile;
    }

    private void getCommentCommand(Commandline cmd) {
        if (this.getComment() != null) {
            cmd.createArgument().setValue(FLAG_COMMENT);
            cmd.createArgument().setValue(this.getComment());
        }
    }

    private void getCommentFileCommand(Commandline cmd) {
        if (this.getCommentFile() != null) {
            cmd.createArgument().setValue(FLAG_COMMENTFILE);
            cmd.createArgument().setValue(this.getCommentFile());
        }
    }

    private String getTypeSpecifier() {
        String typenm = null;
        typenm = this.getTypeName();
        if (this.getVOB() != null) {
            typenm = typenm + "@" + this.getVOB();
        }
        return typenm;
    }
}

