/*
 *      sysinfo.c from Access Point SNMP Utils for Linux
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include <sys/wait.h>
#include <ncurses.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include "ap-utils.h"
#include <sys/wait.h>
#include <ncurses.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include "ap-utils.h"
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#define SYS_DESCR _("System Description: ")

#define OID_NUM 11

extern WINDOW *main_sub;
extern int LINES;

void sysinfo()
{
    struct HARD_CONFIGURATION_STUCT *HardConf;

    char sysDescr[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01,
	0x01, 0x01, 0x00
    };
    char sysDeviceInfo[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01,
	0x01, 0x05, 0x00
    };

    char message[200];
    int i;
    varbind varbinds[2];
	extern short ap_type;
    
	if (ME102 == ap_type)
	{
		sysDescr[5] = 0xe0;
		sysDescr[6] = 0x3e;
		sysDeviceInfo[5] = 0xe0;
		sysDeviceInfo[6] = 0x3e;
	}
    varbinds[0].oid = sysDescr;
    varbinds[0].len_oid = sizeof(sysDescr);
    varbinds[0].value = sysDescr;
    varbinds[0].type = NULL_VALUE;
    varbinds[0].len_val = 0;

    varbinds[1].oid = sysDeviceInfo;
    varbinds[1].len_oid = sizeof(sysDeviceInfo);
    varbinds[1].value = sysDescr;
    varbinds[1].len_val = 0;
    varbinds[1].type = NULL_VALUE;

    print_help(WAIT_RET);
    if (snmp(varbinds, 2, GET) <= 0) {
	print_help(ERR_RET);
	goto exit;
    }
    print_title(_("System Info"));

    mvwaddstr(main_sub, 0, 0, _("SysInfo:"));
    for (i = 0; i < varbinds[0].len_val && *(varbinds[0].value + i); i++) {
	mvwaddch(main_sub, 1, i + 1, *(varbinds[0].value + i));
    }
    wrefresh(main_sub);

/*    HardConf = (struct HARD_CONFIGURATION_STUCT *) varbinds[1].value;*/
    HardConf =
	(struct HARD_CONFIGURATION_STUCT *) malloc(varbinds[1].len_val);
    memcpy(HardConf, varbinds[1].value, varbinds[1].len_val);

    sprintf(message, MAC,
	    HardConf->MacAddress[0] & 0xFF, HardConf->MacAddress[1] & 0xFF,
	    HardConf->MacAddress[2] & 0xFF, HardConf->MacAddress[3] & 0xFF,
	    HardConf->MacAddress[4] & 0xFF,
	    HardConf->MacAddress[5] & 0xFF);
    mvwaddstr(main_sub, 2, 0, message);

    mvwaddstr(main_sub, 3, 0, _("Product Name:"));
    for (i = 0; i < 32 && *(HardConf->ProductName + i); i++) {
	mvwaddch(main_sub, 3, i + 14, *(HardConf->ProductName + i));
    }

    sprintf(message, _("ProductType: %u"), swap4(HardConf->ProductType));
    mvwaddstr(main_sub, 4, 0, message);

    sprintf(message, _("HardwareRevision: %u"),
	    swap4(HardConf->HardwareRevision));
    mvwaddstr(main_sub, 5, 0, message);


    mvwaddstr(main_sub, 6, 0, _("OEMName:"));
    for (i = 0; i < 32 && *(HardConf->OEMName + i); i++) {
	mvwaddch(main_sub, 6, i + 9, *(HardConf->OEMName + i));
    }

    sprintf(message, "OEMID: %u", swap4(HardConf->OEMID));
    mvwaddstr(main_sub, 7, 0, message);

	i = swap4(HardConf->RegulationDomain);
    sprintf(message, _("RegulationDomain: %s"),
	    (i == 0x10) ? _("FCC (USA)") :
	    (i == 0x20) ? _("DOC (Canada)") :
	    (i == 0x30) ? _("ETSI (Europe)") :
	    (i == 0x31) ? _("Spain") :
	    (i == 0x32) ? _("France") :
	    (i == 0x40) ? _("MKK (Japan)") : _("unknown"));
    mvwaddstr(main_sub, 8, 0, message);

    sprintf(message, _("StructVersion: %u"),
	    swap4(HardConf->StructVersion));
    mvwaddstr(main_sub, 9, 0, message);

    sprintf(message, _("Manufacturer OUI: %02X %02X %02X (%s)"),
	    HardConf->MacAddress[0] & 0xFF, HardConf->MacAddress[1] & 0xFF,
	    HardConf->MacAddress[2] & 0xFF,
	    oui2manufacturer(HardConf->MacAddress));
    mvwaddstr(main_sub, 10, 0, message);


    free(HardConf);
    wrefresh(main_sub);
    print_help(ANY_KEY);
  exit:
    getch();
    print_title("");
    clear_main(0);
}

int get_RegDomain()
{
    char oid_dot11CurrentRegDomain[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x01, 0x01, 0x02, 0x01 };
    varbind varbinds[1];

    varbinds[0].oid = oid_dot11CurrentRegDomain;
    varbinds[0].len_oid = sizeof(oid_dot11CurrentRegDomain);
    varbinds[0].value = oid_dot11CurrentRegDomain;
    varbinds[0].type = NULL_VALUE;
    varbinds[0].len_val = 0;

    if (snmp(varbinds, 1, GET) <= 0)
	return 0;
    return *(varbinds[0].value);

}

void nwn_sysinfo()
{
    char oid_mac[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x02, 0x01, 0x01, 0x01, 0x01 };
    char oid_manufacturerID[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x02, 0x01, 0x01, 0x08, 0x01 };
    char oid_productID[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x02, 0x01, 0x01, 0x09, 0x01 };
    char oid_dot11manufacturerOUI[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x03, 0x01, 0x02, 0x01, 0x01,
	0x01
    };
    char oid_dot11manufacturerName[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x03, 0x01, 0x02, 0x01, 0x02,
	0x01
    };
    char oid_dot11manufacturerProductName[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x03, 0x01, 0x02, 0x01, 0x03,
	0x01
    };
    char oid_dot11manufacturerProductVersion[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x03, 0x01, 0x02, 0x01, 0x04,
	0x01
    };
    char oid_dot11PHYType[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x01, 0x01, 0x01, 0x01 };
    char oid_dot11TempType[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x01, 0x01, 0x03, 0x01 };
    char oid_TxPowerLevel1[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x03, 0x01, 0x02, 0x01 };
    char oid_dot11PrivacyOptionImplemented[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x01, 0x01, 0x01, 0x07, 0x01 };
    char oid_dot11DiversitySupport[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x02, 0x01, 0x03, 0x01 };
    char oid_sysDescr[] =
	{ 0x2b, 0x06, 0x01, 0x02, 0x01, 0x01, 0x01, 0x00 };
    char oid_sysUptime[] =
	{ 0x2b, 0x06, 0x01, 0x02, 0x01, 0x01, 0x03, 0x00 };
    char oid_ip[] =
	{ 0x2b, 0x06, 0x01, 0x02, 0x01, 0x04, 0x14, 0x01, 0x01 };
    char *types[3] =
	{ _("FHSS 2.4 GHz"), _("DSSS 2.4 GHz"), _("IR Baseband") };
    char *temp[3] = { _("Commercial range 0..40 C"),
	_("Industrial range -30..70 C"),
	_("unknown")
    }, *diversity[3] = {
    _("manual"), _("notsupported"), _("dynamic")};

    char message[300];
    int i, hand, c, min, sec;
    struct in_addr ip;
    varbind varbinds[OID_NUM];
    size_t time_stamp;

    for (i = 0; i < OID_NUM; i++) {
	varbinds[i].value = oid_mac;
	varbinds[i].type = NULL_VALUE;
	varbinds[i].len_val = 0;
    }
    varbinds[0].oid = oid_mac;
    varbinds[0].len_oid = sizeof(oid_mac);
    varbinds[1].oid = oid_manufacturerID;
    varbinds[1].len_oid = sizeof(oid_manufacturerID);
    varbinds[2].oid = oid_productID;
    varbinds[2].len_oid = sizeof(oid_productID);
    varbinds[3].oid = oid_dot11manufacturerOUI;
    varbinds[3].len_oid = sizeof(oid_dot11manufacturerOUI);
    varbinds[4].oid = oid_dot11manufacturerName;
    varbinds[4].len_oid = sizeof(oid_dot11manufacturerName);
    varbinds[5].oid = oid_dot11manufacturerProductName;
    varbinds[5].len_oid = sizeof(oid_dot11manufacturerProductName);
    varbinds[6].oid = oid_dot11manufacturerProductVersion;
    varbinds[6].len_oid = sizeof(oid_dot11manufacturerProductVersion);
    varbinds[7].oid = oid_dot11PHYType;
    varbinds[7].len_oid = sizeof(oid_dot11PHYType);
    varbinds[8].oid = oid_dot11TempType;
    varbinds[8].len_oid = sizeof(oid_dot11TempType);
    varbinds[9].oid = oid_TxPowerLevel1;
    varbinds[9].len_oid = sizeof(oid_TxPowerLevel1);

    print_help(WAIT_RET);
    if (snmp(varbinds, OID_NUM - 1, GET) <= 0) {
	print_help(ERR_RET);
	goto exit;
    }
    print_title(_("System Info"));



    sprintf(message, MAC,
	    varbinds[0].value[0] & 0xFF, varbinds[0].value[1] & 0xFF,
	    varbinds[0].value[2] & 0xFF, varbinds[0].value[3] & 0xFF,
	    varbinds[0].value[4] & 0xFF, varbinds[0].value[5] & 0xFF);
    mvwaddstr(main_sub, 0, 0, message);

    mvwaddstr(main_sub, 3, 0, _("Manufacturer:"));
    i = 0;
    while (varbinds[4].len_val > i) {
	mvwaddch(main_sub, 3, i + 20, *(varbinds[4].value + i++));
    }

    mvwaddstr(main_sub, 4, 0, _("Manufacturer ID:"));
    i = 0;
    while (varbinds[1].len_val > i) {
	mvwaddch(main_sub, 4, i + 20, *(varbinds[1].value + i++));
    }

    sprintf(message, _("Manufacturer OUI: %02X %02X %02X (%s)"),
	    varbinds[3].value[0] & 0xFF, varbinds[3].value[1] & 0xFF,
	    varbinds[3].value[2] & 0xFF,
	    oui2manufacturer(varbinds[3].value));
    mvwaddstr(main_sub, 5, 0, message);

    sprintf(message, _("Product Name:"));
    mvwaddstr(main_sub, 6, 0, message);
    i = 0;
    while (varbinds[5].len_val > i) {
	mvwaddch(main_sub, 6, i + 20, *(varbinds[5].value + i++));
    }

    sprintf(message, _("Product ID:"));
    mvwaddstr(main_sub, 7, 0, message);
    i = 0;
    while (varbinds[2].len_val > i) {
	mvwaddch(main_sub, 7, i + 20, *(varbinds[2].value + i++));
    }
    sprintf(message, _("Product Version:"));
    mvwaddstr(main_sub, 8, 0, message);
    i = 0;
    while (varbinds[6].len_val > i) {
	mvwaddch(main_sub, 8, i + 20, *(varbinds[6].value + i++));
    }


    sprintf(message, _("PHYType: %s"), types[*(varbinds[7].value) - 1]);
    mvwaddstr(main_sub, 9, 0, message);

    sprintf(message, _("Temperature: %s"), temp[*(varbinds[8].value) - 1]);
    mvwaddstr(main_sub, 10, 0, message);

    if ((i = get_RegDomain()) == 0) {
	print_help(ERR_RET);
	goto exit;
    }
    sprintf(message, _("Regulation Domain: %s"),
	    (i == 0x10) ? _("FCC (USA)") :
	    (i == 0x20) ? _("DOC (Canada)") :
	    (i == 0x30) ? _("ETSI (Europe)") :
	    (i == 0x31) ? _("Spain") :
	    (i == 0x32) ? _("France") :
	    (i == 0x40) ? _("MKK (Japan)") : _("unknown"));
    mvwaddstr(main_sub, 11, 0, message);

    sprintf(message, _("Transmit Power: %u mW"), *(varbinds[9].value));
    mvwaddstr(main_sub, 12, 0, message);

    varbinds[0].oid = oid_dot11PrivacyOptionImplemented;
    varbinds[0].len_oid = sizeof(oid_dot11PrivacyOptionImplemented);
    varbinds[0].value = oid_mac;
    varbinds[0].type = NULL_VALUE;
    varbinds[0].len_val = 0;
    varbinds[1].oid = oid_dot11DiversitySupport;
    varbinds[1].len_oid = sizeof(oid_dot11DiversitySupport);
    varbinds[1].value = oid_mac;
    varbinds[1].type = NULL_VALUE;
    varbinds[1].len_val = 0;
    varbinds[2].oid = oid_sysDescr;
    varbinds[2].len_oid = sizeof(oid_sysDescr);
    varbinds[2].value = oid_mac;
    varbinds[2].type = NULL_VALUE;
    varbinds[2].len_val = 0;
    varbinds[3].oid = oid_sysUptime;
    varbinds[3].len_oid = sizeof(oid_sysUptime);
    varbinds[3].value = oid_mac;
    varbinds[3].type = NULL_VALUE;
    varbinds[3].len_val = 0;

    print_help(WAIT_RET);
    if (snmp(varbinds, 4, GET) <= 0) {
	print_help(ERR_RET);
	goto exit;
    }

    sprintf(message, _("WEP inplemented: %s"),
	    (*(varbinds[0].value) == 1) ? ON : OFF);
    mvwaddstr(main_sub, 13, 0, message);
    sprintf(message, _("Diversity: %s"),
	    diversity[*(varbinds[1].value) - 1]);
    mvwaddstr(main_sub, 14, 0, message);
    mvwaddstr(main_sub, LINES - 8, 0, SYS_DESCR);
    i = 0;
    while (varbinds[2].len_val > i && varbinds[2].value[i]) {
	message[i] = varbinds[2].value[i];
	i++;
    }
    message[i] = '\0';
    mvwaddstr(main_sub, LINES - 8, strlen(SYS_DESCR) + 1, message);

    time_stamp = 0;
    i = 1;

    for (c = 1; c <= varbinds[3].len_val; c++) {
	time_stamp +=
	    (unsigned char) varbinds[3].value[varbinds[3].len_val - c] * i;
	i *= 256;
    }

    hand = time_stamp % 100;
    time_stamp = time_stamp / 100;
    sec = time_stamp % 60;
    time_stamp = time_stamp / 60;
    min = time_stamp % 60;
    time_stamp = time_stamp / 60;

    sprintf(message, _("Uptime: %u:%02u:%02u.%02u"), time_stamp, min, sec,
	    hand);
    mvwaddstr(main_sub, 15, 0, message);

    varbinds[0].oid = oid_ip;
    varbinds[0].len_oid = sizeof(oid_ip);
    varbinds[0].value = oid_mac;
    varbinds[0].type = NULL_VALUE;
    varbinds[0].len_val = 0;

    print_help(WAIT_RET);
    if (snmp(varbinds, 1, GET_NEXT) <= 0) {
	print_help(ERR_RET);
	goto exit;
    }
    memcpy(&ip.s_addr, varbinds[0].value, 4);
    sprintf(message, _("IP  Address: %s"), inet_ntoa(ip));
    mvwaddstr(main_sub, 1, 0, message);

    wrefresh(main_sub);
    print_help(ANY_KEY);
  exit:
    getch();
    print_title("");
    clear_main(0);
}
