/*
 *      scr.c from Access Point SNMP Utils for Linux
 *	program screen operate functions
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
#include <stdlib.h>
#include <ncurses.h>
#include <menu.h>
#include <string.h>
#include "ap-utils.h"

extern WINDOW *main_sub, *win_for_help, *main_win;

void
scroll_rows(struct MacListStat *first, int begin, int end, int row,
	    int stat)
{
    int i = 1;
    struct MacListStat *curr = first;
    char message[50];

    clear_main(3);

    while (i++ < begin)
	curr = curr->next;
    i = 0;
    while (end-- > begin) {
	if (stat)
	    sprintf(message,
		    "%5u       %02X%02X%02X%02X%02X%02X     %3u%5u   %3u",
		    begin + i, curr->addr[0] & 0xFF, curr->addr[1] & 0xFF,
		    curr->addr[2] & 0xFF, curr->addr[3] & 0xFF,
		    curr->addr[4] & 0xFF, curr->addr[5] & 0xFF,
		    curr->quality, curr->idle, curr->rssi);
	else
	    sprintf(message, "%5u       %02X%02X%02X%02X%02X%02X",
		    begin + i, curr->addr[0] & 0xFF, curr->addr[1] & 0xFF,
		    curr->addr[2] & 0xFF, curr->addr[3] & 0xFF,
		    curr->addr[4] & 0xFF, curr->addr[5] & 0xFF);
	mvwaddstr(main_sub, row + i, 3, message);
	i++;
	curr = curr->next;
    }
    wrefresh(main_sub);

}

void print_help(char *mess)
{
    unsigned short int j, len = (COLS - strlen(mess))/2;

    werase(win_for_help);

    for (j = 0; j <= len; j++) {
	mvwaddch(win_for_help, 0, j, ' ');
	mvwaddch(win_for_help, 0, COLS - j - 1, ' ');
    }
    
    mvwaddstr(win_for_help, 0, len, mess);
    wrefresh(win_for_help);
}

void print_title(char *mess)
{
    int i;
    /*   */
    for (i = 0; i < COLS - MCOLS - 1; i++)
	mvwaddch(main_win, 0, i, ACS_BSBS);
    wattrset(main_win, A_BOLD);
    mvwaddstr(main_win, 0, COLS - MCOLS - strlen(mess) - 1, mess);
    wattrset(main_win, A_NORMAL);
    wrefresh(main_win);
}

void print_bottom(char *mess)
{
    int i;
    char message[100];
    extern short ap_type;
    extern char *ap_types[];

    sprintf(message, _("Current AP: %s Type: %s"), mess, ap_types[ap_type]);
    /*   */
    for (i = 0; i < COLS - MCOLS - 1; i++)
	mvwaddch(main_win, LINES - 3, i, ACS_BSBS);
    wattrset(main_win, A_BOLD);
    mvwaddstr(main_win, LINES - 3, COLS - MCOLS - strlen(message) - 1,
	      message);
    wattrset(main_win, A_NORMAL);
    wrefresh(main_win);
}


void clear_main(int m)
{
    clear_main_new(m, LINES - 4);
}

void clear_main_new(int m, int n)
{
    int i, j;
    wmove(main_sub, m, 0);
    for (i = m; i < n; i++)
	for (j = 0; j < COLS - MCOLS - 1; j++)
	    waddch(main_sub, ' ');
    wrefresh(main_sub);
}
