#! /usr/bin/perl -w
#
# Generate the fontinformation tables for the required fonts (Linux version)
#

@charnames = ("space", "exclamdown", "cent", "sterling", "currency",
"yen", "brokenbar", "section", "dieresis", "copyright",
"ordfeminine", "guillemotleft", "logicalnot", "hyphen", "registered",
"macron", "degree", "plusminus", "twosuperior", "threesuperior",
"acute", "mu", "paragraph", "periodcentered", "cedilla",
"onesuperior", "ordmasculine", "guillemotright", "onequarter",
"onehalf", "threequarters", "questiondown", "Agrave", "Aacute",
"Acircumflex", "Atilde", "Adieresis", "Aring", "AE", "Ccedilla",
"Egrave", "Eacute", "Ecircumflex", "Edieresis", "Igrave", "Iacute",
"Icircumflex", "Idieresis", "Eth", "Ntilde", "Ograve", "Oacute",
"Ocircumflex", "Otilde", "Odieresis", "multiply", "Oslash",
"Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn",
"germandbls", "agrave", "aacute", "acircumflex", "atilde",
"adieresis", "aring", "ae", "ccedilla", "egrave", "eacute",
"ecircumflex", "edieresis", "igrave", "iacute", "icircumflex",
"idieresis", "eth", "ntilde", "ograve", "oacute", "ocircumflex",
"otilde", "odieresis", "divide", "oslash", "ugrave", "uacute",
"ucircumflex", "udieresis", "yacute", "thorn", "ydieresis" );

$gs_dir = '/usr/share/ghostscript/fonts';
@names = ( "Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique",
"Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic",
"Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique" );
@files = ( "n022003l.afm", "n022004l.afm", "n022023l.afm", "n022024l.afm",
	"n021003l.afm", "n021004l.afm", "n021023l.afm", "n021024l.afm",
	"n019003l.afm", "n019004l.afm", "n019023l.afm", "n019024l.afm" );

if ($#names != $#files) {
	die "names-array and files-array are of unequel length";
}

printf STDOUT "/* THIS FILE IS AUTOMATICALLY GENERATED - DO NOT EDIT! */\n";

# Generate the array with the fontnames
printf STDOUT "static const char *szFontnames[%d] = {\n", $#names + 1;
for ($n = 0; $n <= $#names; $n++) {
	printf STDOUT "\t\"%s\",\n", $names[$n];
}
print "};\n";

# Generate the array with the character widths
printf STDOUT "static int aiCharacterWidths[%d][256] = {\n", $#files + 1;
for ($n = 0; $n <= $#files; $n++) {
	$file = $files[$n];
	$name = $names[$n];
	open(F_IN, "<$gs_dir/$file") || die "Cannot open $gs_dir/$file";
	printf STDOUT "\t{\t/* %s */\n", $name;
	while (<F_IN>) {
		chop();
		@a = split(/\s+/);
		if ($a[0] eq 'UnderlinePosition') {
			$underlineposition[$n] = $a[1];
		} elsif ($a[0] eq 'UnderlineThickness') {
			#printf STDOUT "%d %d\n", $a[0], $a[1];
			$underlinethickness[$n] = $a[1];
		} elsif ($a[0] eq 'C' && $a[2] eq ';' && $a[3] eq 'WX') {
			#printf STDOUT "%d %d %s\n", $a[1], $a[4], $a[7];
			if ($a[1] >= 0 && $a[1] <= 255 &&
			    !defined($charwidth[$a[1]])) {
				$charwidth[$a[1]] = $a[4];
			}
		}
		if (defined($a[7])) {
			for ($i = 0; $i <= $#charnames; $i++) {
				if ($charnames[$i] eq $a[7]) {
					$charwidth[160 + $i] = $a[4];
					last;
				}
			}
		}
	}
	close(F_IN);

	# Set the width of coltrol and undefined characters to zero
	for ($i = 0; $i < 32; $i++) {
		$charwidth[$i] = 0;
	}
	for ($i = 127; $i < 160; $i++) {
		$charwidth[$i] = 0;
	}

	# Print the results
	for ($i = 0; $i < 256; $i += 8) {
		printf STDOUT "\t/* %3d */ ", $i;
		for ($j = 0; $j < 8; $j++) {
			if (defined($charwidth[$i + $j])) {
				printf STDOUT "%5d,", $charwidth[$i + $j];
			} else {
				printf STDOUT " leeg,";
			}
		}
		printf STDOUT "\n";
	}
	printf STDOUT "\t},\n";

	undef @charwidth
}
print "};\n";

# Generate the array with the underline information
printf STDOUT "static int aiUnderlineInfo[%d][2] = {\n", $#names + 1;
for ($n = 0; $n <= $#names; $n++) {
	if (!defined($underlineposition[$n])) {
		$underlineposition[$n] = 0;
	}
	printf STDOUT "\t{ %d,", $underlineposition[$n];
	if (!defined($underlinethickness[$n])) {
		$underlinethickness[$n] = 0;
	}
	printf STDOUT " %d },\n", $underlinethickness[$n];
}
print "};\n";

exit 0;
