/***             analog 5.1             http://www.analog.cx/             ***/
/*** This program is copyright (c) Stephen R. E. Turner 1995 - 2001 except as
 *** stated otherwise. Distribution, usage and modification of this program is
 *** subject to the conditions of the Licence which you should have received
 *** with it. This program comes with no warranty, expressed or implied.   ***/

/*** anlghea4.h: fourth header file ***/

/*** Just function declarations: these are not user-definable; user-definable
 *** options can be found in anlghead.h ***/

#ifndef ANLGHEA4_H
#define ANLGHEA4_H

/* in alias.c */
extern choice do_alias(char *name, Memman *mp, Alias *aliashead,
  char *dirsuffix, unsigned int dirsufflength, logical usercase_insensitive,
  unsigned char convfloor, logical multibyte, choice type);
extern void do_aliasx(char *name, Alias *aliashead);
extern void do_aliasrep(char *name, Alias *aliashead, logical multibyte);
extern logical do_aliasr(char *name, char *dirsuffix,
  unsigned int dirsufflength);
extern logical do_aliasS(char *name);
extern logical do_aliasf(char *name);
extern logical do_aliasB(char *name);
extern logical do_aliasu(char *name, logical case_insensitive);
extern logical do_aliasv(char *name);
extern logical do_aliasN(char *name, unsigned char convfloor,
  logical multibyte);
extern logical do_aliasn(char *name, unsigned char convfloor,
  logical multibyte);
extern logical do_aliasb(char *name);
#ifndef NODNS
extern logical dnsresolve(char *name, choice level);
extern void do_dns(char *name, char *alias, choice level);
#endif
extern void wildalias(char *name, AliasTo *to, ptrdiff_t pmatch[]);
extern choice prealias(Memman *mm, Memman *mmv, Hashentry *vhost, Memman *mmq,
  logical case_insensitive, char *prefix, size_t prefixlen, int pvpos,
  Include *argshead);
extern void prealiasS(Memman *mm, Memman *mms);
extern void reverseonename(Hashindex *p);
extern void reversenames(Hashindex *ans);

/* in analog.c -- only main() */

/* in cache.c */
extern void outputcache(char *outfile, Hashindex **gooditems, Dateman *dman,
  Arraydata **arraydata, unsigned long *data, double bys,
  choice data2cols[ITEM_NUMBER][DATA_NUMBER]);
extern void hashbuild(choice code, unsigned long *data, double bys, Memman *mm,
  Hashtable **hash, unsigned int data_number,
  choice datacols[OUTCOME_NUMBER][DATACOLS_NUMBER][2], choice data2cols[],
  Include *wanthead, Include *ispagehead, Tree **tree,
  Derv **derv, choice *alltrees, choice *alldervs, choice lowmem,
  char *dirsuffix, unsigned int dirsufflength, logical usercase_insensitive,
  unsigned char convfloor, logical multibyte);
extern void corruptcacheline(char *line, choice *rc, choice type);
extern logical parsecacheline(char *linestart, char *parsestart,
  unsigned int *code, unsigned int maxcode, int no_items, unsigned long *data,
  double *bys, Memman *mm);
extern void readoldcache(Filelist *cachefilep, FILE *lf, Dateman *dman,
  choice type, unsigned int granularity);
extern void readcache(Filelist *cachefilep, FILE *lf, Hashtable **hash,
  unsigned int *no_cols,
  choice datacols[ITEM_NUMBER][OUTCOME_NUMBER][DATACOLS_NUMBER][2],
  choice data2cols[ITEM_NUMBER][DATA_NUMBER],
  Arraydata **arraydata, Include **wanthead, Include *ispagehead,
  Dateman *dman, Tree **tree, Derv **derv, choice *alltrees,
  choice *alldervs, choice *lowmem, char *dirsuffix,
  unsigned int dirsufflength, logical usercase_insensitive,
  unsigned char convfloor, logical multibyte, unsigned int granularity);

/* in dates.c */
extern void code2date(datecode_t code, unsigned int *date, unsigned int *month,
  unsigned int *year);
extern time_t shifttime(time_t timer, int diff);
extern choice parsedate(time_t starttime, char *s, timecode_t *date,
  logical from, logical unixtime);
extern choice wantdate(timecode_t *timecode, Dateman *dman, unsigned int hr,
  unsigned int min, unsigned int date, unsigned int month, unsigned int year,
  int tz);
extern choice wantunixtime(timecode_t *timecode, Dateman *dman,
  unsigned long unixtime, int tz);
extern Daysdata *newday(unsigned int granularity);
extern void dmaninit(Dateman *dman, datecode_t datecode,
  unsigned int granularity);
extern void datehash(timecode_t timecode, Dateman *dman, unsigned long reqs,
  unsigned long pages, double bytes, unsigned int granularity);

/* in globals.c */
extern void globals(char *comnane);
extern void defaults(Options *op);

/* in hash.c */
extern Hashtable *rehash(Hashtable *old, unsigned long size,
  Memman *treespace);
extern Hashindex *hashfind(Memman *mp, Hashtable **table,
  unsigned int data_number, Include *wanthead,
  choice ispage, Include *ispagehead, Alias *aliashead, char *dirsuffix,
  unsigned int dirsufflength, logical usercase_insensitive,
  unsigned char convfloor, logical multibyte, choice type, logical aliased);
extern Hashentry *newhashentry(unsigned int data_number, logical ispage);
extern void hashscore(Hashentry *ep, unsigned long data[DATA2_NUMBER],
  choice datacols[DATACOLS_NUMBER][2], choice outcome, double bytes);
extern void unhash(Hashtable *hash, Hashindex **gooditems,
  Hashindex **baditems);
extern void unhashall(Hashtable **hash, Hashindex ***gooditems,
  Hashindex ***baditems);

/* in init.c */
extern void initialise(int argc, char *argv[], Options *op);
extern void confline(Options *op, char *cmd, char *arg1, char *arg2, int rc);
extern choice config(char *filename, Options *op);
extern void settings(Options *op, int argc, char *argv[]);
extern Inputformatlist *correctlogfmt(Filelist *lp, Include **wanthead,
  choice *code2type, Dateman *dman);
extern void correct(Options *op);
extern void finalinit(Options *op);
extern choice strtoinfmt(Inputformat **ans, char *s, choice *count);
extern char *apachelogfmt(char *fmt);
extern void clconfline(Options *op, char *s);
extern void clgenrep(Options *op, choice rep, char *arg);
extern void cldebug(char **s, char *arg);
extern void clargs(Options *op, int argc, char *argv[]);

/* in init2.c */
extern void shortwarn(char *cmd, char *arg1, int rc);
extern void longwarn(char *cmd, char *arg1, char *arg2, int rc);
extern void badwarn(char *cmd, choice domess, char *arg1, char *arg2, int rc);
extern void unknownwarn(char *cmd, char *arg1, char *arg2);
extern void configcall(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configcols(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configallcols(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configchoice(void *opt, char *cmd, char *arg1, char *arg2, int rc);
#ifndef NOGRAPHICS
extern void configallchart(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
#endif
extern void configdebug(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configall(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configallback(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configlang(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void selectlang(char *country, Outchoices *op);
extern void configlogfmt(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configapachelogfmt(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configrepord(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configstr(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configstrlist(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configerrfile(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
#ifndef NODIRENT
extern Filelist *clonelogs(Filelist *from, char *name);
extern Filelist *expandwildlogs(Filelist *lp, Filelist **pter);
#endif
extern void configlogfile(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configcachefile(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configchar(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configbarstyle(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configgraph(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configallgraph(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configfloor(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configtree(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configulong(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configuint(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configoffset(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configlowmem(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern int aliastocount(char *s);
extern AliasTo *configaliasto(char *s, logical is_regex);
extern void configalias(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configstrpair(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configstrpairlist(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configstrpair2list(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configdomlevel(void *opt, char *cmd, char *arg1, char *arg2,
  int rc);
extern void configinex(void *opt, char *cmd, char *arg1, char *arg2, int rc,
  logical in, logical omitinitdot, logical omittrailslash);
extern void configinc(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configexc(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configincd(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configexcd(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configincs(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configexcs(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configscinex(void *opt, char *cmd, char *arg1, char *arg2, int rc,
  logical in);
extern void configscinc(void *opt, char *cmd, char *arg1, char *arg2, int rc);
extern void configscexc(void *opt, char *cmd, char *arg1, char *arg2, int rc);

/* in input.c */
extern FILE *my_lfopen(Filelist *p, char *logtype);
extern FILE *my_fopen(char *name, char *logtype);
extern int my_lfclose(FILE *f, Filelist *p, Filelist *allc, Filelist *allp,
  char *filetype, Dateman *dman, unsigned long *totdata, double *bys,
  double *bys7);
extern int my_fclose(FILE *f, char *name, char *filetype);
extern FILE *logfile_init(Filelist *logfilep);
extern choice getmoredata(FILE *f, char *start, size_t length);
extern choice getnextline(FILE *f, char *start, size_t used);
extern void shunt_data(FILE *f);
extern int strtomonth(char *month);
extern choice parsemonth(FILE *f, void *arg, char c);
extern choice parseuint2(FILE *f, void *arg, char c);
extern choice parsenmonth(FILE *f, void *arg, char c);
extern choice parseulong(FILE *f, void *arg, char c);
extern choice parseproctime(FILE *f, void *arg, char c);
extern choice parseuint2strict(FILE *f, void *arg, char c);
extern choice parsescode(FILE *f, void *arg, char c);
extern choice parseuint4strict(FILE *f, void *arg, char c);
extern choice parseudint(FILE *f, void *arg, char c);
extern choice parseyear2(FILE *f, void *arg, char c);
extern choice parseyear2or4(FILE *f, void *arg, char c);
extern choice parseam(FILE *f, void *arg, char c);
extern choice parsecode(FILE *f, void *arg, char c);
extern choice parsejunk(FILE *f, void *arg, char c);
extern choice parsespace(FILE *f, void *arg, char c);
extern choice parseoptspace(FILE *f, void *arg, char c);
extern choice parsenewline(FILE *f, void *arg, char c);
extern void parsenonnewline(FILE *f);
extern choice parsestring(FILE *f, void *arg, char c);
extern choice parsemsbrow(FILE *f, void *arg, char c);
extern choice parseref(FILE *f, void *arg, char c);
extern choice checkchar(FILE *f, void *arg, char c);
extern void resolveconflicts(unsigned int n, char *delims, ...);
extern choice parselogfmt(FILE *f, void *arg, char c);
extern choice parsenextrecord(FILE *f, Inputformat *format);
extern int parseconfline(char *s, char **cmd, char **arg1, char **arg2);
extern int nextconfline(FILE *f, char **cmd, char **arg1, char **arg2);
extern char *nextlngstr(FILE *f, char *name, logical want);
extern choice nextdnsline(FILE *f, timecode_t *timec, char **name,
  char **alias);
extern void process_domainsfile(FILE *f, Options *op);
extern void process_descfile(FILE *f, char *name, Options *op);

/* in macstuff.c (See also macdir.h) */
#ifdef MAC_EVENTS
extern void MacInit(int *argc, char **argv[]);
extern void MacFini(void);
extern void MacIdle(void);
#endif
#ifdef MACDIRENT
extern void CToPCpy(unsigned char *pstr, const char *cstr);
#endif
#ifdef MAC
#ifndef NODNS
extern long OpenNetwork(void);
extern int IpAddr2Name(char *hostname);
extern void ResolverCleanup(void);
extern pascal void SvcNotifyProc(void *dataPtr, OTEventCode code,
  OTResult result, void *cookie);
extern pascal void MacTCPDNRResultProc(struct hostInfo *hInfoPtr,
  char *userDataPtr);
#endif
#endif

/* in output.c */
extern void pagetop(FILE *outf, Outchoices *od, Dateman *dman);
extern void pagebot(FILE *outf, Outchoices *od);
extern void gensum(FILE *outf, Outchoices *od, unsigned long *data, double bys,
  double bys7, Hashindex **gooditems, Hashindex **baditems, Dateman *dman,
  choice data2cols[ITEM_NUMBER][DATA_NUMBER]);
extern void timerep(FILE *outf, Outchoices *od, choice rep, Dateman *dman,
  unsigned int granularity);
extern void timesum(FILE *outf, Outchoices *od, choice rep, Dateman *dman,
  unsigned int granularity);
extern void printtree(FILE *outf, Outchoices *od, choice rep, Hashtable *tree,
  choice requests, choice requests7, choice pages, choice pages7, choice date,
  choice firstd, unsigned int level, Strlist *partname, unsigned long totr,
  unsigned long totr7, unsigned long totp, unsigned long totp7, double totb,
  double totb7, unsigned int width[], logical possrightalign,
  unsigned int bmult, unsigned int bmult7, double unit);
extern void genrep(FILE *outf, Outchoices *od, choice rep,
  Hashindex **gooditems, Hashindex **baditems,
  choice datacols[OUTCOME_NUMBER][DATACOLS_NUMBER][2], choice *data2cols,
  unsigned int data_number, Dateman *dman);
extern void dervrep(FILE *outf, Outchoices *od, choice rep,
  Hashindex *gooditems, Hashindex *baditems,
  choice datacols[OUTCOME_NUMBER][DATACOLS_NUMBER][2], choice *data2cols,
  unsigned int data_number, Dateman *dman);
extern void arrayrep(FILE *outf, Outchoices *od, choice rep, Arraydata *array,
  Dateman *dman);
extern void output(Outchoices *od, Hashindex **gooditems, Hashindex **baditems,
  Dateman *dman, Arraydata **arraydata, unsigned long *sumdata,
  double totbytes, double totbytes7,
  choice datacols[ITEM_NUMBER][OUTCOME_NUMBER][DATACOLS_NUMBER][2],
  choice data2cols[ITEM_NUMBER][DATA_NUMBER], unsigned int *no_cols,
  unsigned int granularity);

/* in output2.c */
extern void gotos(FILE *outf, Outchoices *od, choice rep);
extern void report_title(FILE *outf, Outchoices *od, choice rep);
extern void reportspan(FILE *outf, Outchoices *od, choice rep, timecode_t maxd,
  timecode_t mind, Dateman *dman); 
extern size_t htmlstrlen_normal(char *s, choice outstyle);
extern size_t htmlstrlen_utf8(char *s, choice outstyle);
extern size_t htmlstrlen_jis(char *s, choice outstyle);
extern void matchlength(FILE *outf, choice outstyle, char *s, char c);
extern void myputc(FILE *outf, char c, choice outstyle);
extern void htmlfprintf(FILE *outf, Outchoices *od, logical multibyte,
  char *s, logical userinput);
extern void latexfprintf(FILE *outf, char *s);
extern void escfprintf(FILE *outf, char *name);
extern void hrule(FILE *outf, Outchoices *od);
extern void include_file(FILE *outf, Outchoices *od, char *name, char type);
extern size_t datefmtlen(Outchoices *od, char *fmt);
extern char *datesprintf(Outchoices *od, char *fmt, datecode_t date,
  unsigned int hr, unsigned int min, datecode_t newdate, unsigned int newhr,
  unsigned int newmin, logical running, choice allowmonth); 
extern char *timesprintf(Outchoices *od, char *fmt, timecode_t t,
  choice allowmonth);
extern int f3printf(FILE *outf, choice outstyle, double x, unsigned int width,
  char sepchar);
extern void printbytes(FILE *outf, Outchoices *od, double bytes,
  unsigned int bmult, unsigned int width, char sepchar);
extern void doublemprintf(FILE *outf, choice outstyle, unsigned int pagewidth,
  double x, char decpt);
extern double findunit(Outchoices *od, double n, unsigned int width[],
  choice *cols);
extern void calcsizes(Outchoices *od, choice rep, unsigned int width[],
  unsigned int *bmult, unsigned int *bmult7, double *unit, unsigned long maxr,
  unsigned long maxr7, unsigned long maxp, unsigned long maxp7, double maxb,
  double maxb7, unsigned long howmany);
extern unsigned int alphatreewidth(Outchoices *od, choice rep, Hashtable *tree,
  unsigned int level, Strlist *partname);
extern void declareunit(FILE *outf, Outchoices *od, char graphby, double unit,
  unsigned int bmult);
extern void whatincluded(FILE *outf, Outchoices *od, choice rep,
  unsigned long n, Dateman *dman);
extern void busyprintf(FILE *outf, Outchoices *od, choice rep, char *datefmt,
  unsigned long reqs, unsigned long pages, double bys, datecode_t date,
  unsigned int hr, unsigned int min, datecode_t newdate, unsigned int newhr,
  unsigned int newmin, char graphby);
extern void pccol(FILE *outf, Outchoices *od, double n, double tot,
  unsigned int width);
extern void barchart(FILE *outf, Outchoices *od, char graphby,
  unsigned long reqs, unsigned long pages, double bys, double unit);
extern void colheads(FILE *outf, Outchoices *od, choice rep,
  unsigned int width[], unsigned int bmult, unsigned int bmult7,
  logical name1st);
extern char printcols(FILE *outf, Outchoices *od, choice rep,
  unsigned long reqs, unsigned long reqs7, unsigned long pages,
  unsigned long pages7, double bys, double bys7, long index, int level,
  unsigned long totr, unsigned long totr7, unsigned long totp,
  unsigned long totp7, double totb, double totb7, unsigned int width[],
  unsigned int bmult, unsigned int bmult7, double unit, logical name1st,
  logical rightalign, char *name, logical ispage, unsigned int spaces,
  Include *linkhead, char *baseurl, char *datefmt, char *timefmt,
  datecode_t date, unsigned int hr, unsigned int min, datecode_t date2,
  unsigned int hr2, unsigned int min2);
extern void lastseven(FILE *outf, Outchoices *od, timecode_t last7to);
extern void distcount(Hashindex *gooditems, Hashindex *baditems,
  choice requests, choice requests7, unsigned long *tot, unsigned long *tot7);
extern void gensumline(FILE *outf, Outchoices *od, char codeletter,
  int namecode, unsigned long x, unsigned long x7, logical p);
extern void gensumlineb(FILE *outf, Outchoices *od, char codeletter,
  int namecode, double x, double x7);
extern logical checkonerep(Outchoices *od, Hashindex *gp, choice rep,
  choice requests, cutfnp cutfn, dcutfnp dcutfn, void *darg);
extern logical checktreerep(Outchoices *od, Hashtable *tp, choice rep,
  choice requests, cutfnp cutfn);
extern logical checkarrayrep(Arraydata *array);
extern void checkreps(Outchoices *od, Dateman *dman, Hashindex **gooditems,
  Arraydata **arraydata, choice data2cols[ITEM_NUMBER][DATA_NUMBER]);
#ifndef NOGRAPHICS
extern FILE *piechart_init(char *filename);
extern void piechart_caption(FILE *outf, choice rep, choice chartby,
  char **lngstr);
extern int piechart_wedge(FILE *outf, Outchoices *od, double angle, char *s);
extern void piechart_key(FILE *outf, Outchoices *od, int col, char *s,
  char *extension);
extern void piechart_write(FILE *pieoutf, char *filename, logical jpegcharts);
extern void piechart(FILE *outf, Outchoices *od, choice rep, Hashindex *items,
  choice requests, choice requests7, choice pages, choice pages7,
  unsigned long totr, unsigned long totr7, unsigned long totp,
  unsigned long totp7, double totb, double totb7);
#endif

/* in process.c */
extern void process_data(Filelist *logfilep, FILE *lf, Hashtable **hash,
  Arraydata **arraydata, choice *count, choice *code2type,
  choice datacols[ITEM_NUMBER][OUTCOME_NUMBER][DATACOLS_NUMBER][2],
  choice data2cols[ITEM_NUMBER][DATA_NUMBER], unsigned int *no_cols,
  Include **wanthead, Include *ispagehead, Alias **aliashead,
  Include *argshead, Include *refargshead, Dateman *dman, Tree **tree,
  Derv **derv, choice *alltrees, choice *alldervs, choice *lowmem,
  logical case_insensitive, logical usercase_insensitive,
  unsigned char convfloor, logical multibyte, char *dirsuffix,
  unsigned int dirsufflength, unsigned int granularity);
extern void corrupt_line(FILE *lf, Filelist *logfilep, char *message,
  ptrdiff_t n);
extern void arrayscore(Arraydata *array, double amount, unsigned long reqs,
  unsigned long reqs7, unsigned long pages, unsigned long pages7, double bytes,
  double bytes7, timecode_t timecode); 

/* in settings.c */
extern void report_vbles(Options *op);
extern void report_compile(void);
extern void report_debug(char *type, char *arg, char *fullset);
extern void report_conffiles(Strlist *list);
extern void report_logfiles(Filelist *logfile, logical cache);
extern void report_logformat(FILE *outf, Inputformatlist *format,
  logical inwarn);
extern void report_fromto(Dateman *dman);
extern void report_want(Include *wanthead, char *type, char *indent);
extern void report_scwant(choice *code2type);
extern void report_alias(Alias *aliashead, char *type, char *indent);
extern void report_strpair(Strpair *head, char *type, char *connector);
extern void report_lowmem(choice lowmem[]);
#ifndef NODNS
extern void report_dns(void);
#endif
extern void report_outopts(Outchoices *od);
extern void report_sep(char c, char *type);
extern void report_daterep(Outchoices *od, choice j);
extern void report_genrep(Outchoices *od, choice j);
extern void report_cols(choice *cols);
extern void report_sortby(choice sortby, logical sub);
extern void report_floor(Floor *floor, logical sub);
#ifndef NOGRAPHICS
extern void report_chart(choice chartby);
#endif
extern void check_file(char *name);

/* in sort.c */
extern void calctotmax(Hashindex **gooditems, Hashindex **baditems,
  Strlist *partname, Strlist **newpn, Strlist *space, size_t need, choice rep,
  Include *wanthead, choice requests, choice requests7, choice pages,
  choice pages7, choice date, choice firstd, unsigned long *totr,
  unsigned long *totr7, unsigned long *totp, unsigned long *totp7,
  double *totb, double *totb7, unsigned long *maxr, unsigned long *maxr7,
  unsigned long *maxp, unsigned long *maxp7, double *maxb, double *maxb7,
  timecode_t *maxd, timecode_t *mind, logical donetots, logical nosort,
  Hashindex **ans3);
extern void calcfloor(unsigned long *min, double *dmin, choice *filterby,
  Floor *floor, choice requests, choice requests7, choice pages, choice pages7,
  choice date, choice firstd, unsigned long totr, unsigned long totr7,
  unsigned long totp, unsigned long totp7, double totb, double totb7,
  unsigned long maxr, unsigned long maxr7, unsigned long maxp,
  unsigned long maxp7, double maxb, double maxb7);
extern void makebadpn(Hashentry **badp, unsigned long *badn, Hashindex *ans2,
  choice requests, choice requests7, choice pages, choice pages7, choice date,
  choice firstd, unsigned long *maxr, unsigned long *maxr7,
  unsigned long *maxp, unsigned long *maxp7, double *maxb, double *maxb7,
  logical donetots);
extern void my_sort(Hashindex **gooditems, Hashindex **baditems,
  Strlist *partname, Strlist **newpn, Strlist *space, size_t need, choice rep,
  Floor *floor, choice sortby, logical alphaback, Include *wanthead,
  choice requests, choice requests7, choice pages, choice pages7, choice date,
  choice firstd, unsigned long *totr, unsigned long *totr7,
  unsigned long *totp, unsigned long *totp7, double *totb, double *totb7,
  unsigned long *maxr, unsigned long *maxr7, unsigned long *maxp,
  unsigned long *maxp7, double *maxb, double *maxb7, timecode_t *maxd,
  timecode_t *mind, logical donetots, Hashentry **badp, unsigned long *badn,
  logical nosort);
extern Hashindex *my_mergesort(Hashindex *list, unsigned long length,
  choice sortby, mergefnp mergefn);
extern Hashindex *merge(Hashindex *list1, Hashindex *list2,
  unsigned long length1, unsigned long length2, choice sortby);
extern Hashindex *mergea(Hashindex *list1, Hashindex *list2,
  unsigned long length1, unsigned long length2, choice sortby);
extern Hashindex *mergeb(Hashindex *list1, Hashindex *list2,
  unsigned long length1, unsigned long length2, choice sortby);
extern Hashindex *mergeb7(Hashindex *list1, Hashindex *list2,
  unsigned long length1, unsigned long length2, choice sortby);

/* in tree.c */
extern Hashindex *treefind(char *name, char *nameend, Hashtable **tree,
  Hashindex *item, cutfnp cutfn, logical build, logical transient,
  logical reuse, Memman *space,
  choice datacols[OUTCOME_NUMBER][DATACOLS_NUMBER][2],
  unsigned int data_number);
extern void graft(Hashtable **new, Hashtable *old, Memman *space,
  unsigned int data_number);
extern void allgraft(Hashtable *t, Memman *space, unsigned int data_number);
extern Hashindex *newtreeentry(char *name, char *nameend, Hashindex *item,
  logical transient, logical reuse, Memman *space, unsigned int data_number);
extern Hashentry *newtreedata(Hashentry *from, Memman *space,
  unsigned int data_number);
extern void treescore(Hashentry *to, Hashentry *from,
  choice datacols[OUTCOME_NUMBER][DATACOLS_NUMBER][2]);
extern Hashindex *sorttree(Outchoices *od, Hashtable *tree, choice rep,
  Floor *floor, choice sortby, Floor *subfloor, choice subsortby,
  logical alphaback, unsigned int level, Strlist *partname, Alias *notcorrupt,
  choice requests, choice requests7, choice pages, choice pages7, choice date,
  choice firstd, unsigned long *totr, unsigned long *totr7,
  unsigned long *totp, unsigned long *totp7, double *totb, double *totb7,
  unsigned long *maxr, unsigned long *maxr7, unsigned long *maxp,
  unsigned long *maxp7, double *maxb, double *maxb7, timecode_t *maxd,
  timecode_t *mind, Hashentry **badp, unsigned long *badn, Memman *space,
  choice datacols[OUTCOME_NUMBER][DATACOLS_NUMBER][2]);
extern void maketree(Tree *treex, Hashindex *gooditems, Hashindex *baditems,
  choice datacols[OUTCOME_NUMBER][DATACOLS_NUMBER][2],
  unsigned int data_number);
extern void makederived(Derv *derv, Hashindex *gooditems, Hashindex *baditems,
  unsigned char convfloor, logical multibyte, choice rep,
  choice datacols[OUTCOME_NUMBER][DATACOLS_NUMBER][2],
  unsigned int data_number);
extern char *maketreename(Strlist *pn, Hashindex *p, Strlist **newpn,
  Strlist *space, size_t need, choice rep, logical delims);
extern logical genstreq(char *a, char *b, char *t);
extern void rnextname(char **name, char **nameend, char *whole, logical build);
extern void inextname(char **name, char **nameend, char *whole, logical build);
extern void onextname(char **name, char **nameend, char *whole, logical build);
extern void tnextname(char **name, char **nameend, char *whole, logical build);
extern void snextname(char **name, char **nameend, char *whole, logical build);
extern void Znextname(char **name, char **nameend, char *whole, logical build);
extern void bnextname(char **name, char **nameend, char *whole, logical build);
extern void pnextname(char **name, char **nameend, char *whole, logical build);
extern void Bnextname(char **name, char **nameend, char *whole, void *arg);
extern void Pnextname(char **name, char **nameend, char *whole, void *arg);
extern void Nnextname(char **name, char **nameend, char *whole, void *arg);
extern void nnextname(char **name, char **nameend, char *whole, void *arg);

/* in utils.c */
extern void my_exit(int status);
extern void sighandler(int sig);
extern logical substrcaseeq(char *s, char *t);
extern char *strtoupper(char *n);
extern void strtolowerx(char *n);
extern void toloweralias(Alias *ap, logical both);
extern void tolowerinc(Include *ip);
extern void reversealias(Alias **head);
extern logical strcaseeq(char *s, char *t);
extern char *strrpbrk(char *s, char *t);
#ifdef EBCDIC
extern char *strtoascii(char *s);
#endif
extern char *buildfilename(char *old, char *sub, char *name);
#ifdef NEED_STRCMP
extern int my_strcmp(char *s, char *t);
#endif
extern unsigned int chrn(char *s, char c);
extern unsigned int chrdistn(char *s, char c);
extern unsigned int log10i(unsigned long i);
extern unsigned int log10x(double d);
extern unsigned int findbmult(double d);
extern unsigned long arraymaxl(unsigned long *x, unsigned int size);
extern double arraymaxd(double *x, unsigned int size);
extern size_t arraymaxlen(char **s, unsigned int size, choice outstyle);
extern void prettyprintf(FILE *outf, unsigned int pagewidth, char *fmt,
  va_list ap);
extern void mprintf(FILE *outf, unsigned int pagewidth, char *fmt, ...);
extern void print_progversion(FILE *f);
extern void warn(char c, choice domess, char *s, ...);
extern void error(char *s, ...);
extern void debug(char c, char *s, ...);
extern char *delimit(char *s);
extern void *xmalloc(size_t size);
extern void *xrealloc(void *ptr, size_t size);
extern void *submalloc(Memman *m, size_t size);
extern void freemm(Memman *m);
#ifdef NEED_MEMMOVE
extern void *memmove(void *dst0, const void *src0, size_t length);
#endif
extern logical wildmatch(char *s, char *p, char *whole, int nmatch,
  ptrdiff_t *pmatch);
extern logical matchq(char *s, void *p, logical is_regex, ptrdiff_t *pmatch);
extern logical genwildmatch(char *s, char *s2, char *p);
extern logical headmatch(char *s, char *p);
extern logical headcasematch(char *s, char *p);
extern logical included(char *name, logical ispage, Include *listhead);
extern logical pageq(char *name, Include *ispagehead, choice type);

/* in win32.c */
#ifdef WIN32
extern void Win32Init(void);
extern void Win32Cleanup(void);
#endif  /* WIN32 */

#endif  /* ANLGHEA4_H */
