# TclDOM package index - hand crafted
#
# $Id: pkgIndex.tcl 5914 2006-01-23 12:32:51Z tjikkun $

package ifneeded dom::c          3.1 [list load   [file join $dir @Tcldom_LIB_FILE@]]
package ifneeded dom::tcl        3.1 [list source [file join $dir dom.tcl]]
package ifneeded dommap          1.0       [list source [file join $dir dommap.tcl]]
package ifneeded xmlswitch       1.0       [list source [file join $dir xmlswitch.tcl]]

# Examples - will not necessarily be installed
package ifneeded cgi2dom         1.1       [list source [file join $dir cgi2dom.tcl]]
package ifneeded domtree         3.1 [list source [file join $dir domtree.tcl]]
package ifneeded domtree::treectrl 3.1 [list source [file join $dir domtree-treectrl.tcl]]
package ifneeded domtext         3.1 [list source [file join $dir domtext.tcl]]

## Provided by separate package.
##package ifneeded dom::libxml2    3.1 [list load [file join $dir @RELPATH@ @TCLDOM_XML2_LIB_FILE@] Tcldomxml]

namespace eval ::dom {}

# Requesting the generic dom package loads the C package 
# if available, otherwise falls back to the generic Tcl package.
# The application can tell which it got by examining the
# list of packages loaded (and looking for dom::c, dom::libxml2 or dom::tcl).

package ifneeded dom 3.1 {
    if {[catch {package require dom::libxml2 3.1}]} {
	if {[catch {package require dom::c 3.1}]} {
	    package require dom::tcl 3.1
	}
    }
    package provide dom 3.1
}
