/*
 * Copyright (c) 1996 INRIA, All rights reserved
 */

/*
 * Warning:
 * This module is part of the Thot library, which was originally
 * developed in French. That's why some comments are still in
 * French, but their translation is in progress and the full module
 * will be available in English in the next release.
 * 
 */

/*
 * Handle windows and menu bars of Thot applications
 *
 * Authors: I. Vatton (INRIA)
 *          R. Guetari (W3C/INRIA) - Unicode and Windows version
 *
 */

#include "thot_gui.h"
#include "thot_sys.h"
#include "constmedia.h"
#include "typemedia.h"
#include "modif.h"
#include "appdialogue.h"
#include "dialog.h"
#ifndef _WINDOWS
#include "logowindow.h"
#endif /* !_WINDOWS */
#include "application.h"
#include "dialog.h"

#ifdef _GTK
#include "logo.xpm"
#endif /* _GTK */
#include "document.h"
#include "message.h"
#include "libmsg.h"
#ifndef _WINDOWS
#include "LiteClue.h"
#endif /* _WINDOWS */

#define MAX_ARGS	20

#undef THOT_EXPORT
#define THOT_EXPORT extern
#include "font_tv.h"
#include "edit_tv.h"
#include "modif_tv.h"
#include "frame_tv.h"
#include "units_tv.h"
#include "appdialogue_tv.h"
#include "appevents_tv.h"

#include "absboxes_f.h"
#include "actions_f.h"
#include "appdialogue_f.h"
#include "applicationapi_f.h"
#include "boxlocate_f.h"
#include "boxparams_f.h"
#include "boxselection_f.h"
#include "buildboxes_f.h"
#include "callback_f.h"
#include "context_f.h"
#include "dialogapi_f.h"
#include "dictionary_f.h"
#include "font_f.h"
#include "inites_f.h"
#ifdef _GTK
#include "gtk-functions.h"
#else /* !_GTK */
#include "input_f.h"
#include "appli_f.h"
#endif /* !_GTK */

#ifndef _WINDOWS
#include "LiteClue_f.h"
#include "xwindowdisplay_f.h"
#endif /* _WINDOWS */
#include "profiles_f.h"
#include "thotmsg_f.h"

/* function generated by the compiler app */
extern void TteLoadApplications ( void );

extern ThotBool     WithMessages;	/* partage avec le module dialog.c */
extern Pixmap       image;
extern int          appArgc;
extern CHAR_T**     appArgv;
extern int          iString;
typedef void        (*Thot_ActionProc) ();
typedef struct _CallbackCTX *PtrCallbackCTX;

typedef struct _CallbackCTX
  {
     Thot_ActionProc     callbackProc;
     int                 callbackSet;
     PtrCallbackCTX      callbackNext;
  }
CallbackCTX;

static PtrCallbackCTX FirstCallbackAPI;
static int          FreeMenuAction;
static Pixmap       wind_pixmap;
static  void *      LastProcedure = NULL;   

/* LISTES DES MENUS : chaque menu pointe sur une liste d'items.  */
/* Chaque item contient le numero d'entree dans le fichier de    */
/* dialogue (le texte pouvant varier avec la langue utilisee) et */
/* l'indice dans la TABLE DES ACTIONS de l'action associee.      */
/* CsList des menus attache's a la fenetre principale de l'application */
static Menu_Ctl    *MainMenuList;

/* CsList des menus attache's aux frames de documents en ge'ne'ral */
static Menu_Ctl    *DocumentMenuList;

/* CsList des menus attache's aux frames de documents particuliers */
static SchemaMenu_Ctl *SchemasMenuList;

#ifdef _WINDOWS
#include "wininclude.h"
#define WM_ENTER (WM_USER)

extern TBADDBITMAP ThotTBBitmap;
extern HWND        currentWindow;

WNDPROC lpfnTextZoneWndProc = (WNDPROC) 0;

static BOOL    doSwitchButton = TRUE;
static int     FormattedViewXPos = 0;
static int     FormattedViewYPos = 0;

HWND  hwndClient;
HWND  ToolBar;
HWND  StatusBar;
HWND  logoFrame;

static HWND               hwndTB;


HMENU hmenu;
int   menu_item;

/*----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
#ifdef __STDC__
LRESULT ToolBarNotify (int frame, HWND hwnd, WPARAM wParam, LPARAM lParam)
#else  /* __STDC__ */
LRESULT ToolBarNotify (frame, hwnd, wParam, lParam)
int    frame;
HWND   hwnd; 
WPARAM wParam; 
LPARAM lParam;
#endif /* __STDC__ */
{
   LPNMHDR pnmh = (LPNMHDR) lParam;
   int idCtrl = (int) wParam;

   /* Allow toolbar to be customized */
   if ((pnmh->code == TBN_QUERYDELETE) || (pnmh->code == TBN_QUERYINSERT))
      return 1; /* We always say "yes" */

   /* Provide details of allowable toolbar buttons */
   if (pnmh->code == TBN_GETBUTTONINFO) {
      LPTBNOTIFY ptbn = (LPTBNOTIFY) lParam;
      if (ptbn->iItem > 0) {
         ustrcpy (ptbn->pszText, FrameTable[frame].TbStrings[ptbn->iItem]);
         memcpy (&ptbn->tbButton, FrameTable[frame].Button[ptbn->iItem], sizeof (TBBUTTON));
         return 1;
      }
   }

   return 0;
}

/*----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
#ifdef __STDC__
LRESULT CALLBACK textZoneProc (HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
#else  /* __STDC__ */
LRESULT CALLBACK textZoneProc (hwnd, msg, wParam, lParam)
HWND   hwnd; 
UINT   msg; 
WPARAM wParam; 
LPARAM lParam;
#endif /* __STDC__ */
{
    switch (msg) { 
           case WM_KEYDOWN: 
                switch (wParam) { 
                       case VK_RETURN: 
                            SendMessage(GetParent (hwnd), WM_ENTER, 0, 0); 
                            return 0; 
				} 
                break; 
 
           case WM_KEYUP: 
           case WM_CHAR: 
                switch (wParam) { 
                       case VK_RETURN: 
                       return 0; 
				} 
    } 
 
    /* 
     * Call the original window procedure for default 
     * processing. 
     */ 
 
    return CallWindowProc (lpfnTextZoneWndProc, hwnd, msg, wParam, lParam); 
}

/*----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
HWND GetCurrentWindow () {
     return FrRef [currentFrame];
}
#endif /* _WINDOWS */

/*----------------------------------------------------------------------
   TteInitMenuActions alloue la table des actions.                    
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TteInitMenus (CHAR_T* name, int number)
#else  /* __STDC__ */
void                TteInitMenus (name, number)
CHAR_T*             name;
int                 number;

#endif /* __STDC__ */
{
   int                 i;
   char                namef1[100];
   char                namef2[100];
   char                text[100];
   char                alphabet;

#  ifndef _WINDOWS
   Display            *Dp;
#  endif /* !_WINDOWS */

   /* Initialisation du  contexte serveur */
   FrRef[0] = 0;
#  ifdef _WINDOWS
   FrMainRef [0] = 0;
#  endif /* _WINDOWS */
   InitDocContexts ();

   /* Init the profile table */
   Prof_InitTable();
 
   /* Initialise le dialogue */
   servername = NULL;
   if (appArgc > 2)
     {
	i = 1;
	while (i < appArgc - 1)
	   if (ustrcmp (appArgv[i], TEXT("-display")) != 0)
	      i++;
	   else
	     {
		/* l'argument est "-display" et celui qui suit le nom du display */
		servername = appArgv[i + 1];
		i = appArgc;
	     }
     }
#  ifdef _WINDOWS
   WIN_TtaInitDialogue (servername);
#  else  /* _WINDOWS */
   TtaInitDialogue (servername, &app_cont, &Dp);
   if (!RootShell)
     {
	/* Connection au serveur X impossible */
	printf ("*** Not initialized\n");
	printf ("*** Fatal Error: X connexion refused\n");
	exit (1);
     }
   TtDisplay = Dp;
#  endif /* !_WINDOWS */

   /* Definition de la procedure de retour des dialogues */
   TtaDefineDialogueCallback (ThotCallback);

   Dict_Init ();
   ThotInitDisplay (name, 0, 0);

#  ifndef _WINDOWS
   /* initialize the LiteClue Widget */
   InitClue(RootShell);
#  endif /* !_WINDOWS */

   alphabet = TtaGetAlphabet (TtaGetDefaultLanguage ());
   FontIdentifier (alphabet, 'H', 0, MenuSize, UnPoint, text, namef1);
   FontIdentifier (alphabet, 'H', 1, MenuSize, UnPoint, text, namef2);
#  ifndef _WINDOWS
   TtaChangeDialogueFonts (namef1, namef2);
#  endif /* !_WINDOWS */

   /* reserve les menus de Thot */
   TtaGetReferencesBase (MAX_ThotMenu);

   /* Il faut ajouter les actions internes liees a la structure */
   number += MAX_INTERNAL_CMD;

   MaxMenuAction = number;
   MenuActionList = (Action_Ctl *) TtaGetMemory (number * sizeof (Action_Ctl));
   /* initialisation des equilalents clavier et validation de l'action */
   for (FreeMenuAction = 0; FreeMenuAction < MAX_INTERNAL_CMD; FreeMenuAction++)
     {
	MenuActionList[FreeMenuAction].ActionEquiv = NULL;
	for (i = 0; i < MAX_FRAME; i++)
	   MenuActionList[FreeMenuAction].ActionActive[i] = TRUE;
     }
   for (i = FreeMenuAction; i < MaxMenuAction; i++)
     {
	MenuActionList[i].ActionName = "";
	MenuActionList[i].Call_Action = NULL;
	MenuActionList[i].ActionEquiv = NULL;
     }

   /* Initialisation des actions internes obligatoires */
   MenuActionList[0].ActionName = "TtcInsertChar";	/* action InsertChar() */
   MenuActionList[0].Call_Action = (Proc) NULL;

   MenuActionList[CMD_DeletePrevChar].ActionName = "TtcDeletePreviousChar";
   MenuActionList[CMD_DeletePrevChar].Call_Action = (Proc) NULL;
   MenuActionList[CMD_DeletePrevChar].ActionEquiv = TtaStrdup ("BackSpace");

   MenuActionList[CMD_DeleteSelection].ActionName = "TtcDeleteSelection";
   MenuActionList[CMD_DeleteSelection].Call_Action = (Proc) NULL;
   MenuActionList[CMD_DeleteSelection].ActionEquiv = TtaStrdup ("Delete");

   MenuActionList[CMD_PreviousChar].ActionName = "TtcPreviousChar";
   MenuActionList[CMD_PreviousChar].Call_Action = (Proc) TtcPreviousChar;

   MenuActionList[CMD_NextChar].ActionName = "TtcNextChar";
   MenuActionList[CMD_NextChar].Call_Action = (Proc) TtcNextChar;

   MenuActionList[CMD_PreviousLine].ActionName = "TtcPreviousLine";
   MenuActionList[CMD_PreviousLine].Call_Action = (Proc) TtcPreviousLine;

   MenuActionList[CMD_NextLine].ActionName = "TtcNextLine";
   MenuActionList[CMD_NextLine].Call_Action = (Proc) TtcNextLine;

   MenuActionList[CMD_BeginningOfLine].ActionName = "TtcStartOfLine";
   MenuActionList[CMD_BeginningOfLine].Call_Action = (Proc) TtcStartOfLine;

   MenuActionList[CMD_EndOfLine].ActionName = "TtcEndOfLine";
   MenuActionList[CMD_EndOfLine].Call_Action = (Proc) TtcEndOfLine;

   MenuActionList[CMD_ParentElement].ActionName = "TtcParentElement";
   MenuActionList[CMD_ParentElement].Call_Action = (Proc) TtcParentElement;

   MenuActionList[CMD_PreviousElement].ActionName = "TtcPreviousElement";
   MenuActionList[CMD_PreviousElement].Call_Action = (Proc) TtcPreviousElement;

   MenuActionList[CMD_NextElement].ActionName = "TtcNextElement";
   MenuActionList[CMD_NextElement].Call_Action = (Proc) TtcNextElement;

   MenuActionList[CMD_ChildElement].ActionName = "TtcChildElement";
   MenuActionList[CMD_ChildElement].Call_Action = (Proc) TtcChildElement;

   MenuActionList[CMD_PageUp].ActionName = "TtcPageUp";
   MenuActionList[CMD_PageUp].Call_Action = (Proc) TtcPageUp;
   MenuActionList[CMD_PageUp].ActionEquiv = TtaStrdup ("Prior");

   MenuActionList[CMD_PageDown].ActionName = "TtcPageDown";
   MenuActionList[CMD_PageDown].Call_Action = (Proc) TtcPageDown;
   MenuActionList[CMD_PageDown].ActionEquiv = TtaStrdup ("Next");

   MenuActionList[CMD_PageTop].ActionName = "TtcPageTop";
   MenuActionList[CMD_PageTop].Call_Action = (Proc) TtcPageTop;
   MenuActionList[CMD_PageTop].ActionEquiv = TtaStrdup ("Home");

   MenuActionList[CMD_PageEnd].ActionName = "TtcPageEnd";
   MenuActionList[CMD_PageEnd].Call_Action = (Proc) TtcPageEnd;
   MenuActionList[CMD_PageEnd].ActionEquiv = TtaStrdup ("End");

   MenuActionList[CMD_LineUp].ActionName = "TtcLineUp";
   MenuActionList[CMD_LineUp].Call_Action = (Proc) TtcLineUp;
   MenuActionList[CMD_LineUp].ActionEquiv = TtaStrdup ("C Left");

   MenuActionList[CMD_LineDown].ActionName = "TtcLineDown";
   MenuActionList[CMD_LineDown].Call_Action = (Proc) TtcLineDown;
   MenuActionList[CMD_LineDown].ActionEquiv = TtaStrdup ("C Down");

   MenuActionList[CMD_ScrollRight].ActionName = "TtcScrollRight";
   MenuActionList[CMD_ScrollRight].Call_Action = (Proc) TtcScrollRight;
   MenuActionList[CMD_ScrollRight].ActionEquiv = TtaStrdup ("C Right");

   MenuActionList[CMD_ScrollLeft].ActionName = "TtcScrollLeft";
   MenuActionList[CMD_ScrollLeft].Call_Action = (Proc) TtcScrollLeft;
   MenuActionList[CMD_ScrollLeft].ActionEquiv = TtaStrdup ("C Left");

   MenuActionList[CMD_CreateElement].ActionName = "TtcCreateElement";
   MenuActionList[CMD_CreateElement].Call_Action = (Proc) NULL;

   MenuActionList[CMD_CopyToClipboard].ActionName = "TtcCopyToClipboard";
   MenuActionList[CMD_CopyToClipboard].Call_Action = (Proc) TtcCopyToClipboard;

   MenuActionList[CMD_PasteFromClipboard].ActionName = "TtcPasteFromClipboard";
   MenuActionList[CMD_PasteFromClipboard].Call_Action = (Proc) NULL;

   MenuActionList[CMD_PreviousSelChar].ActionName = "TtcPreviousSelChar";
   MenuActionList[CMD_PreviousSelChar].Call_Action = (Proc) TtcPreviousSelChar;

   MenuActionList[CMD_NextSelChar].ActionName = "TtcNextSelChar";
   MenuActionList[CMD_NextSelChar].Call_Action = (Proc) TtcNextSelChar;

   MenuActionList[CMD_PreviousSelLine].ActionName = "TtcPreviousSelLine";
   MenuActionList[CMD_PreviousSelLine].Call_Action = (Proc) TtcPreviousSelLine;

   MenuActionList[CMD_NextSelLine].ActionName = "TtcNextSelLine";
   MenuActionList[CMD_NextSelLine].Call_Action = (Proc) TtcNextSelLine;
}


/*----------------------------------------------------------------------
   FreeMenus frees all contextes allocated by the menu manager
  ----------------------------------------------------------------------*/
void    FreeMenus ()
{
  PtrAction           pAction, aNext;
  Menu_Ctl           *ptrmenu, *mNext;
  SchemaMenu_Ctl     *ptrschema, *sNext;
  Item_Ctl           *ptrItem;
  PtrCallbackCTX      ctxCallback;
  int                 i;

  /* free menu actions */
   for (i = 0; i < FreeMenuAction; i++)
     TtaFreeMemory (MenuActionList[i].ActionEquiv);
   for (i = MAX_INTERNAL_CMD; i < FreeMenuAction; i++)
     TtaFreeMemory (MenuActionList[i].ActionName);
  TtaFreeMemory (MenuActionList);
  FreeMenuAction = 0;

  /* free menu contexts allocated for the main window */
  ptrmenu = MainMenuList;
  MainMenuList = NULL;
  while (ptrmenu)
    {
      ptrItem = ptrmenu->ItemsList;
      for (i = 0; i < ptrmenu->ItemsNb; i++)
	if (ptrItem[i].ItemType == TEXT('M'))
	  {
	    /* free a submenu */
	    TtaFreeMemory (ptrItem[i].SubMenu->ItemsList);
	    TtaFreeMemory (ptrItem[i].SubMenu);
	  }
	  
      /* free the items list */
      TtaFreeMemory (ptrItem);
      /* free the menu context */
      mNext = ptrmenu->NextMenu;
      TtaFreeMemory (ptrmenu);
      ptrmenu = mNext;
    }

  /* free menu contexts allocated for standard documents*/
  ptrmenu = DocumentMenuList;
  DocumentMenuList = NULL;
  while (ptrmenu)
    {
      ptrItem = ptrmenu->ItemsList;
      for (i = 0; i < ptrmenu->ItemsNb; i++)
	if (ptrItem[i].ItemType == TEXT('M'))
	  {
	    /* free a submenu */
	    TtaFreeMemory (ptrItem[i].SubMenu->ItemsList);
	    TtaFreeMemory (ptrItem[i].SubMenu);
	  }
	  
      /* free the items list */
      TtaFreeMemory (ptrItem);
      /* free the menu context */
      mNext = ptrmenu->NextMenu;
      TtaFreeMemory (ptrmenu);
      ptrmenu = mNext;
    }

  /* free menu contexts allocated for specific documents*/
  ptrschema = SchemasMenuList;
  SchemasMenuList = NULL;
  while (ptrschema)
    {
      ptrmenu = ptrschema->SchemaMenu;
      while (ptrmenu)
	{
	  ptrItem = ptrmenu->ItemsList;
	  for (i = 0; i < ptrmenu->ItemsNb; i++)
	    if (ptrItem[i].ItemType == TEXT('M'))
	      {
		/* free a submenu */
		TtaFreeMemory (ptrItem[i].SubMenu->ItemsList);
		TtaFreeMemory (ptrItem[i].SubMenu);
	      }
	  
	  /* free the items list */
	  TtaFreeMemory (ptrItem);
	  /* free the menu context */
	  mNext = ptrmenu->NextMenu;
	  TtaFreeMemory (ptrmenu);
	  ptrmenu = mNext;
	}
      sNext = ptrschema->NextSchema;
      TtaFreeMemory (ptrschema);
      ptrschema = sNext;
    }
    
  /* free actions */
   pAction = ActionList;
   ActionList = NULL;
   while (pAction != NULL)
     {
       aNext = pAction->ActNext;
       TtaFreeMemory (pAction);
       pAction = aNext;
     }

  /* free callback contexts */
   ctxCallback = FirstCallbackAPI;
   while (ctxCallback)
     {
	   FirstCallbackAPI = ctxCallback->callbackNext;
	   TtaFreeMemory (ctxCallback);
	   ctxCallback = FirstCallbackAPI;
     }
}


/*----------------------------------------------------------------------
   TteAddMenuAction ajoute une nouvelle action dans la table des      
   actions d'interface.                                            
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TteAddMenuAction (char* actionName, Proc procedure, ThotBool state)

#else  /* __STDC__ */
void                TteAddMenuAction (actionName, procedure, state)
char*               actionName;
Proc                procedure;
ThotBool            state;
#endif /* __STDC__ */
{
   char*               ptr;
   int                 lg;
   int                 i;

   if ((actionName == NULL) || (!Prof_BelongTable(actionName))) 
       return;			/* pas de nom d'action declare */

   lg = strlen (actionName);
   if (FreeMenuAction < MaxMenuAction && lg != 0)
     {
	/* Alloue une chaine de caractere pour le nom de l'action */
	ptr = TtaGetMemory (lg + 1);
	strcpy (ptr, actionName);
	MenuActionList[FreeMenuAction].ActionName = ptr;
	MenuActionList[FreeMenuAction].Call_Action = procedure;
	MenuActionList[FreeMenuAction].ActionEquiv = NULL;
	/* Cette nouvelle action n'est active pour aucune frame */
	for (i = 0; i < MAX_FRAME; i++)
	   MenuActionList[FreeMenuAction].ActionActive[i] = state;
	FreeMenuAction++;
     }
}


/*----------------------------------------------------------------------
   FindMenuAction recherche l'action dans la table des actions        
   d'interface.                                                    
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static int          FindMenuAction (char* actionName)

#else  /* __STDC__ */
static int          FindMenuAction (actionName)
char*               actionName;

#endif /* __STDC__ */
{
   int                 i;

   for (i = 0; i < MaxMenuAction; i++)
     {
	if (!strcmp (actionName, MenuActionList[i].ActionName))
	   return (i);
     }
   return (i);
}


/*----------------------------------------------------------------------
   TteZeroMenu signale qu'il n'y a pas de menu dans ce type de        
   fenentre.                                                       
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TteZeroMenu (WindowType windowtype, CHAR_T* schemaName)

#else  /* __STDC__ */
void                TteZeroMenu (windowtype, schemaName)
WindowType          windowtype;
CHAR_T*             schemaName;

#endif /* __STDC__ */
{
   SchemaMenu_Ctl     *ptrschema;
   ThotBool            ok;

   if (windowtype == DocTypeWindow)
     {
	/* il s'agit d'un menu d'un schema particulier */
	if (SchemasMenuList == NULL)
	  {
	     /* creation et initialisation du contexte specifique au schema */
	     ptrschema = (SchemaMenu_Ctl *) TtaGetMemory (sizeof (SchemaMenu_Ctl));
	     ptrschema->SchemaName = TtaAllocString (ustrlen (schemaName) + 1);
	     ustrcpy (ptrschema->SchemaName, schemaName);
	     ptrschema->SchemaMenu = NULL;
	     ptrschema->NextSchema = NULL;
	     SchemasMenuList = ptrschema;
	  }
	else
	  {
	     ptrschema = SchemasMenuList;
	     ok = ustrcmp (schemaName, ptrschema->SchemaName);
	     while (!ok && ptrschema->NextSchema != NULL)
	       {
		  ptrschema = ptrschema->NextSchema;
		  ok = ustrcmp (schemaName, ptrschema->SchemaName);
	       }

	     if (!ok)
	       {
		  /* creation et initialisation du contexte specifique au schema */
		  ptrschema->NextSchema = (SchemaMenu_Ctl *) TtaGetMemory (sizeof (SchemaMenu_Ctl));
		  ptrschema = ptrschema->NextSchema;
		  ptrschema->SchemaName = TtaAllocString (ustrlen (schemaName) + 1);
		  ustrcpy (ptrschema->SchemaName, schemaName);
		  ptrschema->SchemaMenu = NULL;
		  ptrschema->NextSchema = NULL;
	       }
	  }
     }
}


/*----------------------------------------------------------------------
   TteAddMenu ajoute un nouveau menu pour le schema donne. Si le      
   nom de schema est Null, il s'agit des menus pris par defaut.    
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TteAddMenu (WindowType windowtype, CHAR_T* schemaName, int view, int menuID, int itemsNumber, char* menuName)

#else  /* __STDC__ */
void                TteAddMenu (windowtype, schemaName, view, menuID, itemsNumber, menuName)
WindowType          windowtype;
CHAR_T*             schemaName;
int                 view;
int                 menuID;
int                 itemsNumber;
char*               menuName;

#endif /* __STDC__ */
{
   Menu_Ctl           *ptrmenu = NULL;
   Menu_Ctl           *newmenu;
   SchemaMenu_Ctl     *ptrschema;
   Item_Ctl           *ptr;
   int                 i;
   ThotBool            ok;

   /* Creation du nouveau menu */
   newmenu = (Menu_Ctl *) TtaGetMemory (sizeof (Menu_Ctl));
   newmenu->MenuID = menuID;
   newmenu->MenuView = view;
   newmenu->ItemsNb = itemsNumber;
   /* Enregistre les menus actifs */
   newmenu->MenuAttr = FALSE;
   newmenu->MenuSelect = FALSE;
   newmenu->MenuHelp = FALSE;
   if (!strcmp (menuName, "MenuAttribute"))
      newmenu->MenuAttr = TRUE;
   else if (!strcmp (menuName, "MenuSelection"))
      newmenu->MenuSelect = TRUE;
   else if (!strcmp (menuName, "MenuHelp"))
      newmenu->MenuHelp = TRUE;

   /* creation et initialisation de la table des items */
   ptr = (Item_Ctl *) TtaGetMemory (itemsNumber * sizeof (Item_Ctl));
   for (i = 0; i < itemsNumber; i++)
     {
	ptr[i].ItemID = -1;
	ptr[i].ItemAction = -1;
	ptr[i].ItemType = SPACE;
     }
   newmenu->ItemsList = ptr;
   newmenu->NextMenu = NULL;

   /* Chainage du nouveau menu aux autres menus existants */
   switch (windowtype)
	 {
	    case MainWindow:
	       /* il s'agit d'un des menus principaux */
	       if (MainMenuList == NULL)
		 {
		    MainMenuList = newmenu;
		    ptrmenu = NULL;
		 }
	       else
		  ptrmenu = MainMenuList;	/* simple ajout du menu dans une liste */
	       break;

	    case DocWindow:
	       /* il s'agit d'un des menus pris par defaut */
	       if (DocumentMenuList == NULL)
		 {
		    DocumentMenuList = newmenu;
		    ptrmenu = NULL;
		 }
	       else
		  ptrmenu = DocumentMenuList;	/* simple ajout du menu dans une liste */
	       break;

	    case DocTypeWindow:
	       /* il s'agit d'un menu d'un schema particulier */
	       if (SchemasMenuList == NULL)
		 {
		    /* creation et initialisation du contexte specifique au schema */
		    ptrschema = (SchemaMenu_Ctl *) TtaGetMemory (sizeof (SchemaMenu_Ctl));
		    ptrschema->SchemaName = TtaAllocString (ustrlen (schemaName) + 1);
		    ustrcpy (ptrschema->SchemaName, schemaName);
		    ptrschema->SchemaMenu = newmenu;
		    ptrschema->NextSchema = NULL;
		    ptrmenu = NULL;
		    SchemasMenuList = ptrschema;
		 }
	       else
		 {
		    ptrschema = SchemasMenuList;
		    ok = ustrcmp (schemaName, ptrschema->SchemaName);
		    while (ok && ptrschema->NextSchema != NULL)
		      {
			 ptrschema = ptrschema->NextSchema;
			 ok = ustrcmp (schemaName, ptrschema->SchemaName);
		      }

		    if (ok)
		      {
			 /* creation et initialisation du contexte specifique au schema */
			 ptrschema->NextSchema = (SchemaMenu_Ctl *) TtaGetMemory (sizeof (SchemaMenu_Ctl));
			 ptrschema = ptrschema->NextSchema;
			 ptrschema->SchemaName = TtaAllocString (ustrlen (schemaName) + 1);
			 ustrcpy (ptrschema->SchemaName, schemaName);
			 ptrschema->SchemaMenu = newmenu;
			 ptrschema->NextSchema = NULL;
			 ptrmenu = NULL;
		      }
		    else
		       ptrmenu = ptrschema->SchemaMenu;		/* simple ajout du menu dans une liste */
		 }
	       break;
	 }

   if (ptrmenu != NULL)
     {
	/* Ajout du nouveau menu en fin de liste */
	while (ptrmenu->NextMenu != NULL)
	   ptrmenu = ptrmenu->NextMenu;
	ptrmenu->NextMenu = newmenu;
     }
}


/*----------------------------------------------------------------------
   TteAddSubMenu ajoute un sous-menu pour le schema donne.            
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TteAddSubMenu (WindowType windowtype, CHAR_T* schemaName, int menuID, int itemID, int itemsNumber)

#else  /* __STDC__ */
void                TteAddSubMenu (windowtype, schemaName, menuID, itemID, itemsNumber)
WindowType          windowtype;
CHAR_T*             schemaName;
int                 menuID;
int                 itemID;
int                 itemsNumber;

#endif /* __STDC__ */
{
   Menu_Ctl           *ptrmenu;
   Menu_Ctl           *newmenu;
   SchemaMenu_Ctl     *ptrschema;
   Item_Ctl           *ptr, *ptrItem;
   int                 i, j;

   /* Recherche la bonne liste de menus */
   ptrmenu = NULL;
   switch (windowtype)
	 {
	    case MainWindow:
	       /* il s'agit d'un des menus principaux */
	       if (MainMenuList != NULL)
		  ptrmenu = MainMenuList;
	       break;

	    case DocWindow:
	       /* il s'agit d'un des menus pris par defaut */
	       if (DocumentMenuList != NULL)
		  ptrmenu = DocumentMenuList;
	       break;

	    case DocTypeWindow:
	       /* il s'agit d'un menu d'un schema particulier */
	       ptrschema = SchemasMenuList;
	       while (ptrschema != NULL && ustrcmp (schemaName, ptrschema->SchemaName))
		  ptrschema = ptrschema->NextSchema;
	       if (ptrschema != NULL)
		  ptrmenu = ptrschema->SchemaMenu;
	       break;
	 }

   /* Recherche le bon menu */
   while (ptrmenu != NULL && menuID != ptrmenu->MenuID)
      ptrmenu = ptrmenu->NextMenu;

   if (ptrmenu != NULL)
     {
	/* recherche l'item dans le menu */
	ptrItem = ptrmenu->ItemsList;
	j = 0;
	while (j < ptrmenu->ItemsNb && ptrItem[j].ItemType != SPACE)
	   j++;
	if (j < ptrmenu->ItemsNb)
	  {
	     /* Creation du sous-menu */
	     newmenu = (Menu_Ctl *) TtaGetMemory (sizeof (Menu_Ctl));
	     newmenu->MenuID = 0;
	     newmenu->MenuView = 0;
	     newmenu->ItemsNb = itemsNumber;
	     newmenu->MenuAttr = FALSE;
	     newmenu->MenuSelect = FALSE;
	     newmenu->MenuHelp = FALSE;

	     /* creation et initialisation de la table des items */
	     ptr = (Item_Ctl *) TtaGetMemory (itemsNumber * sizeof (Item_Ctl));
	     for (i = 0; i < itemsNumber; i++)
	       {
		  ptr[i].ItemID = -1;
		  ptr[i].ItemAction = -1;
		  ptr[i].ItemType = SPACE;
	       }
	     newmenu->ItemsList = ptr;
	     newmenu->NextMenu = NULL;
	     /* relie le sous-menu a l'item */
	     ptrItem[j].SubMenu = newmenu;
	     ptrItem[j].ItemID = itemID;
	     ptrItem[j].ItemType = 'M';
	  }
     }
}


/*----------------------------------------------------------------------
   TteAddMenuItem ajoute une nouvel item dans un menu.                
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TteAddMenuItem (WindowType windowtype, CHAR_T* schemaName, int menuID, int subMenu, int itemID, char* actionName, char itemType)

#else  /* __STDC__ */
void                TteAddMenuItem (windowtype, schemaName, menuID, subMenu, itemID, actionName, itemType)
WindowType          windowtype;
char*               schemaName;
int                 menuID;
int                 subMenu;
int                 itemID;
CHAR_T*             actionName;
char                itemType;

#endif /* __STDC__ */
{
  Menu_Ctl           *ptrmenu;
  SchemaMenu_Ctl     *ptrschema;
  Item_Ctl           *ptr;
  int                 i;

  /* Recherche la bonne liste de menus */
  ptrmenu = NULL;
  switch (windowtype)
    {
    case MainWindow:
      /* il s'agit d'un des menus principaux */
      if (MainMenuList != NULL)
	ptrmenu = MainMenuList;
      break;
	   
    case DocWindow:
      /* il s'agit d'un des menus pris par defaut */
      if (DocumentMenuList != NULL)
	ptrmenu = DocumentMenuList;
      break;
	   
    case DocTypeWindow:
      /* il s'agit d'un menu d'un schema particulier */
      ptrschema = SchemasMenuList;
      while (ptrschema != NULL && ustrcmp (schemaName, ptrschema->SchemaName))
	ptrschema = ptrschema->NextSchema;
      if (ptrschema != NULL)
	ptrmenu = ptrschema->SchemaMenu;
      break;
    }
       
  /* Recherche le menu */
  while (ptrmenu != NULL && menuID != ptrmenu->MenuID)
    ptrmenu = ptrmenu->NextMenu;
       
  if (ptrmenu != NULL && subMenu != -1)
    {
      /* Recherche l'entree du sous-menu dans le menu */
      i = 0;
      ptr = ptrmenu->ItemsList;
      while (i < ptrmenu->ItemsNb && (ptr[i].ItemID != subMenu))
	i++;
      if (i < ptrmenu->ItemsNb)
	ptrmenu = ptr[i].SubMenu;
      else
	/* on n'a pas trouve le sous-menu */
	return;
    }
 

  /* checks if the item is present in the user profile */
  if (actionName == NULL || Prof_BelongTable(actionName))
    { 
      /* ajoute l'item dans le menu */
      i = 0;
      ptr = ptrmenu->ItemsList;
      while (i < ptrmenu->ItemsNb && ptr[i].ItemType != SPACE)
	i++;
      if (i < ptrmenu->ItemsNb)
	{
	  /* Remove the separaror if the previous element was one */
	  if (! (itemType == 'S' && (i == 0 || ptr[i-1].ItemType == 'S')))
	    {
	      ptr[i].ItemID = itemID;
	      ptr[i].ItemType = itemType;
	      if (actionName != NULL)
		ptr[i].ItemAction = FindMenuAction (actionName);
	    }
	  else
	    /* Remove separator */
	    ptrmenu->ItemsNb--;
	}
    }
  else
    {
      /* removes the entry */
      ptrmenu->ItemsNb--;
    }       
}


/*----------------------------------------------------------------------
   BuildSubmenu construit un sous-menu attache' a l'item item     
   du menu ref.                                            
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         BuildSubMenu (Menu_Ctl * ptrmenu, int ref, int entry, int frame)
#else  /* __STDC__ */
static void         BuildSubMenu (ptrmenu, ref, entry, frame)
Menu_Ctl           *ptrmenu;
int                 ref;
int                 entry;
int                 frame;

#endif /* __STDC__ */
{
   int                 i, j;
   int                 lg, sref;
   int                 item;
   int                 action;
   CHAR_T              string[700];
#define MaxEquivLen 200
   char                equiv[MaxEquivLen];
   ThotBool            withEquiv;
   Item_Ctl           *ptritem;
   STRING              ptr;
   char                LastItemType = 'S';

   /* Construit le sous-menu attache a l'item */
#  ifdef _WINDOWS
   currentFrame = frame;
#  endif /* _WINDOWS */
   item = 0;
   i = 0;
   j = 0;
   withEquiv = FALSE;
   equiv[0] = EOS;
   ptritem = ptrmenu->ItemsList;
   while (item < ptrmenu->ItemsNb)
     {
       /* Regarde si le texte des commandes ne deborde pas */
       ptr = TtaGetMessage (THOT, ptritem[item].ItemID);
       lg = ustrlen (ptr) + 1;
       if (ptritem[item].ItemType == TEXT('S') && i + 2 < 700  )
	 {
	   if (( ptrmenu != NULL ) &&  Prof_ShowSeparator(ptrmenu, item, LastItemType) )
	     {
	       ustrcpy (&string[i], TEXT("S"));
	       i += 2;
	     }
	 }
       else if (i + lg < 699)
	 {
	   if (ptritem[item].ItemType == TEXT('D'))
	     string[i] = TEXT('B');
	   else
	     string[i] = ptritem[item].ItemType;
	   ustrcpy (&string[i + 1], ptr);
	   i += lg + 1;
	 }
       else
	   /* sinon on reduit le nombre d'items */
	   ptrmenu->ItemsNb = item - 1;

       /* traite le contenu de l'item de menu */
       action = ptritem[item].ItemAction;
       if (action != -1)
	 {
	   /* Active l'action correspondante pour cette fenetre */
	   if (MenuActionList[action].ActionEquiv != NULL)
	     {
	       withEquiv = TRUE;
	       lg = strlen (MenuActionList[action].ActionEquiv);
	       if (lg + j < MaxEquivLen)
		 {
		   strcpy (&equiv[j], MenuActionList[action].ActionEquiv);
		   j += lg;
		 }
	     }
	   MenuActionList[action].ActionActive[frame] = TRUE;
	 }
       equiv[j++] = EOS;
       
       LastItemType = ptrmenu->ItemsList[item].ItemType;
       item++;
     }
   sref = ((entry + 1) * MAX_MENU * MAX_ITEM) + ref;
   /* Creation du Pulldown avec ou sans equiv */
   if (withEquiv)
     TtaNewSubmenu (sref, ref, entry, NULL, ptrmenu->ItemsNb, string, equiv, FALSE);
   else
     TtaNewSubmenu (sref, ref, entry, NULL, ptrmenu->ItemsNb, string, NULL, FALSE);
}


/*----------------------------------------------------------------------
   BuildPopdown construit un menu popdown attache' au bouton      
   de menu.                                                
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         BuildPopdown (Menu_Ctl * ptrmenu, int ref, ThotMenu button, int frame, int doc)
#else  /* __STDC__ */
static void         BuildPopdown (ptrmenu, ref, button, frame, doc)
Menu_Ctl*           ptrmenu;
int                 ref;
ThotMenu            button;
int                 frame;
int                 doc;
#endif /* __STDC__ */
{
   int                 i, j;
   int                 lg;
   int                 item;
   int                 action;
   CHAR_T              string[700];
   char                equiv[MaxEquivLen];
   ThotBool            withEquiv;
   Item_Ctl           *ptritem;
   CHAR_T*             ptr;
   char                LastItemType = 'S';
   int                 nbremovedsep = 0;
   
#ifdef _WINDOWS 

   currentFrame = frame;
#endif /* _WINDOWS */

   /* Construit le pulldown attache au bouton */
   item = 0;
   i = 0;
   j = 0;
   withEquiv = FALSE;
   equiv[0] = EOS;
   ptritem = ptrmenu->ItemsList;
   while (item < ptrmenu->ItemsNb)
     {
       action = ptritem[item].ItemAction;
       /* Regarde si le texte des commandes ne deborde pas */
       ptr = TtaGetMessage (THOT, ptritem[item].ItemID);
       lg = ustrlen (ptr) + 1;
       if (ptritem[item].ItemType == TEXT('S') && i + 2 < 700)
	 {

	   if ( ptrmenu != NULL ) 
	     {
	       if ( Prof_ShowSeparator(ptrmenu, item,LastItemType))
		 {
		   ustrcpy (&string[i], TEXT("S"));
		   i += 2;
		 }
	       else
		 nbremovedsep ++;
	     }
	 }
       else if (i + lg < 699)
	 {
/* 	   if ( ptritem[item].ItemType != TEXT('M') || */
/* 		ptritem[item].SubMenu->ItemsNb != 0 ) */
/* 	     { */
	       if (ptritem[item].ItemType == TEXT('D'))
		 string[i] = TEXT('B');
	       else
		 string[i] = ptritem[item].ItemType;
	       ustrcpy (&string[i + 1], ptr);
	       i += lg + 1;
/* 	     } */
	 }
       else
	 /* sinon on reduit le nombre d'items */
	 ptrmenu->ItemsNb = item - 1;
       
       /* traite le contenu de l'item de menu */
       if (action != -1)
	 {
	   if (ptritem[item].ItemType == TEXT('B') || ptritem[item].ItemType == TEXT('T'))
	     {
	       /* Active l'action correspondante pour cette fenetre */
	       if (MenuActionList[action].ActionEquiv != NULL)
		 {
		   withEquiv = TRUE;
		   lg = strlen (MenuActionList[action].ActionEquiv);
		   if (lg + j < MaxEquivLen)
		     {
		       strcpy (&equiv[j], MenuActionList[action].ActionEquiv);
		       j += lg;
		     }
		 }
	       /* Is it the Paste command */
	       if (!strcmp (MenuActionList[action].ActionName, "TtcPaste"))
		 {
		   FrameTable[frame].MenuPaste = ref;
		   FrameTable[frame].EntryPaste = item;
		 }
	       /* Is it the Undo command */
	       if (!strcmp (MenuActionList[action].ActionName, "TtcUndo"))
		 {
		   FrameTable[frame].MenuUndo = ref;
		   FrameTable[frame].EntryUndo = item;
		 }
	       /* Is it the Redo command */
	       if (!strcmp (MenuActionList[action].ActionName, "TtcRedo"))
		 {
		   FrameTable[frame].MenuRedo = ref;
		   FrameTable[frame].EntryRedo = item;
		 }
	       MenuActionList[action].ActionActive[frame] = TRUE;
	     }
	 }
       LastItemType = ptrmenu->ItemsList[item].ItemType;
       equiv[j++] = EOS;
       item++;
     }
   
   /* Creation du Pulldown avec ou sans equiv */
   if (withEquiv)
      TtaNewPulldown (ref, button, NULL, ptrmenu->ItemsNb - nbremovedsep,
		      string, equiv);
   else
      TtaNewPulldown (ref, button, NULL, ptrmenu->ItemsNb - nbremovedsep, 
		      string, NULL);

   /* traite les sous-menus de l'item de menu */
   item = 0;
   ptritem = ptrmenu->ItemsList;
   while (item < ptrmenu->ItemsNb)
     {
	action = ptritem[item].ItemAction;
	if (action != -1)
	  {
	    if (ptritem[item].ItemType == TEXT('M'))
	      {
		if (action != 0 && item < MAX_MENU)
		  /* creation du sous-menu */

		  if (Prof_ShowSubMenu(ptritem[item].SubMenu))
		    BuildSubMenu (ptritem[item].SubMenu, ref, item, frame);
	       }
	  }
	item++;
     }
}

/*----------------------------------------------------------------------
   TteOpenMainWindow opens the application main window.
 
   Parameters:
   name: the name to be displayed as the title of the main window.
   logo: the logo pixmap to be displayed in the window or NULL.
   icon: the icon pixmap to be displayed in the window or NULL.

  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TteOpenMainWindow (CHAR_T* name, Pixmap logo, Pixmap icon)
#else  /* __STDC__ */
void                TteOpenMainWindow (name, logo, icon)
CHAR_T*             name;
Pixmap              logo;
Pixmap              icon;

#endif /* __STDC__ */
{
   int                 i, n;
   int                 ref;
   int                 lg;
   CHAR_T              string[700];
   Menu_Ctl*           ptrmenu;
   STRING              ptr;

   /* Creation de la fenetre principale */
   UserErrorCode = 0;
   TtaInitDialogueTranslations (InitTranslations (name));
   /* no external action declared at that time */
   ActionList = NULL;
   TteLoadApplications ();
#  ifndef _WINDOWS
   if (TtDisplay == 0)
     {
	/* Connexion au serveur X impossible */
	TtaError (ERR_cannot_open_main_window);
	exit (1);
     }
   else
#  endif /* !_WINDOWS */
     {
	/* Police de caracteres utilisee dans les menus */
#       ifndef _WINDOWS
       /*DefaultFont = XmFontListCreate ((XFontStruct *) ThotLoadFont ('L', 'H', 0, MenuSize, UnPoint, 0), XmSTRING_DEFAULT_CHARSET);*/
#       endif
	/* Compte le nombre de menus a creer */
	n = 0;
	i = 0;
	ptrmenu = MainMenuList;
	while (ptrmenu != NULL)
	  {
	     n++;
	     /* Regarde si le texte des commandes ne deborde pas */

	     /*
	        ptr = TtaGetMessage(EDIT_DIALOG, ptrmenu->MenuID);
	      */
	     ptr = TtaGetMessage (THOT, ptrmenu->MenuID);
	     lg = ustrlen (ptr) + 1;
	     if (i + lg < 700)
	       {
		  ustrcpy (&string[i], ptr);
		  i += lg;
		  ptrmenu = ptrmenu->NextMenu;
	       }
	     else
		/* sinon on reduit le nombre de menus */
		ptrmenu = NULL;
	  }

        /**** creation de la fenetre principale ****/
	if (n == 0)
	  {
	     WithMessages = FALSE;
	     TtaInitDialogueWindow (name, NULL, None, None, 0, NULL);
	  }
	else
	  {
	     WithMessages = TRUE;
	     TtaInitDialogueWindow (name, NULL, logo, icon, n, string);
	  }

	/* icone des fenetres de documents */
#       ifndef _WINDOWS
	wind_pixmap = XCreateBitmapFromData (TtDisplay, XDefaultRootWindow (TtDisplay),
		      logowindow_bits, logowindow_width, logowindow_height);
#       endif
        /**** creation des menus ****/
	ptrmenu = MainMenuList;
	FrameTable[0].FrMenus = ptrmenu;
	ref = MAX_LocalMenu;	/* reference du menu construit */
	i = 0;
	while (ptrmenu != NULL)
	  {
	     /* Enregistre le widget du menu */
	     FrameTable[0].EnabledMenus[i] = TRUE;
	     BuildPopdown (ptrmenu, ref, FrameTable[0].WdMenus[i], 0, 0);
	     ptrmenu = ptrmenu->NextMenu;
	     ref += MAX_ITEM;
	     i++;
	  }

	/* Les autres entrees de menus sont inactives */
	while (i < MAX_MENU)
	  {
	     FrameTable[0].EnabledMenus[i] = FALSE;
	     i++;
	  }
     }
}
/*----------------------------------------------------------------------
   ButtonAction                                                    
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void APP_ButtonCallback (ThotButton w, int frame, caddr_t call_d)

#else  /* __STDC__ */
void APP_ButtonCallback (w, frame, call_d)
ThotButton          w;
int                 frame;
caddr_t             call_d;

#endif /* __STDC__ */
{
   Document            document;
   View                view;
   int                 i;

   i = 0;
   while (i < MAX_BUTTON && FrameTable[frame].Button[i] != w)
      i++;
   if (i < MAX_BUTTON)
     {
#ifdef _WINDOWS
	doSwitchButton = FALSE;
#else /* _WINDOWS */
	if (!FrameTable[frame].EnabledButton[i])
	  /* the button is not active */
	  return;
#endif /* _WINDOWS */
	CloseInsertion ();
	FrameToView (frame, &document, &view);
	(*FrameTable[frame].Call_Button[i]) (document, view);
     }
#ifdef _WINDOWS
   doSwitchButton = TRUE;
#endif /* _WINDOWS */
}

#ifndef _WINDOWS
/*----------------------------------------------------------------------
   InitClue

   Initialize the liteClue Widget for the application, handling the
   tooltips on buttons.

   Parameters:
   toplevel: the application toplevel Shell.
  ----------------------------------------------------------------------*/

static ThotWidget liteClue = NULL;

#ifdef __STDC__
void         InitClue (ThotWidget toplevel)
#else  /* __STDC__ */
void         InitClue (toplevel)
ThotWidget   toplevel;

#endif /* __STDC__ */
{
#ifndef _GTK
   Arg                 args[MAX_ARGS];
   int                 n;
   int                 wait_ms = 500; /* 500 ms i.e. 1/2 second */
   STRING              user_delay;
   ThotColor           bg, fg;

   if (liteClue != NULL) return;
   liteClue = XtVaCreatePopupShell("popup_shell", xcgLiteClueWidgetClass,
                                   toplevel, NULL);

   
   user_delay = TtaGetEnvString("TOOLTIPDELAY");
   if (user_delay != NULL) {
       if (sscanf(user_delay,"%d",&wait_ms) != 1) {
           TtaSetEnvString ("TOOLTIPDELAY", "500", TRUE);
	   wait_ms = 500;
       }
   }
   bg = ColorPixel(ColorNumber("Yellow"));
   fg = ColorPixel(ColorNumber("Black"));
   n = 0;
   XtSetArg (args[n], XtNbackground, bg);
   n++;
   XtSetArg (args[n], XtNforeground, fg);
   n++;
   XtSetArg (args[n], XtNfont, DefaultFont);
   n++;
   XtSetArg (args[n], XgcNwaitPeriod, wait_ms);
   n++;
   XtSetValues (liteClue, args, n);
#endif /* _GTK */
}
#endif /* _WINDOWS */

/*----------------------------------------------------------------------
   TtaAddButton

   Adds a new button entry in a document view.
   This function must specify a valid view of a valid document.

   Parameters:
   document: the concerned document.
   view: the concerned view.
   picture: the displayed pixmap. None (0) creates a space between buttons.
   procedure: procedure to be executed when the new entry is
   selected by the user. Null creates a cascade button.
   functionName: internal name of the function used to connect shortcuts.
   info: text to display when the cursor stays on the button (should be global).
   type: button type, only used on Windows versions.
   state: TRUE to enable the button, false to disable it.
   Returns index
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int        TtaAddButton (Document document, View view, ThotIcon picture, void (*procedure) (), char* functionName, STRING info, BYTE type, ThotBool state)
#else  /* __STDC__ */
int        TtaAddButton (document, view, picture, procedure, functionName, info, type, state)
Document   document;
View       view;
ThotIcon   picture;
void       (*procedure) ();
char*      functionName;
STRING     info;
BYTE       type;
ThotBool   state;
#endif /* __STDC__ */
{
  int                 frame, i, index;
#ifndef _WINDOWS
#ifndef _GTK
  int                 n;
  XmString            title_string;
  Arg                 args[MAX_ARGS];
#endif /* _GTK */
  ThotWidget          w, row;
#else  /* _WINDOWS */
  ThotButton          w;
#endif /* _WINDOWS */

  UserErrorCode = 0;
  index = 0;
  /* verifie le parametre document */
  if (document == 0 && view == 0)
    TtaError (ERR_invalid_parameter);
  else
    {
      frame = GetWindowNumber (document, view);
      if (frame == 0 || frame > MAX_FRAME)
	TtaError (ERR_invalid_parameter);
      else if (FrameTable[frame].WdFrame != 0)
	{
	  i = 1;
	  while (i < MAX_BUTTON && FrameTable[frame].Button[i] != 0)
	    i++;
	  if (i < MAX_BUTTON)
	    {
	      /* Avoid to have two consecutive separators
		 and test if the function is available in the current profile */
	      if ((procedure == NULL && LastProcedure != NULL)  || (procedure != NULL &&  Prof_ShowButton(functionName)))
		{
		  LastProcedure = procedure;
		  /* Insere le nouveau bouton */
#ifndef _WINDOWS
#ifdef _GTK
		  if (picture == None)
		    gtk_toolbar_append_space (GTK_TOOLBAR (FrameTable[frame].Button[0]));
		  else
		    {
		      /* insert the icon */
		      w = gtk_pixmap_new (picture, NULL);
		      row = gtk_toolbar_append_item (GTK_TOOLBAR (FrameTable[frame].Button[0]), 
						     NULL, info ,"private", 
						     w, GTK_SIGNAL_FUNC (APP_ButtonCallback), 
						     (gpointer)frame);
		   
		      gtk_widget_show (row);
		      FrameTable[frame].Call_Button[i] = (Proc) procedure;
		    }
                  FrameTable[frame].Button[i] = row;
#else /* _GTK */
		  row = FrameTable[frame].Button[0];
		  n = 0;
		  XtSetArg (args[n], XmNmarginWidth, 0);
		  n++;
		  XtSetArg (args[n], XmNmarginHeight, 0);
		  n++;
		  XtSetArg (args[n], XmNbackground, BgMenu_Color);
		  n++;
		  XtSetArg (args[n], XmNtraversalOn, FALSE);
		  n++;
		  if (picture == None)
		    {
		      /* insere une chaine vide */
		      title_string = XmStringCreateSimple ("  ");
		      XtSetArg (args[n], XmNlabelString, title_string);
		      n++;
		      XtSetArg (args[n], XmNforeground, FgMenu_Color);
		      n++;
		      XtSetArg (args[n], XmNheight, (Dimension) 30);
		      n++;
		      w = XmCreateLabel (row, "Logo", args, n);
		      XtManageChild (w);
		      XmStringFree (title_string);
		    }
		  else
		    {
		      /* insere l'icone du bouton */
		      XtSetArg (args[n], XmNlabelType, XmPIXMAP);
		      n++;
		      XtSetArg (args[n], XmNlabelPixmap, picture);
		      n++;
		      if (procedure == NULL)
			{
			  w = XmCreateCascadeButton (row, "dialogue", args, n);
			  XtManageChild (w);
			}
		      else
			{
			  w = XmCreatePushButton (row, "dialogue", args, n);
			  XtManageChild (w);
			  XtAddCallback (w, XmNactivateCallback, (XtCallbackProc) APP_ButtonCallback, (XtPointer) frame);
			  FrameTable[frame].Call_Button[i] = (Proc) procedure;
			}
		    }
		  /* force la mise a jour de la fenetre */
		  XtManageChild (row);
                  FrameTable[frame].Button[i] = w;
#endif /* _GTK */
		  FrameTable[frame].EnabledButton[i] = state;
		  index = i;
#ifndef _GTK
		  if (info != NULL && procedure != NULL)
		    XcgLiteClueAddWidget(liteClue, w,  info, ustrlen(info), 0);
#endif /* _GTK */
#else  /* _WINDOWS */
		  index = i;
		  w = (ThotButton) TtaGetMemory (sizeof (TBBUTTON));
		  FrameTable[frame].Button[i] = w;
		  FrameTable[frame].Call_Button[i] = (Proc) procedure;
		  if (!w)
		    WinErrorBox (NULL, TEXT("TtaAddButton"));
		  else
		    {
		      w->fsState      = TBSTATE_ENABLED;
		      w->fsStyle      = type;
			  FrameTable[frame].ButtonId[i] = TBBUTTONS_BASE + i;
			  w->idCommand    = FrameTable[frame].ButtonId[i]; 
			  w->bReserved[0] = 0;
			  w->bReserved[1] = 0;
			  w->dwData       = 0;
		      if (procedure)
			{
			  w->iBitmap      = picture;
			  w->iString      = -1;
			  SendMessage(WinToolBar[frame], TB_INSERTBUTTON, (WPARAM) FrameTable[frame].ButtonId[i], (LPARAM)(LPTBBUTTON)w);
			  SendMessage (WinToolBar[frame], TB_ENABLEBUTTON, (WPARAM) FrameTable[frame].ButtonId[i], (LPARAM) MAKELONG (state, 0));
			}
		      else
			{
			  w->iBitmap   = 3;
			  w->iString   = 0;
			  SendMessage(WinToolBar[frame], TB_INSERTBUTTON, (WPARAM) FrameTable[frame].ButtonId[i], (LPARAM)(LPTBBUTTON)w);
			}
		    }
		  
		  if (info != NULL && procedure != NULL)
		    FrameTable[frame].TbStrings[i] = info;
#endif /* _WINDOWS */
		}
	    }
	}
    }  
  TtaHandlePendingEvents ();
  return (index);
}

/*----------------------------------------------------------------------
   TtaGetButtonCallback

   Get the callback of a button in a document view.
   Returns the callback if it exists
           NULL if it doesn't exists

   Parameters:
   document: the concerned document.
   view: the concerned view.
   index: the index.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void *              TtaGetButtonCallback (Document document, View view, int index)
#else  /* __STDC__ */
void *              TtaGetButtonCallback (document, view, index)
Document            document;
View                view;
int                 index;

#endif /* __STDC__ */
{
   int                 frame;

   UserErrorCode = 0;
   /* verifie le parametre document */
   if (document == 0 && view == 0)
      return(NULL);
   else
     {
	frame = GetWindowNumber (document, view);
	if (frame == 0 || frame > MAX_FRAME)
	   return(NULL);
	else if (FrameTable[frame].WdFrame != 0)
	  {
	     if (index >= MAX_BUTTON || index <= 0
		 || FrameTable[frame].Button[index] == 0)
		return(FrameTable[frame].Call_Button[index]);
	     else
	        return(NULL);
	  }
     }
   return(NULL);
}


/*----------------------------------------------------------------------
   TtaSwitchButton

   Change the status of the button entry in a document view.
   This function must specify a valid view of a valid document.

   Parameters:
   document: the concerned document.
   view: the concerned view.
   index: the index.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtaSwitchButton (Document document, View view, int index)
#else  /* __STDC__ */
void                TtaSwitchButton (document, view, index)
Document            document;
View                view;
int                 index;

#endif /* __STDC__ */
{
  int                 frame;
#ifndef _WINDOWS
  int                 n;
  Pixel               top, bottom;
  Arg                 args[MAX_ARGS];
#endif

  UserErrorCode = 0;
  /* verifie le parametre document */
  if (document == 0 && view == 0)
    TtaError (ERR_invalid_parameter);
  else
    {
      frame = GetWindowNumber (document, view);
      if (frame == 0 || frame > MAX_FRAME)
	TtaError (ERR_invalid_parameter);
      else if (FrameTable[frame].WdFrame != 0)
	{
	  if (index < MAX_BUTTON && index > 0 && FrameTable[frame].Button[index] != 0)
	    {
	      /* Change l'etat du bouton */
#ifdef _WINDOWS
	      if (doSwitchButton)
		{
		  if (!SendMessage (WinToolBar[frame], TB_ISBUTTONCHECKED, (WPARAM) FrameTable[frame].ButtonId[index], (LPARAM) 0))
		    SendMessage (WinToolBar[frame], TB_CHECKBUTTON, (WPARAM) FrameTable[frame].ButtonId[index], (LPARAM) MAKELONG (TRUE, 0));
		  else
		    SendMessage (WinToolBar[frame], TB_CHECKBUTTON, (WPARAM) FrameTable[frame].ButtonId[index], (LPARAM) MAKELONG (FALSE, 0));
		}
#else  /* !_WINDOWS */
#ifndef _GTK
	      n = 0;
	      XtSetArg (args[n], XmNtopShadowColor, &top);
	      n++;
	      XtSetArg (args[n], XmNbottomShadowColor, &bottom);
	      n++;
	      XtGetValues (FrameTable[frame].Button[index], args, n);
	      n = 0;
	      XtSetArg (args[n], XmNtopShadowColor, bottom);
	      n++;
	      XtSetArg (args[n], XmNbottomShadowColor, top);
	      n++;
	      XtSetValues (FrameTable[frame].Button[index], args, n);
#endif /* _GTK */
#endif /* _WINDOWS */
	    }
	}
    }
}


/*----------------------------------------------------------------------
   TtaChangeButton

   Change the button entry in a document view.
   This function must specify a valid view of a valid document.

   Parameters:
   document: the concerned document.
   view: the concerned view.
   index: the index.
   picture: the new icon.
   state: TRUE to enable the button, false to disable it.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtaChangeButton (Document document, View view, int index, ThotIcon picture, ThotBool state)
#else  /* __STDC__ */
void                TtaChangeButton (document, view, index, picture, state)
Document            document;
View                view;
int                 index;
ThotIcon            picture;
ThotBool            state;
#endif /* __STDC__ */
{
#ifndef _WINDOWS
  Arg                 args[MAX_ARGS];
  int                 n;
#endif
  int                 frame;

  UserErrorCode = 0;
  /* verifie le parametre document */
  if (document == 0 && view == 0)
    TtaError (ERR_invalid_parameter);
#ifndef _WINDOWS
   else if (picture == None)
      TtaError (ERR_invalid_parameter);
#endif /* !_WINDOWS */
  else
    {
      frame = GetWindowNumber (document, view);
      if (frame == 0 || frame > MAX_FRAME)
	TtaError (ERR_invalid_parameter);
      else if (FrameTable[frame].WdFrame != 0)
	{
	  if (index < MAX_BUTTON && index > 0 && FrameTable[frame].Button[index] != 0)
	    {
	      /* Insere le nouvel icone */
#ifdef _WINDOWS
	      if (FrameTable[frame].Button[index]->iBitmap != picture)
		  FrameTable[frame].Button[index]->iBitmap = picture;
	      SendMessage (WinToolBar[frame], TB_ENABLEBUTTON, (WPARAM) FrameTable[frame].ButtonId[index], (LPARAM) MAKELONG (state, 0));
#else  /* !_WINDOWS */
#ifndef _GTK
	      n = 0;
	      XtSetArg (args[n], XmNlabelPixmap, picture);
	      n++;
	      XtSetValues (FrameTable[frame].Button[index], args, n);
	      FrameTable[frame].EnabledButton[index] = state;
#endif /* _GTK */
#endif /* _WINDOWS */
	    }
	}
    }
}


#ifdef _WINDOWS
#ifdef __STDC__
void                WIN_TtaSwitchButton (Document document, View view, int index, int picture, int bState, BOOL state)
#else  /* __STDC__ */
void                WIN_TtaSwitchButton (document, view, index, picture, bState, state)
Document            document;
View                view;
int                 index;
int                 picture;
int                 bState;
BOOL                state;
#endif /* __STDC__ */
{
   int                 frame;

   UserErrorCode = 0;
   /* verifie le parametre document */
   if (document == 0 && view == 0)
      TtaError (ERR_invalid_parameter);
   else
     {
	frame = GetWindowNumber (document, view);
	if (frame == 0 || frame > MAX_FRAME)
	   TtaError (ERR_invalid_parameter);
	else if (FrameTable[frame].WdFrame != 0)
	  {
	     if (index >= MAX_BUTTON || index <= 0
		 || FrameTable[frame].Button[index] == 0)
		TtaError (ERR_invalid_parameter);
	     else
	       {
		  /* Insere le nouvel icone */
          SendMessage (WinToolBar[frame], bState, (WPARAM) FrameTable[frame].ButtonId[index], (LPARAM) MAKELONG (state, 0));
	       }
	  }
     }
}

#endif /* _WINDOWS */
/*----------------------------------------------------------------------
   TtcSwitchButtonBar

   Shows the buttonbar in a document view.
   This function must specify a valid view of a valid document.

   Parameters:
   document: identifier of the document.
   view: identifier of the view.

  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtcSwitchButtonBar (Document document, View view)
#else  /* __STDC__ */
void                TtcSwitchButtonBar (document, view)
Document            document;
View                view;
#endif /* __STDC__ */
{
   int                 frame;
#ifndef _WINDOWS
   Dimension           dy;
   Arg                 args[MAX_ARGS];
   ThotWidget          row;
#else /* _WINDOWS */
   RECT                r;
#endif /* _WINDOWS */

   UserErrorCode = 0;
   frame = 0;
   /* verifie le parametre document */
   if (document == 0 && view == 0)
      TtaError (ERR_invalid_parameter);
   else
     {
	frame = GetWindowNumber (document, view);
	if (frame == 0 || frame > MAX_FRAME)
	  {
	     TtaError (ERR_invalid_parameter);
	     return;
	  }
	else if (FrameTable[frame].WdFrame == 0)
	   return;
     }

#ifndef _WINDOWS
   row = FrameTable[frame].Button[0];
#ifndef _GTK
   XtSetArg (args[0], XmNheight, &dy);
   if (row != 0)
     {
	XtUnmanageChild (XtParent (XtParent (row)));
	if (XtIsManaged (row))
	  {
	     XtGetValues (row, args, 1);
	     XtUnmanageChild (row);
	     dy = -dy;
	     XtUnmanageChild (XtParent (row));
	  }
	else
	  {
	     XtManageChild (row);
	     XtGetValues (row, args, 1);
	  }

	/*FrameResized((int *)w, frame, NULL); */
	XtManageChild (XtParent (row));
	XtManageChild (XtParent (XtParent (row)));
     }
#endif /* _GTK */
#else  /* _WINDOWS */
   if (WinToolBar[frame] && IsWindowVisible (WinToolBar[frame])) {
      hmenu = WIN_GetMenu (frame); 
      CheckMenuItem (hmenu, menu_item, MF_BYCOMMAND | MF_UNCHECKED); 
      ShowWindow (WinToolBar[frame], SW_HIDE);
   } else {
        hmenu = WIN_GetMenu (frame); 
        CheckMenuItem (hmenu, menu_item, MF_BYCOMMAND | MF_CHECKED); 
        ShowWindow (WinToolBar[frame], SW_SHOW);
   }
   /* Resize other windows */
   GetClientRect (FrMainRef [frame], &r);
   PostMessage (FrMainRef [frame], WM_SIZE, 0, MAKELPARAM (r.right, r.bottom));
#endif /* _WINDOWS */
   /* force la mise a jour de la fenetre */
   TtaHandlePendingEvents ();
}


/*----------------------------------------------------------------------
   TextAction                                                      
  ----------------------------------------------------------------------*/
#ifdef _WINDOWS
#ifdef __STDC__
void WIN_APP_TextCallback (HWND w, int frame)
#else  /* __STDC__ */
void WIN_APP_TextCallback (w, rame)
HWND w; 
int  frame;
#endif /* __STDC__ */
#else  /* !_WINDOWS */
#ifdef __STDC__
static void         APP_TextCallback (ThotWidget w, int frame, XmTextVerifyCallbackStruct * call_d)
#else  /* __STDC__ */
static void         APP_TextCallback (w, frame, call_d)
ThotWidget          w;
int                 frame;
XmTextVerifyCallbackStruct *call_d;
#endif /* __STDC__ */
#endif /* _WINDOWS */
{
   Document            document;
   View                view;
   int                 i;
#  ifndef _WINDOWS
   STRING              text;
#  else  /* _WINDOWS */
   static CHAR_T text [1024];
#  endif /* _WINDOWS */

   CloseInsertion ();
   i = 0;
   while (i < MAX_TEXTZONE && FrameTable[frame].Text_Zone[i] != w)
      i++;
   if (i < MAX_TEXTZONE)
     {
	FrameToView (frame, &document, &view);
#   ifndef _WINDOWS
#ifndef _GTK
	text = XmTextGetString (w);
#endif /* _GTK */
#   else  /* _WINDOWS */
	GetWindowText (w, text, sizeof (text) + 1);
#   endif /* _WINDOWS */
	(*FrameTable[frame].Call_Text[i]) (document, view, text);
     }
}

/*----------------------------------------------------------------------
   TtaAddTextZone

   Adds a new textual command in a document view.
   This function must specify a valid view of a valid document.

   Parameters:
   document: the concerned document.
   view: the concerned view.
   label: label of the new entry.
   procedure: procedure to be executed when the new entry is changed by the
   user.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 TtaAddTextZone (Document document, View view, STRING label, ThotBool editable, void (*procedure) ())
#else  /* __STDC__ */
int                 TtaAddTextZone (document, view, label, editable, procedure)
Document            document;
View                view;
STRING              label;
ThotBool            editable;
void                (*procedure) ();

#endif /* __STDC__ */
{
   int                 frame, i;
   ThotWidget          w, row;
#  ifndef _WINDOWS
   int                 n;
   ThotWidget          rowh;
   ThotWidget         *brother;
   XmString            title_string;
   Arg                 args[MAX_ARGS];
#  else /* _WINDOWS */
   RECT       rect;
   ThotWidget wLabel;
#  endif /* _WINDOWS */

   UserErrorCode = 0;
   i = 0;
   w = 0;
   /* verifie le parametre document */
   if (document == 0 && view == 0)
      TtaError (ERR_invalid_parameter);
   else
     {
	frame = GetWindowNumber (document, view);
	if (frame == 0 || frame > MAX_FRAME)
	   TtaError (ERR_invalid_parameter);
	else if (FrameTable[frame].WdFrame != 0)
	  {
	     i = 0;
	     while (i < MAX_TEXTZONE && FrameTable[frame].Text_Zone[i] != 0)
		i++;
	     if (i < MAX_TEXTZONE)
	       {
		  row = FrameTable[frame].Text_Zone[0];
#ifndef _WINDOWS
#ifndef _GTK
		  XtUnmanageChild (XtParent (XtParent (row)));
	          XtManageChild (row);
 
		  /* Insere la nouvelle zone de texte */
		  n = 0;
		  XtSetArg (args[n], XmNchildren, &brother);
		  n++;
		  XtGetValues (row, args, n);

		  n = 0;
		  XtSetArg (args[n], XmNmarginWidth, 0);
		  n++;
		  XtSetArg (args[n], XmNmarginHeight, 0);
		  n++;
		  XtSetArg (args[n], XmNbackground, BgMenu_Color);
		  n++;
		  XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM);
		  n++;
		  if (brother == NULL)
		    {
		       XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM);
		       n++;
		    }
		  else
		    {
		       XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET);
		       n++;
		       XtSetArg (args[n], XmNtopWidget, *brother);
		       n++;
		       XtSetArg (args[n], XmNbottomWidget, *brother);
		       n++;
		    }
		  XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM);
		  n++;
		  rowh = XmCreateForm (row, "Dialogue", args, n);
		  XtManageChild (rowh);
		  if (label != NULL)
		    {
		       n = 0;
		       XtSetArg (args[n], XmNbackground, BgMenu_Color);
		       n++;
		       XtSetArg (args[n], XmNforeground, FgMenu_Color);
		       n++;
		       XtSetArg (args[n], XmNheight, (Dimension) FontHeight (LargeFontDialogue));
		       n++;
		       XtSetArg (args[n], XmNfontList, DefaultFont);
		       n++;
		       title_string = XmStringCreateSimple (label);
		       XtSetArg (args[n], XmNlabelString, title_string);
		       n++;
		       /*XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM);
		       n++;
		       XtSetArg (args[n], XmNalignment, XmALIGNMENT_BEGINNING);
		       n++;
		       XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM);
		       n++;*/
		       XtSetArg (args[n], XmNalignment, XmALIGNMENT_CENTER);
		       n++;
		       XtSetArg (args[n], XmNy, (Dimension) 10);
		       n++;
		       XtSetArg (args[n], XmNwidth, (Dimension) 60);
		       n++;
		       w = XmCreateLabel (rowh, "Dialogue", args, n);
		       XtManageChild (w);
		       XmStringFree (title_string);
		    }

		  n = 0;
		  XtSetArg (args[n], XmNbackground, BgMenu_Color);
		  n++;
		  XtSetArg (args[n], XmNforeground, FgMenu_Color);
		  n++;
		  XtSetArg (args[n], XmNeditMode, XmSINGLE_LINE_EDIT);
		  n++;
		  XtSetArg (args[n], XmNtraversalOn, TRUE);
		  n++;
		  XtSetArg (args[n], XmNkeyboardFocusPolicy, XmEXPLICIT);
		  n++;
		  XtSetArg (args[n], XmNsensitive, TRUE);
		  n++;
		  XtSetArg (args[n], XmNeditable, editable);
		  n++;
		  XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM);
		  n++;
		  XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM);
		  n++;
		  XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM);
		  n++;
		  if (label != NULL)
		    {
		       XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET);
		       n++;
		       XtSetArg (args[n], XmNleftWidget, w);
		       n++;
		    }
		  else
		    {
		       XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM);
		       n++;
		    }

		  w = XmCreateText (rowh, "Dialogue", args, n);
		  XtManageChild (w);
		  FrameTable[frame].Text_Zone[i] = w;
		  if (procedure != NULL)
		    {
		       XtAddCallback (w, XmNactivateCallback, (XtCallbackProc) APP_TextCallback, (XtPointer) frame);
		       FrameTable[frame].Call_Text[i] = (Proc) procedure;
		    }
		  XtManageChild (XtParent (XtParent (XtParent (row))));
		  XtManageChild (XtParent (XtParent (row)));
#endif /* _GTK */
#else  /* _WINDOWS */
		          currentFrame = frame;
                  GetClientRect (FrMainRef [frame], &rect);
                  w = CreateWindow (TEXT("EDIT"), TEXT(""), WS_CHILD | WS_VISIBLE | ES_LEFT | WS_BORDER | ES_AUTOHSCROLL,
                                    0, 0, 0, 0, FrMainRef[frame], (HMENU) i, hInstance, NULL);

                  FrameTable[frame].Text_Zone[i] = w;
                  FrameTable[frame].Call_Text[i] = (Proc) procedure;

				  if (lpfnTextZoneWndProc == (WNDPROC) 0)
                     lpfnTextZoneWndProc = (WNDPROC) SetWindowLong (FrameTable[frame].Text_Zone[i], GWL_WNDPROC, (DWORD) textZoneProc);
				  else
				     SetWindowLong (FrameTable[frame].Text_Zone[i], GWL_WNDPROC, (DWORD) textZoneProc);

                  wLabel = CreateWindow (TEXT("STATIC"), label, WS_CHILD | WS_VISIBLE | SS_LEFT, 
                                         0, 0, 0, 0, FrMainRef[frame], (HMENU) (i + MAX_TEXTZONE), hInstance, NULL);
                  FrameTable[frame].Label[i] = wLabel;
				  /* FrameTable[frame].showLogo = TRUE; */
                  PostMessage (FrMainRef[frame], WM_SIZE, 0, MAKELPARAM (rect.right, rect.bottom));
#endif /* _WINDOWS */
	       }
	     else
		i = 0;
	  }
     }
   /* force la mise a jour de la fenetre */
   TtaHandlePendingEvents ();
   return (i);
}


/*----------------------------------------------------------------------
   TtaSetTextZone

   Sets the text in text-zone in a document view.
   This function must specify a valid view of a valid document.

   Parameters:
   document: identifier of the document.
   view: identifier of the view.
   index: 

  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtaSetTextZone (Document document, View view, int index, STRING text)
#else  /* __STDC__ */
void                TtaSetTextZone (document, view, index, text)
Document            document;
View                view;
int                 index;
STRING              text;

#endif /* __STDC__ */
{
   int                 frame;
   ThotWidget          w;

   UserErrorCode = 0;
   /* verifie le parametre document */
   if (document == 0 && view == 0 && (index < 1 || index >= MAX_TEXTZONE) && text != NULL)
      TtaError (ERR_invalid_parameter);
   else
     {
	frame = GetWindowNumber (document, view);
	if (frame == 0 || frame > MAX_FRAME)
	   TtaError (ERR_invalid_parameter);
	else if (FrameTable[frame].WdFrame != 0)
	  {
	      /* w = FrameTable[frame].Text_Zone[index]; */
	     /*XtRemoveCallback(w, XmNmodifyVerifyCallback, (XtCallbackProc)APP_TextCallback, (XtPointer)frame); */
#            ifndef _WINDOWS
	     w = FrameTable[frame].Text_Zone[index];
#ifndef _GTK
	     if (w != 0)
		XmTextSetString (w, text);
#endif /* _GTK */
#            else  /* _WINDOWS */
	     w = FrameTable[frame].Text_Zone[index - 1];
	     if (w != 0)
                 SetWindowText (w, text);

#            endif /* _WINDOWS */
	     /*XtAddCallback(w, XmNmodifyVerifyCallback, (XtCallbackProc)APP_TextCallback, (XtPointer)frame); */
	  }
     }
#  ifndef _WINDOWS
   XFlush (TtDisplay);
#  endif /* _WINDOWS */
}


/*----------------------------------------------------------------------
   TtcSwitchCommands

   Shows or hides the commands part in a document view.
   This function must specify a valid view of a valid document.

   Parameters:
   document: identifier of the document.
   view: identifier of the view.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtcSwitchCommands (Document document, View view)
#else  /* __STDC__ */
void                TtcSwitchCommands (document, view)
Document            document;
View                view;
#endif /* __STDC__ */
{
   int                 frame;

#  ifndef _WINDOWS
   Dimension           y, dy;
   Arg                 args[MAX_ARGS];
   ThotWidget          row, w;
#  endif

#  ifdef _WINDOWS
   int     index, nbZonesShown = 0;
   ThotBool itemChecked = FALSE;
   RECT    r;
#  endif /* _WINDOWS */


   UserErrorCode = 0;
   /* verifie le parametre document */
   if (document == 0 && view == 0)
      TtaError (ERR_invalid_parameter);
   else
     {
	frame = GetWindowNumber (document, view);
#   ifdef _WINDOWS
    /* FrameTable[frame].showLogo = !FrameTable[frame].showLogo; */
#   endif /* _WINDOWS */ 
	if (frame == 0 || frame > MAX_FRAME)
	   TtaError (ERR_invalid_parameter);
	else if (FrameTable[frame].WdFrame != 0)
	  {
#         ifndef _WINDOWS
#ifndef _GTK
	     row = XtParent (FrameTable[frame].Text_Zone[0]);
	     XtSetArg (args[0], XmNwidth, &dy);
	     if (row != 0)
	       {
		  XtUnmanageChild (XtParent (XtParent (row)));
		  if (XtIsManaged (row))
		    {
		       XtGetValues (row, args, 1);
		       XtUnmanageChild (row);
		       dy = -dy;
		    }
		  else
		    {
		       XtManageChild (row);
		       XtGetValues (row, args, 1);
		    }
		  XFlush (TtDisplay);
		  /* Il faut forcer la reevaluation de la fenetre */
		  w = FrameTable[frame].WdFrame;
		  XtSetArg (args[0], XmNwidth, &y);
		  XtGetValues (row, args, 1);
		  XtSetArg (args[0], XmNwidth, y + dy);
		  XtSetValues (row, args, 1);
		  FrameResized ((int *) w, frame, NULL);
		  XtManageChild (XtParent (XtParent (row)));
	       }
#endif /* _GTK */
#         else  /* _WINDOWS */
	     for (index = 0; index <  MAX_TEXTZONE; index++) {
		 if (FrameTable[frame].Text_Zone[index] && IsWindowVisible (FrameTable[frame].Text_Zone[index])) {
            if (!itemChecked) {
               hmenu = WIN_GetMenu (frame); 
               CheckMenuItem (hmenu, menu_item, MF_BYCOMMAND | MF_UNCHECKED); 
               itemChecked = TRUE;
            }

		    ShowWindow (FrameTable[frame].Label [index], SW_HIDE);
		    ShowWindow (FrameTable[frame].Text_Zone [index], SW_HIDE);
		 } else {
              if (!itemChecked) {
                 hmenu = WIN_GetMenu (frame); 
                 CheckMenuItem (hmenu, menu_item, MF_BYCOMMAND | MF_CHECKED); 
              }

		      ShowWindow (FrameTable[frame].Label [index], SW_SHOW);
		      ShowWindow (FrameTable[frame].Text_Zone [index], SW_SHOW);
		 }
	     }

             GetClientRect (FrMainRef [frame], &r);
             PostMessage (FrMainRef [frame], WM_SIZE, 0, MAKELPARAM (r.right, r.bottom));
#         endif /* _WINDOWS */
	  }
     }
   /* force la mise a jour de la fenetre */
   TtaHandlePendingEvents ();
}


/*----------------------------------------------------------------------
   Evenement sur une frame document.                              
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                DrawingInput (int *w, int frame, int *infos)
#else  /* __STDC__ */
void                DrawingInput (w, frame, infos)
int                *w;
int                 frame;
int                *infos;

#endif /* __STDC__ */
{
}

/*----------------------------------------------------------------------
  Callback function appelle par une frame lorsque celle-ci recoit un
  evenement de type exposer. Redessine la page.
  Le paramtre widget indique le widget qui a appell cette fonction.
  Le parametre event contient des informations sur l'evenement.
  Le parametre data contient le numero de la frame.
-------------------------------------------------------------------------*/
#ifdef _GTK
gint ExposeCB (ThotWidget widget, GdkEventExpose *event, gpointer data)
{
  int nframe;
  int                 x;
  int                 y;
  int                 l;
  int                 h;

  nframe = (int )data;
   x = event->area.x;
   y = event->area.y;
   l = event->area.width;
   h = event->area.height;


  if (nframe > 0 && nframe <= MAX_FRAME)
     {
       DefRegion (nframe, x, y, l+x, y+h );
       RedrawFrameBottom(nframe, 0, NULL);
     }

 return FALSE;
}

gint InsertEvent (GtkWidget *widget, GdkEventKey *event, gpointer data)
{
    TtaAbortShowDialogue ();
    XCharTranslation (event, data);
 return FALSE;
}

gint ExposeEvent2 (GtkWidget *widget, GdkEventButton *event, gpointer data)
{
  int nframe;
  int                 x;
  int                 y;
  int                 l;
  int                 frame;

   PtrDocument         docsel;
   PtrElement          firstSel, lastSel;
   Document            document;
   View                view;
   int                 firstCar, lastCar;
   ThotBool            ok;
   int                 comm, dx, dy, sel, h;

   frame = (int )data;
   gtk_widget_grab_focus(widget);

    /* ne pas traiter si le document est en mode NoComputedDisplay */
   if (documentDisplayMode[FrameTable[frame].FrDoc - 1] == NoComputedDisplay)
      return FALSE ;
   /*_______> S'il n'y a pas d'evenement associe */
   else if (event == NULL)
      return FALSE;
   /*_______> Si une designation de pave est attendue*/
   else if (ClickIsDone == 1 && event->type == GDK_BUTTON_PRESS)
     {
        ClickIsDone = 0;
        ClickFrame = frame;
        ClickX = event->x;
        ClickY = event->y;
        return FALSE;
     }

   switch (event->type)
     {
     case GDK_BUTTON_PRESS:

       /*_____________________________________________________*/
       switch (event->button)
         {
           /* ==========BOUTON GAUCHE========== */
         case 1:
           /* Termine l'insertion courante s'il y en a une */
           CloseInsertion ();

           /* Est-ce que la touche modifieur de geometrie est active ? */
           if ((event->state & GDK_CONTROL_MASK ) == GDK_CONTROL_MASK)
             {
               /* On change la position d'une boite */
               ApplyDirectTranslate (frame, event->x, event->y);
             }
           /* Est-ce que la touche modifieur d'extension est active ? */
           else if ((event->state & GDK_SHIFT_MASK ) == GDK_SHIFT_MASK)
             {
               TtaAbortShowDialogue ();
               LocateSelectionInView (frame, event->x, event->y, 0);
               FrameToView (frame, &document, &view);
               TtcCopyToClipboard (document, view);
             }
           /* Est-ce un double clic */
           /* else if (t1 + (Time) DoubleClickDelay > event->time)
             {
               TtaAbortShowDialogue ();
               TtaLockMainLoop();
               TtaFetchOneEvent (&event);
               while (event.type != ButtonRelease)
                 {
                   TtaHandleOneEvent (&event);
                   TtaFetchOneEvent (&event);
                 }
                 TtaUnlockMainLoop(); */

               /* memorise la position de la souris */
           /* if (ClickFrame == frame
                   && (ClickX - event->x < 3 || ClickX - event->x > 3)
                   && (ClickY - event->y < 3 || ClickY - event->y > 3))*/
                 /* it's really a double click */
           /*sel = 3;
               else
                 sel = 2;
               ClickFrame = frame;
               ClickX = event->x;
               ClickY = event->y;
               LocateSelectionInView (frame, ClickX, ClickY, sel);
               } */
           /* Sinon c'est une selection normale */
           else
             {
               t1 = event->time;
               ClickFrame = frame;
               ClickX = event->x;
               ClickY = event->y;
               LocateSelectionInView (frame, ClickX, ClickY, 2);

               /* Regarde s'il s'agit d'un drag ou d'une simple marque d'insertion */
               comm = 0;        /* il n'y a pas de drag */
               TtaLockMainLoop();
               /*TtaFetchOneEvent (&event);*/
               FrameToView (frame, &document, &view);
               h = FrameTable[frame].FrHeight;
               /*while (event.type != GDK_BUTTON_RELEASE && event.type != GDK_BUTTON_PRESS)
                 {
                   if (event.type == MotionNotify ||
                       (event.type != ConfigureNotify &&
                        event.type != MapNotify &&
                        event.type != UnmapNotify &&
                        event.type != DestroyNotify &&*/
                        /*event.type != NoExpose && */
               /*(event.xmotion.y > h || event.xmotion.y < 0)))
                     {
                       dx = event.xmotion.x - ClickX;
                       dy = event.xmotion.y - ClickY;
                       if (dx > 2 || dx < -2 || dy > 2 || dy < -2 ||
                           event.xmotion.y > h || event.xmotion.y < 0)
                         {
                           LocateSelectionInView (frame, event.xbutton.x, event.xbutton.y, 1);
                           comm = 1;
                           if (event.xmotion.y > h)
                             TtcLineDown (document, view);
                           else if (event.xmotion.y < 0)
                             TtcLineUp (document, view);
                         }
                     }
                   TtaHandleOneEvent (&event);
                   TtaFetchOrWaitEvent (&event);
                 }
               TtaHandleOneEvent (&event);
               TtaUnlockMainLoop();*/

               /* S'il y a un drag on termine la selection */
               FrameToView (frame, &document, &view);
               if (comm == 1)
                 LocateSelectionInView (frame, event->x, event->y, 0);
               else if (comm == 0)
                  /* click event */
                 LocateSelectionInView (frame, event->x, event->y, 4);

               if (comm != 0)
                 TtcCopyToClipboard (document, view);
             }
           break;

           /* ==========BOUTON MILIEU========== */
         case 2:
           /* Termine l'insertion courante s'il y en a une */
           CloseInsertion ();
           /* Est-ce que la touche modifieur de geometrie est active ? */
           if ((event->state & GDK_CONTROL_MASK) != 0)
             {
               /* On modifie les dimensions d'une boite */
               ApplyDirectResize (frame, event->x, event->y);
             }
           else
             {
               FrameToView (frame, &document, &view);
               if (MenuActionList[CMD_PasteFromClipboard].Call_Action != NULL)
                 (*MenuActionList[CMD_PasteFromClipboard].Call_Action) (document, view);
             }
           break;

           /* ==========BOUTON DROIT========== */
         case 3:
           /* Termine l'insertion courante s'il y en a une */
           CloseInsertion ();
           if ((event->state & GDK_CONTROL_MASK) != 0)
             {
               /* On modifie les dimensions d'une boite */
               ApplyDirectResize (frame, event->x, event->y);
             }
           else if (!GetCurrentSelection (&docsel, &firstSel, &lastSel, &firstCar, &lastCar))
             /* non, message 'Selectionnez' */
             TtaDisplaySimpleMessage (INFO, LIB, TMSG_SEL_EL);
           else if (docsel->DocReadOnly)
             /* on ne peut inserer ou coller dans un document en lecture seule */
             TtaDisplaySimpleMessage (INFO, LIB, TMSG_RO_DOC_FORBIDDEN);
           else if (firstCar != 0 && firstSel->ElTerminal && firstSel->ElLeafType == LtPolyLine)
             {
               /* selection a l'interieur d'une polyline */
               if (ThotLocalActions[T_editfunc] != NULL)
                 (*ThotLocalActions[T_editfunc]) (TEXT_INSERT);
             }
           else
             {
               TtaSetDialoguePosition ();
               if (ThotLocalActions[T_insertpaste] != NULL)
                 (*ThotLocalActions[T_insertpaste]) (TRUE, FALSE, TEXT('R'), &ok);
             }

         default:
           break;
         }
       break;

       /*    case KeyPress:
       t1 = 0;
       TtaAbortShowDialogue ();
       XCharTranslation (ev);
       break;

     case EnterNotify:
       t1 = 0;
       break;

     case LeaveNotify:
       t1 = 0;
       break; */

     default:
       break;
     }
 return FALSE;
}
#endif /* _GTK */

/*----------------------------------------------------------------------
   Cree une frame a' la position X,Y et aux dimensions width et       
   height (s'ils sont positifs).                                        
   Le parametre texte donne le titre de la fenetree^tre.                      
   Le parametre schema donne le nom du sche'ma pour lequel on cre'e   
   la fenetre de document (NULL pour la fenetree^tre application).       
   Le parametre name donne le titre de la fenetree^tre.                       
   Le paramentre doc donne le numero du document.                     
   Retourne :                                                         
   - Le volume affichable dans la fenetre en equivalent caracteres.   
   - L'indice de la fenetre allouee ou 0 en cas d'echec.              
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 MakeFrame (CHAR_T* schema, int view, STRING name, int X, int Y, int width, int height, int *volume, int doc)
#else  /* __STDC__ */
int                 MakeFrame (schema, view, name, X, Y, width, height, volume, doc)
CHAR_T*             schema;
int                 view;
STRING              name;
int                 X;
int                 Y;
int                 width;
int                 height;
int                *volume;
int                 doc;
#endif /* __STDC__ */
{
#ifdef _WINDOWS
   ThotMenu            menu_bar, w;
#else  /* _WINDOWS */
   ThotWidget          menu_bar;
   ThotWidget          w; /* menu button */
   ThotWidget          table1;
   ThotWidget          drawing_area;
   ThotWidget          drawing_frame;  
   ThotWidget          hbox1, hbox2;
   ThotWidget          vbox1;
#ifdef _GTK
   ThotWidget          vbox2;
   ThotWidget          vbox3;
   ThotWidget          menu_item;
   ThotWidget          logo_pixmap;
   ThotWidget          table3;
   ThotWidget          table4;
   ThotWidget          table5;
   ThotWidget          entry1;
   ThotWidget          entry2;
   ThotWidget          label1;
   ThotWidget          statusbar;
   ThotWidget          toolbar;
   GdkPixmap          *amaya_pixmap;
   GdkBitmap          *amaya_mask;
#else /* _GTK */
   ThotWidget          shell;
   Arg                 args[MAX_ARGS], argument[5];
   XmString            title_string;
   CHAR_T              string[700];
   int                 n;
#endif /* _GTK */
   Dimension           dx, dy;
#endif /* _WINDOWS */
   ThotWidget          Main_Wd = 0;
   ThotWidget          hscrl;
   ThotWidget          vscrl;
   SchemaMenu_Ctl     *SCHmenu;
   Menu_Ctl           *ptrmenu;
   CHAR_T*             visiStr;
   CHAR_T*             zoomStr;
   int                 i;
   int                 ref;
   int                 visiVal, zoomVal;
   int                 frame;
   ThotBool            found;

#define MIN_HEIGHT 100
#define MIN_WIDTH 200
   w = 0;
#  ifdef _WINDOWS
   hwndClient = 0;
   ToolBar    = 0;
   logoFrame  = 0;
   StatusBar  = 0;

   ustrcpy (wTitle, name);
#  endif /* _WINDOWS */

#ifdef _GTK
   menu_bar = NULL;
#endif /* _GTK */
   frame = 0;
   if (schema != NULL)
     {
       /* Allocation d'une entree dans la table des fenetres */
       found = FALSE;
       frame = 1;
       while (frame <= MAX_FRAME && !found)
	 {
	   /* Recherche une frame ouverte vide */
	   found = (FrameTable[frame].FrDoc == 0 && FrameTable[frame].WdFrame != 0);
	   if (!found)
	     frame++;
	 }
       if (!found)
	 {
	   frame = 1;
	   while (frame <= MAX_FRAME && !found)
	     {
	       /* Recherche une frame libre */
	       found = (FrameTable[frame].WdFrame == 0);
	       if (!found)
		 frame++;
	     }
	 }

       if (!found)
	 frame = 0;
       else if (FrameTable[frame].WdFrame == 0)
	 {
	   /* il faut creer effectivement la fenetre */
	   FrameTable[frame].FrTopMargin = 0;
	   /* Verification des dimensions */
	   if (width == 0)
	     width = 180;	/* largeur en mm */
	   if (height == 0)
	     height = 240;	/* hauteur en mm */
	   height = height + FrameTable[frame].FrTopMargin;
	   
#ifdef _WINDOWS
	   /*** Build the document window ***/
	   if (X < 0)
	     X = 2;
	   if (Y < 0)
	     Y = 2;
	   Main_Wd = CreateWindowEx (0L, TEXT("Amaya"),    /* window class name */
				     NULL,	/* window caption    */
				     WS_OVERLAPPEDWINDOW, /* window style            */
				     X,	    /* initial x pos           */
				     Y,	    /* initial y pos           */
				     width, /* initial x size          */
				     height,  /* initial y size          */
				     NULL,  /* parent window handle    */
				     NULL,  /* window menu handle      */
				     hInstance,	/* program instance handle */
				     NULL);	/* creation parameters     */

	   if (Main_Wd == 0)
	     WinErrorBox (WIN_Main_Wd, TEXT("MakeFrame"));
	   else {
	     /* store everything. */
	     FrMainRef[frame]            = Main_Wd;
	     FrRef[frame]                = hwndClient;
	     WinToolBar[frame]           = ToolBar;
	     FrameTable[frame].WdStatus  = StatusBar;
	     /* and show it up. */
                  
	     menu_bar = CreateMenu ();
	     if (!menu_bar) 
	       WinErrorBox (Main_Wd, TEXT("MakeFrame"));
	     else 
	       WinMenus[frame] = menu_bar;
	   }
#else /* _WINDOWS */
	   if (width < MIN_WIDTH)
	     dx = (Dimension) MIN_WIDTH;
	   else
	     dx = (Dimension) width;
	   if (height < MIN_HEIGHT)
	     dy = (Dimension) MIN_HEIGHT;
	   else
	     dy = (Dimension) height;
	   if (X < 0)
	     X = 2;
	   if (Y < 0)
	     Y = 2;

#ifdef _GTK
	   /*** Build the document window ***/
	   Main_Wd = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	   gtk_window_set_title (GTK_WINDOW (Main_Wd), "Amaya");
	   gtk_window_set_policy (GTK_WINDOW (Main_Wd), TRUE, TRUE, FALSE);
	   gtk_signal_connect (GTK_OBJECT (Main_Wd), "destroy",
		      GTK_SIGNAL_FUNC (FrameKilled),(gpointer) frame);
	  
	   /* Cration de la table contenant les differents elements de l'interface */
	   vbox1 = gtk_vbox_new (FALSE, 0);
	   gtk_widget_show (vbox1);
	   gtk_container_add (GTK_CONTAINER (Main_Wd), vbox1);

	   /* Creation de la table contenant la bar de menu */
	   vbox2 = gtk_vbox_new (FALSE, 0);
	   gtk_widget_show (vbox2);
	   gtk_box_pack_start (GTK_BOX (vbox1), vbox2, FALSE, TRUE, 0);

	   /*if (wind_pixmap != 0) */
	     /* Creation de la fenetre icone associee */
	     /*XtSetArg (args[n], XmNiconPixmap, wind_pixmap)*/;
#else /* _GTK */
	   /*** Building the document window ***/
	   n = 0;
	   XtSetArg (args[n], XmNdefaultFontList, DefaultFont);
	   n++;
	   sprintf (string, "+%d+%d", X, Y);
	   XtSetArg (args[n], XmNgeometry, (String) string);
	   n++;
	   XtSetArg (args[n], XmNwidth, dx + 4);
	   n++;
	   XtSetArg (args[n], XmNheight, dy + 4);
	   n++;
	   if (wind_pixmap != 0)
	     {
	       /* Creation of the associated icon window */
	       XtSetArg (args[n], XmNiconPixmap, wind_pixmap);
	       n++;
	     }
	   XtSetArg (args[n], XmNmwmDecorations, MWM_DECOR_ALL);
	   n++;
	   XtSetArg (args[n], XmNkeyboardFocusPolicy, XmPOINTER);
	   n++;
	   shell = XtCreatePopupShell (name, applicationShellWidgetClass, RootShell, args, n);
	   
	   n = 0;
	   XtSetArg (args[n], XmNwidth, dx + 4);
	   n++;
	   XtSetArg (args[n], XmNheight, dy + 4);
	   n++;
	   XtSetArg (args[n], XmNbackground, Scroll_Color);
	   n++;
	   XtSetArg (args[n], XmNspacing, 0);
	   n++;
	   XtSetArg (args[n], XmNkeyboardFocusPolicy, XmPOINTER);
	   n++;
	   Main_Wd = XmCreateMainWindow (shell, "Thot_Doc", args, n);

	   XtManageChild (Main_Wd);
	   XtAddCallback (shell, XmNdestroyCallback, (XtCallbackProc) FrameKilled, (XtPointer) frame);
#endif /* _GTK */
#endif /* _WINDOWS */
	   
	   /* Look for the menu list to be built */
	   SCHmenu = SchemasMenuList;
	   ptrmenu = NULL;
	   while (SCHmenu != NULL && ptrmenu == NULL)
	     {
	       if (!ustrcmp (schema, SCHmenu->SchemaName))
		 /* that document has specific menus */
		 ptrmenu = SCHmenu->SchemaMenu;
	       else
		 /* next schema */
		 SCHmenu = SCHmenu->NextSchema;
	     }
	   if (ptrmenu == NULL)
	     /* the document uses standard menus */
	     ptrmenu = DocumentMenuList;
	   
	   /**** Build menus ****/
	   FrameTable[frame].FrMenus = ptrmenu;
	   /* reference du menu construit */
	   ref = frame + MAX_LocalMenu;
	   i = 0;
	   /* Initialise les menus dynamiques */
	   FrameTable[frame].MenuAttr = -1;
	   FrameTable[frame].MenuSelect = -1;
	   FrameTable[frame].MenuPaste = -1;
	   FrameTable[frame].MenuUndo = -1;
	   FrameTable[frame].MenuRedo = -1;

#ifndef _WINDOWS
#ifndef _GTK
	   menu_bar = 0;
	   n = 0;
	   XtSetArg (args[n], XmNbackground, BgMenu_Color);
	   n++;
	   XtSetArg (args[n], XmNforeground, FgMenu_Color);
	   n++;
	   XtSetArg (args[n], XmNfontList, DefaultFont);
	   n++;
	   XtSetArg (args[n], XmNspacing, 0);
	   n++;
	   XtSetArg (args[n], XmNborderWidth, 0);
	   n++;
#endif /* _GTK */
#endif /* _WINDOWS */

	   while (ptrmenu != NULL)
	     {
	       /* skip menus that concern another view */
	       if (ptrmenu->MenuView == 0 || ptrmenu->MenuView == view)
		 if (Prof_ShowMenu (ptrmenu))
		   {
		     if (menu_bar == 0)
		       {
			 /*** The menu bar ***/
#ifndef _WINDOWS
#ifdef _GTK
			 menu_bar = gtk_menu_bar_new ();
			 gtk_widget_show (menu_bar);
			 gtk_box_pack_start (GTK_BOX (vbox2), menu_bar, FALSE, TRUE, 0);
#else /* _GTK */
			 XtSetArg (argument[0], XmNbackground, BgMenu_Color);
			 XtSetArg (argument[1], XmNspacing, 0);
			 menu_bar = XmCreateMenuBar (Main_Wd, "Barre_menu", argument, 2);
			 XtManageChild (menu_bar);
#endif /* _GTK */
#endif /* !_WINDOWS */
		       }
		   
#ifdef _WINDOWS
		     w = CreateMenu ();
#else  /* _WINDOWS */
#ifdef _GTK
		     w = gtk_menu_new ();
#else /* _GTK */
		     w = XmCreateCascadeButton (menu_bar, TtaGetMessage (THOT, ptrmenu->MenuID), args, n);
#endif /* _GTK */
#endif /* !_WINDOWS */
		     FrameTable[frame].WdMenus[i] = w;
		     FrameTable[frame].EnabledMenus[i] = TRUE;
		     /* Evite la construction des menus dynamiques */
		     if (ptrmenu->MenuAttr)
		       FrameTable[frame].MenuAttr = ptrmenu->MenuID;
		     else if (ptrmenu->MenuSelect) 
		       FrameTable[frame].MenuSelect = ptrmenu->MenuID;
		     else 
		       BuildPopdown (ptrmenu, ref, w, frame, doc);
#ifdef _WINDOWS
		     AppendMenu (menu_bar, MF_POPUP, (UINT) w, TtaGetMessage (THOT, ptrmenu->MenuID));
#else  /* !_WINDOWS */
#ifdef _GTK
		     menu_item = gtk_menu_item_new_with_label (TtaGetMessage (THOT, ptrmenu->MenuID));
		     gtk_widget_show (menu_item);
		     if (ptrmenu->MenuHelp == TRUE)
		       gtk_menu_item_right_justify(GTK_MENU_ITEM(menu_item));
		     gtk_container_add(GTK_CONTAINER (menu_bar), menu_item);
		     gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_item), w);
#else /* _GTK */
		     XtManageChild (w);
		     /* Register dynamic menus */
		     if (ptrmenu->MenuHelp)
		       {
			 /* Menu help at the right side*/
			 XtSetArg (argument[0], XmNmenuHelpWidget, w);
			 XtSetValues (XtParent (w), argument, 1);
		       }
#endif /* _GTK */
#endif /* _WINDOWS */
		   }

	       ptrmenu = ptrmenu->NextMenu;
	       ref += MAX_ITEM;
	       i++;
	     }

	   /* enable othe menu entries */
	   while (i < MAX_MENU)
	     {
	       FrameTable[frame].EnabledMenus[i] = FALSE;
	       i++;
	     }

#ifndef _WINDOWS
#ifdef _GTK
	   /* Building the top window */
	   vbox3 = gtk_vbox_new (FALSE, 0);
	   gtk_widget_show (vbox3);
	   gtk_box_pack_start (GTK_BOX (vbox1), vbox3, FALSE, TRUE, 0);


	   /* creation of the toolbar */
	   toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
	   gtk_widget_set_usize (GTK_WIDGET (toolbar),-1, 20);
	   gtk_widget_show (toolbar);
	   gtk_box_pack_start (GTK_BOX(vbox3), toolbar, FALSE, TRUE, 0);
	 
	   for (i=1; i<MAX_BUTTON ; i++)
	     FrameTable[frame].Button[i] = NULL;
	   FrameTable[frame].Button[0] = toolbar;

	   /* The table which includes the logo, labels and text zones */
	   hbox1 = gtk_hbox_new (FALSE, 0);
	   gtk_widget_show (hbox1);
	   gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 0);
  
	   /* logo */
	   amaya_pixmap = gdk_pixmap_create_from_xpm_d (DefaultWindow->window, &amaya_mask,
						      &DefaultWindow->style->bg[GTK_STATE_NORMAL],
						      logo_xpm);
	   logo_pixmap = gtk_pixmap_new (amaya_pixmap, amaya_mask);
	   gdk_pixmap_unref (amaya_pixmap);
	   gdk_bitmap_unref (amaya_mask);
	   gtk_widget_show (logo_pixmap);
	   gtk_box_pack_start (GTK_BOX (hbox1), logo_pixmap, FALSE, FALSE, 0);
	   gtk_misc_set_alignment (GTK_MISC (logo_pixmap), 0.15, 0.5);
	   
	   /* Creation des  tables contenant les labels et zones de saisie d'URL */
	   table1 = gtk_table_new (2, 2, FALSE);
	   gtk_widget_show (table1);
	   gtk_box_pack_start (GTK_BOX (hbox1), table1, TRUE, TRUE, 0);
	   label1 = gtk_label_new ("URL");
	   gtk_widget_show (label1);
	   gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
	   gtk_misc_set_padding (GTK_MISC (label1), 10, 5);

	   table3 = gtk_table_new (1, 1, FALSE);
	   gtk_widget_show (table3);
	   gtk_table_attach (GTK_TABLE (table1), table3, 0, 1, 1, 2,
			     (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 0,0);
	   table4 = gtk_table_new (1, 1, FALSE);
	   gtk_widget_show (table4);
	   gtk_table_attach (GTK_TABLE (table1), table4, 1, 2, 0, 1,
			     (GtkAttachOptions)GTK_EXPAND |GTK_FILL, 
			     (GtkAttachOptions)GTK_EXPAND | GTK_FILL, 0,0);
 

	   entry1 = gtk_entry_new ();
	   gtk_widget_show (entry1);
	   gtk_table_attach (GTK_TABLE (table4), entry1, 0, 1, 0, 1,
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL,
		    (GtkAttachOptions)  GTK_EXPAND | GTK_FILL, 0,0);

	   table5 = gtk_table_new (1, 1, FALSE);
	   gtk_widget_show (table5);
	   gtk_table_attach (GTK_TABLE (table1), table5, 1, 2, 1, 2,
			     (GtkAttachOptions)GTK_EXPAND |GTK_FILL, 
			     (GtkAttachOptions)GTK_EXPAND | GTK_FILL, 0,0);

	   entry2 = gtk_entry_new ();
	   gtk_widget_show (entry2);
	   gtk_table_attach (GTK_TABLE (table5), entry2, 0, 1, 0, 1,
			     (GtkAttachOptions) GTK_EXPAND | GTK_FILL,
			     (GtkAttachOptions)  GTK_EXPAND | GTK_FILL, 0,0);
 
	   hbox2 = gtk_hbox_new (FALSE, 0);
	   gtk_widget_show (hbox2);
	   gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 0);

	   /*Creation d'une frame pour placer la drawing area */
	   drawing_frame = gtk_frame_new (NULL);
	   gtk_frame_set_shadow_type (GTK_FRAME (drawing_frame),GTK_SHADOW_IN);
	   gtk_widget_show (drawing_frame);
	   gtk_box_pack_start (GTK_BOX (hbox2), drawing_frame, TRUE, TRUE, 0);

	   /* Creation de la drawing area */
	   drawing_area = gtk_drawing_area_new ();

	   gtk_container_add (GTK_CONTAINER (drawing_frame), drawing_area);
	   gtk_drawing_area_size(GTK_DRAWING_AREA(drawing_area), dx, dy);
           GTK_WIDGET_SET_FLAGS(drawing_area, GTK_CAN_FOCUS);
           gtk_widget_grab_focus(drawing_area);

           gtk_signal_connect (GTK_OBJECT (drawing_area), "button_press_event",
                           (GtkSignalFunc) ExposeEvent2, (gpointer) frame);
           gtk_signal_connect (GTK_OBJECT (drawing_area), "selection_notify_event",
                           (GtkSignalFunc) ExposeEvent2, (gpointer) frame);
	   gtk_signal_connect (GTK_OBJECT (drawing_area), "expose_event",
                           (GtkSignalFunc) ExposeCB, (gpointer) frame);
	   gtk_signal_connect (GTK_OBJECT(drawing_area),"configure_event",
                           (GtkSignalFunc)FrameResized, (gpointer) frame);
           gtk_widget_set_events (drawing_area, GDK_BUTTON_PRESS_MASK
                                  | GDK_KEY_PRESS_MASK
                                  | GDK_EXPOSURE_MASK
                                  /* | GDK_KEY_RELEASE_MASK */
                                  | GDK_FOCUS_CHANGE_MASK
                                  ); 
	   gtk_widget_show(drawing_area);

	   /*** Creation of scrollbars ***/
	   vscrl = gtk_vscrollbar_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 0, 0, 0, 0)));
	   gtk_widget_show (vscrl);
	   gtk_box_pack_start (GTK_BOX (hbox2), vscrl, FALSE, TRUE, 0);
	   /* gtk_signal_connect (GTK_OBJECT (vscrl), "value_changed",
	      GTK_SIGNAL_FUNC (FrameVScrolled), &frame);*/
	   hscrl = gtk_hscrollbar_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 0, 0, 0, 0)));
	   gtk_widget_show (hscrl);
	   gtk_box_pack_start (GTK_BOX (vbox1), hscrl, FALSE, TRUE, 0);
	   /* gtk_signal_connect (GTK_OBJECT (hscrl), "value_changed",
	      GTK_SIGNAL_FUNC (FrameHScrolled), NULL); */
	   /* status bar */
	   statusbar = gtk_statusbar_new ();
	   gtk_widget_show (statusbar);
	   gtk_box_pack_start (GTK_BOX (vbox1), statusbar, FALSE, TRUE, 0);

	   gtk_widget_show (Main_Wd);
	   
	   FrameTable[frame].WdScrollH = hscrl;
	   FrameTable[frame].WdScrollV = vscrl;
           FrRef[frame] = drawing_area->window;
#else /* _GTK */
	   /*** Creation of scrollbars ***/
	   n = 0;
	   XtSetArg (args[n], XmNbackground, Scroll_Color);
	   n++;
	   XtSetArg (args[n], XmNorientation, XmHORIZONTAL);
	   n++;
	   XtSetArg (args[n], XmNvalue, 0);
	   n++;
	   hscrl = XmCreateScrollBar (Main_Wd, "Scroll", args, n);
	   XtManageChild (hscrl);
	   /*XtAddCallback (hscrl, XmNvalueChangedCallback, (XtCallbackProc) FrameHScrolled, (XtPointer) frame); */
	   XtAddCallback (hscrl, XmNdragCallback, (XtCallbackProc) FrameHScrolled, (XtPointer) frame);
	   XtAddCallback (hscrl, XmNdecrementCallback, (XtCallbackProc) FrameHScrolled, (XtPointer) frame);
	   XtAddCallback (hscrl, XmNincrementCallback, (XtCallbackProc) FrameHScrolled, (XtPointer) frame);
	   XtAddCallback (hscrl, XmNpageDecrementCallback, (XtCallbackProc) FrameHScrolled, (XtPointer) frame);
	   XtAddCallback (hscrl, XmNpageIncrementCallback, (XtCallbackProc) FrameHScrolled, (XtPointer) frame);
	   XtAddCallback (hscrl, XmNtoTopCallback, (XtCallbackProc) FrameHScrolled, (XtPointer) frame);
	   XtAddCallback (hscrl, XmNtoBottomCallback, (XtCallbackProc) FrameHScrolled, (XtPointer) frame);
	   n = 0;
	   XtSetArg (args[n], XmNbackground, Scroll_Color);
	   n++;
	   XtSetArg (args[n], XmNorientation, XmVERTICAL);
	   n++;
	   XtSetArg (args[n], XmNvalue, 0);
	   n++;
	   vscrl = XmCreateScrollBar (Main_Wd, "Scroll", args, n);
	   XtManageChild (vscrl);
	   /*XtAddCallback (vscrl, XmNvalueChangedCallback, (XtCallbackProc) FrameVScrolled, (XtPointer) frame); */
	   XtAddCallback (vscrl, XmNdragCallback, (XtCallbackProc) FrameVScrolled, (XtPointer) frame);
	   XtAddCallback (vscrl, XmNdecrementCallback, (XtCallbackProc) FrameVScrolled, (XtPointer) frame);
	   XtAddCallback (vscrl, XmNincrementCallback, (XtCallbackProc) FrameVScrolled, (XtPointer) frame);
	   XtAddCallback (vscrl, XmNpageDecrementCallback, (XtCallbackProc) FrameVScrolled, (XtPointer) frame);
	   XtAddCallback (vscrl, XmNpageIncrementCallback, (XtCallbackProc) FrameVScrolled, (XtPointer) frame);
	   XtAddCallback (vscrl, XmNtoTopCallback, (XtCallbackProc) FrameVScrolled, (XtPointer) frame);
	   XtAddCallback (vscrl, XmNtoBottomCallback, (XtCallbackProc) FrameVScrolled, (XtPointer) frame);

	   /* Vertical row */
	   n = 0;
	   XtSetArg (args[n], XmNmarginWidth, 0);
	   n++;
	   XtSetArg (args[n], XmNmarginHeight, 0);
	   n++;
	   XtSetArg (args[n], XmNbackground, BgMenu_Color);
	   n++;
	   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT);
	   n++;
	   XtSetArg (args[n], XmNorientation, XmVERTICAL);
	   n++;
	   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM);
	   n++;
	   table1 = XmCreateRowColumn (Main_Wd, "", args, n);
	   XtManageChild (table1);
	   
	   /* Horizontal box for the button bar */
	   n = 0;
	   XtSetArg (args[n], XmNmarginWidth, 0);
	   n++;
	   XtSetArg (args[n], XmNmarginHeight, 0);
	   n++;
	   XtSetArg (args[n], XmNbackground, BgMenu_Color);
	   n++;
	   XtSetArg (args[n], XmNorientation, XmHORIZONTAL);
	   n++;
	   XtSetArg (args[n], XmNspacing, 0);
	   n++;
	   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM);
	   n++;
	   hbox1 = XmCreateRowColumn (table1, "", args, n);
	   
	   for (i = 1; i < MAX_BUTTON; i++)
	     FrameTable[frame].Button[i] = 0;
	   FrameTable[frame].Button[0] = hbox1;

	   /* Horizontal row for logo and text zones */
	   n = 0;
	   XtSetArg (args[n], XmNmarginWidth, 5);
	   n++;
	   XtSetArg (args[n], XmNmarginHeight, 0);
	   n++;
	   XtSetArg (args[n], XmNbackground, BgMenu_Color);
	   n++;
	   XtSetArg (args[n], XmNwidth, dx);
	   n++;
	   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM);
	   n++;
	   hbox1 = XmCreateForm (table1, "", args, n);
	   XtManageChild (hbox1);

	   /* logo */
	   if (image != 0)
	     {
	       n = 0;
	       XtSetArg (args[n], XmNmarginWidth, 0);
	       n++;
	       XtSetArg (args[n], XmNmarginHeight, 0);
	       n++;
	       XtSetArg (args[n], XmNbackground, BgMenu_Color);
	       n++;
	       XtSetArg (args[n], XmNlabelType, XmPIXMAP);
	       n++;
	       XtSetArg (args[n], XmNlabelPixmap, image);
	       n++;
	       XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM);
	       n++;
	       XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM);
	       n++;
	       w = XmCreateLabel (hbox1, "Logo", args, n);
	       XtManageChild (w);
	     }

	   /*** Creation of text zones  ***/
	   n = 0;
	   XtSetArg (args[n], XmNmarginWidth, 0);
	   n++;
	   XtSetArg (args[n], XmNmarginHeight, 0);
	   n++;
	   XtSetArg (args[n], XmNbackground, BgMenu_Color);
	   n++;
	   XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM);
	   n++;
	   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM);
	   n++;
	   XtSetArg (args[n], XmNkeyboardFocusPolicy, XmPOINTER);
	   n++;

	   if (image != 0)
	     {
	       XtSetArg (args[n], XmNleftOffset, 5);
	       n++;
	       XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET);
	       n++;
	       XtSetArg (args[n], XmNleftWidget, w);
	       n++;
	     }
	   else
	     {
	       XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM);
	       n++;
	     }

	   vbox1 = XmCreateForm (hbox1, "", args, n);
	   for (i = 1; i < MAX_TEXTZONE; i++)
	     FrameTable[frame].Text_Zone[i] = 0;
	   FrameTable[frame].Text_Zone[0] = vbox1;

	   /*** The document frame ***/
	   n = 0;
	   XtSetArg (args[n], XmNmarginWidth, 0);
	   n++;
	   XtSetArg (args[n], XmNmarginHeight, 0);
	   n++;
	   XtSetArg (args[n], XmNbackground, Scroll_Color);
	   n++;
	   XtSetArg (args[n], XmNkeyboardFocusPolicy, XmPOINTER);
	   n++;
	   XtSetArg (args[n], XmNtraversalOn, TRUE);
	   n++;

	   drawing_frame = XmCreateFrame (Main_Wd, "Frame", args, n);
	   XtManageChild (drawing_frame);

	   n = 0;
	   XtSetArg (args[n], XmNbackground, White_Color);
	   n++;
	   XtSetArg (args[n], XmNforeground, Black_Color);
	   n++;
	   XtSetArg (args[n], XmNfontList, DefaultFont);
	   n++;
	   XtSetArg (args[n], XmNmarginWidth, 0);
	   n++;
	   XtSetArg (args[n], XmNmarginHeight, 0);
	   n++;
	   XtSetArg (args[n], XmNkeyboardFocusPolicy, XmPOINTER);
	   n++;
	   drawing_area = XmCreateDrawingArea (drawing_frame, "", args, n);
	   XtManageChild (drawing_area);

	   /* Horizontal row for buttom messages */
	   n = 0;
	   XtSetArg (args[n], XmNmarginWidth, 0);
	   n++;
	   XtSetArg (args[n], XmNmarginHeight, 0);
	   n++;
	   XtSetArg (args[n], XmNbackground, BgMenu_Color);
	   n++;
	   XtSetArg (args[n], XmNorientation, XmHORIZONTAL);
	   n++;
	   XtSetArg (args[n], XmNkeyboardFocusPolicy, XmPOINTER);
	   n++;
	   hbox2 = XmCreateRowColumn (Main_Wd, "", args, n);
	   XtManageChild (hbox2);
	   n = 0;
	   XtSetArg (args[n], XmNbackground, BgMenu_Color);
	   n++;
	   XtSetArg (args[n], XmNforeground, FgMenu_Color);
	   n++;
	   XtSetArg (args[n], XmNheight, (Dimension) FontHeight (LargeFontDialogue));
	   n++;
	   XtSetArg (args[n], XmNfontList, DefaultFont);
	   n++;
	   title_string = XmStringCreateSimple (" ");
	   XtSetArg (args[n], XmNlabelString, title_string);
	   n++;
	   i = CharacterWidth (TEXT('M'), LargeFontDialogue) * 50;
	   XtSetArg (args[n], XmNwidth, (Dimension) i);
	   n++;
	   FrameTable[frame].WdStatus = XmCreateLabel (hbox2, "Thot_MSG", args, n);
	   XtManageChild (FrameTable[frame].WdStatus);
	   XmStringFree (title_string);
	   n = 0;
	   XtSetArg (args[n], XmNmessageWindow, hbox2);
	   n++;
	   XtSetValues (Main_Wd, args, n);

	   n = 0;
	   XtSetArg (args[n], XmNx, (Position) X + 4);
	   n++;
	   XtSetArg (args[n], XmNy, (Position) Y + 4);
	   n++;
	   XtSetValues (shell, args, n);
	   XtPopup (shell, XtGrabNonexclusive);
	   
	   XmMainWindowSetAreas (Main_Wd, menu_bar, table1, hscrl, vscrl, drawing_frame);
	   XtAddCallback (drawing_area, XmNinputCallback, (XtCallbackProc) DrawingInput, (XtPointer) frame);
	   XtAddCallback (drawing_area, XmNresizeCallback, (XtCallbackProc) FrameResized, (XtPointer) frame);
	   FrameTable[frame].WdScrollH = hscrl;
	   FrameTable[frame].WdScrollV = vscrl;
	   FrameTable[frame].WdFrame = drawing_area;
	   FrRef[frame] = XtWindowOfObject (drawing_area);
#endif /* _GTK */
	   /* approximate the real size of the drawing area */
	   FrameTable[frame].FrWidth  = (int) dx - 20;
	   FrameTable[frame].FrScrollWidth  = (int) dx - 20;
	   FrameTable[frame].FrHeight = (int) dy - 20;
           FrameTable[frame].WdFrame =  drawing_area;
#else  /* _WINDOWS */
	   /*** scrollbars ***/
	   hscrl = CreateWindow (TEXT("scrollbar"), NULL, WS_CHILD | WS_VISIBLE | SBS_HORZ,
				 0, 0, 0, 0, Main_Wd, (HMENU) frame, hInstance, NULL);
	   SetScrollRange (hscrl, SB_CTL, 0, 100, FALSE);
	   SetScrollPos (hscrl, SB_CTL, 0, FALSE);

	   vscrl = CreateWindow (TEXT("scrollbar"), NULL, WS_CHILD | WS_VISIBLE | SBS_VERT,
				 0, 0, 0, 0, Main_Wd, (HMENU) (frame + 1), hInstance, NULL);
	   SetScrollRange (vscrl, SB_CTL, 0, 100, FALSE);
	   SetScrollPos (vscrl, SB_CTL, 0, FALSE);

	   FrameTable[frame].FrWidth  = (int) width;
	   FrameTable[frame].FrScrollWidth  = (int) width;
	   FrameTable[frame].FrHeight = (int) height;
	   FrameTable[frame].WdScrollH = hscrl;
	   FrameTable[frame].WdScrollV = vscrl;
	   FrameTable[frame].WdFrame = (ThotMenu) w;
#endif /* _WINDOWS */
	   FrameTable[frame].FrScrollOrg = 0;

	   /* get registry default values for zoom and visibility */
	   zoomStr = TtaGetEnvString ("ZOOM");
	   if (zoomStr == NULL)
	     zoomVal = 0;
	   else
	     {
	       zoomVal = wctoi (zoomStr);
	       if (zoomVal > 10 || zoomVal < -10)
		 zoomVal = 0;
	     }
	   visiStr = TtaGetEnvString ("VISIBILITY");
	   if (visiStr == NULL)
	     visiVal = 5;
	   else
	     {
	       visiVal = wctoi (visiStr);
	       if (visiVal < 0 || visiVal > 10)
		 visiVal = 5;
	     }
	   /* Initialise la visibilite et le zoom de la fenetre */
	   InitializeFrameParams (frame, visiVal, zoomVal);
	   /* Initialise la couleur de fond */
	   BackgroundColor[frame] = DefaultBColor;
	 }
       else
	 ChangeFrameTitle (frame, name);

       /* Window volume in characters */
       *volume = GetCharsCapacity (FrameTable[frame].FrWidth * FrameTable[frame].FrHeight);
       FrameTable[frame].FrDoc = doc;
       FrameTable[frame].FrView = view;

#ifdef _WINDOWS
       SetMenu (Main_Wd, menu_bar);
       ShowWindow (Main_Wd, SW_SHOWNORMAL);
       UpdateWindow (Main_Wd);
       InitCommonControls ();
#endif /* _WINDOWS */
     }
   return (frame);
}

/*----------------------------------------------------------------------
   Si l'entree existe :                                             
   Ferme la fenetre, detruit le fichier et libere l'entree.      
   Libere toutes les boites allouees a la fenetre.                   
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                DestroyFrame (int frame)
#else  /* __STDC__ */
void                DestroyFrame (frame)
int                 frame;

#endif /* __STDC__ */
{
#ifndef _GTK
   ThotWidget          w;
   int                 action;
   int                 ref, i;
   int                 item;
   Menu_Ctl           *ptrmenu;
   Item_Ctl           *ptr;
#ifdef _WINDOWS
   int                 txtZoneIndex;
#endif /* _WINDOWS */

   if (ThotLocalActions[T_stopinsert] != NULL)
     (*ThotLocalActions[T_stopinsert]) ();
   w = FrameTable[frame].WdFrame;
   if (w != 0)
     {
	/* Destruction des menus attaches a la fenetre */
	ptrmenu = FrameTable[frame].FrMenus;
	i = 0;
	ref = frame + MAX_LocalMenu;	/* reference du menu construit */
	while (ptrmenu != NULL)
	  {
	     /* saute les menus qui ne concernent pas cette vue */
	     if (ptrmenu->MenuView == 0 || ptrmenu->MenuView == FrameTable[frame].FrView)
	       {
		  FrameTable[frame].WdMenus[i] = 0;
		  TtaDestroyDialogue (ref);
		  item = 0;
		  ptr = ptrmenu->ItemsList;
		  while (item < ptrmenu->ItemsNb)
		    {
		       action = ptr[item].ItemAction;
		       if (action != -1
			   && (ptr[item].ItemType == TEXT('B') || ptr[item].ItemType == TEXT('T')))
			  /* Desactive l'action correspondante pour cette fenetre */
			  MenuActionList[action].ActionActive[frame] = FALSE;
		       item++;
		    }
	       }
	     ptrmenu = ptrmenu->NextMenu;
	     ref += MAX_ITEM;
	     i++;
	  }


	/* Annule eventuellement les formulaires attaches a la fenetre */
	if (ThotLocalActions[T_rszoom] != NULL)
	   (*ThotLocalActions[T_rszoom]) (frame);
	if (ThotLocalActions[T_rsvisibility] != NULL)
	   (*ThotLocalActions[T_rsvisibility]) (frame);
	if (ThotLocalActions[T_rscorrector] != NULL)
	   (*ThotLocalActions[T_rscorrector]) (frame);
	if (ThotLocalActions[T_rsindex] != NULL)
	   (*ThotLocalActions[T_rsindex]) (frame);

#ifndef _WINDOWS
        XFlushOutput (0);
        /* Detache les procedures de callback */
        XtRemoveCallback (XtParent (XtParent (w)), XmNdestroyCallback, (XtCallbackProc) FrameKilled, (XtPointer) frame);

        XDestroyWindow (TtDisplay, XtWindowOfObject (XtParent (XtParent (XtParent (w)))));

        for (i = 0; i < MAX_BUTTON; i++)
	  FrameTable[frame].Button[i] = 0;

#else  /* _WINDOWS */
        for (txtZoneIndex = 0; txtZoneIndex < MAX_TEXTZONE; txtZoneIndex++)
	  FrameTable[frame].Text_Zone[txtZoneIndex] = 0;
        if (hAccel [frame])
	  {
	    DestroyAcceleratorTable (hAccel [frame]);
	    hAccel [frame] = NULL;
	  }
    /* PostMessage(FrMainRef[frame], WM_DESTROY, 0, 0);      */
	CleanFrameCatList (frame);

        for (i = 0; i < MAX_BUTTON; i++)
	  {
            TtaFreeMemory (FrameTable[frame].Button[i]);
            FrameTable[frame].Button[i] = 0;
	    FrameTable[frame].ButtonId[i] = -1;
	  }

#endif /* _WINDOWS */
	FrRef[frame] = 0;
	FrameTable[frame].WdFrame = 0;
	FrameTable[frame].FrDoc = 0;
	/* Elimine les evenements ButtonRelease, DestroyNotify, FocusOut */

	ClearConcreteImage (frame);
	ThotFreeFont (frame);	/* On libere les polices de caracteres utilisees */
     }
#endif /* _GTK */		
#ifdef _WINDOWS
   if (FrMainRef [frame]) {
      DestroyWindow (FrMainRef[frame]);
   }
#endif
}


/*----------------------------------------------------------------------
   GetMenu_Ctl donne le contexte du menu associe' a` la fenetree^tre. 
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static Menu_Ctl    *GetMenu_Ctl (int frame, int menu)
#else  /* __STDC__ */
static Menu_Ctl    *GetMenu_Ctl (frame, menu)
int                 frame;
int                 menu;

#endif /* __STDC__ */
{
   int                 i;
   Menu_Ctl           *ptrmenu;

   ptrmenu = FrameTable[frame].FrMenus;
   i = 0;
   while (i != menu && ptrmenu != NULL)
     {
	ptrmenu = ptrmenu->NextMenu;
	i++;
     }
   return (ptrmenu);
}


/*----------------------------------------------------------------------
  FindMenu returns the menu index and its context if this menu is
  displayed in this specific frame or -1.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 FindMenu (int frame, int menuID, Menu_Ctl ** ctxmenu)
#else  /* __STDC__ */
int                 FindMenu (frame, menuID, ctxmenu)
int                 frame;
int                 menuID;
Menu_Ctl          **ctxmenu;

#endif /* __STDC__ */
{
   Menu_Ctl           *ptrmenu;
   int                 m;

   /* Look for the menu */
   m = 1;			/* menu index */
   /* look for that menu in the menu list */
   ptrmenu = FrameTable[frame].FrMenus;
   while (ptrmenu != NULL && menuID != ptrmenu->MenuID)
     {
	m++;
	ptrmenu = ptrmenu->NextMenu;
     }

   *ctxmenu = ptrmenu;
   if (ptrmenu == NULL)
     /* menu not found */
     return (-1);
   else if (ptrmenu->MenuView != 0 && ptrmenu->MenuView != FrameTable[frame].FrView)
     /* menu found but that frame is not concerned */
     return (-1);
   else
     /* ok */
     return (m);
}


/*----------------------------------------------------------------------
  FindItemMenu returns all information concerning that dialogue entry
  in this specific frame:
  - menu index or -1
  - submenu index or 0
  - item index or 0
  - action index or -1
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         FindItemMenu (int frame, int menuID, int itemID, int *menu, int *submenu, int *item, int *action)
#else  /* __STDC__ */
static void         FindItemMenu (frame, menuID, itemID, menu, submenu, item, action)
int                 frame;
int                 menuID;
int                 itemID;
int                *menu;
int                *submenu;
int                *item;
int                *action;
#endif /* __STDC__ */
{
   Menu_Ctl           *ptrmenu, *ptrsmenu;
   Item_Ctl           *ptr;
   int                 i, j, max;
   int                 m, sm;
   ThotBool            found;

   j = 0;
   i = 0;
   sm = 0;
   /* look for that menu in the menu list */
   m = FindMenu (frame, menuID, &ptrmenu);
   found = (m != -1);
   if (found)
     {
       /* search that item in the item list or in submenus */
       ptr = ptrmenu->ItemsList;
       found = FALSE;
       max = ptrmenu->ItemsNb;
       ptrsmenu = NULL;
       while (ptrmenu != NULL && !found)
	 {
	   while (i < max && !found)
	     {
	       j = ptr[i].ItemAction;
	       if (j == -1)
		 i++;	/* separator */
	       else if (ptr[i].ItemID == itemID)
		 {
		   /* the entry is found */
		   found = TRUE;
		   if (ptr[i].ItemType == TEXT('M'))
		     /* it doesn't match an action */
		     j = -1;
		 }
	       else if (ptr[i].ItemType == TEXT('M'))
		 {
		   /* search in that submenu */
		   sm = i + 1;
		   ptrsmenu = ptr[i].SubMenu;
		   i = 0;
		   ptr = ptrsmenu->ItemsList;
		   max = ptrsmenu->ItemsNb;
		 }
	       else
		 i++;	/* it's not that one */
	     }
	   
	   /* do we close the search in a submenu? */
	   if (!found && ptrsmenu != NULL)
	     {
	       /* continue the search in the menu */
	       i = sm;
	       sm = 0;
	       ptrsmenu = NULL;
	       ptr = ptrmenu->ItemsList;
	       max = ptrmenu->ItemsNb;
	     }
	   else
	     /* we close the menu search and this itemID doesn't exist */
	     ptrmenu = NULL;
	 }
     }

   /* do we sucess? */
   if (found)
     {
       /* yes */
       *menu = m;
       *submenu = sm;
       *item = i;
       *action = j;
     }
   else
     {
       /* no */
       *menu = -1;
       *submenu = 0;
       *item = 0;
       *action = -1;
     }
}

/*----------------------------------------------------------------------
  SwitchUndo enables (on=TRUE) or disables (on=FALSE) the Undo
  entry in all document frames.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void         SwitchUndo (PtrDocument pDoc, ThotBool on)
#else  /* __STDC__ */
void         SwitchUndo (pDoc, on)
PtrDocument  pDoc;
ThotBool     on;
#endif /* __STDC__ */
{
#  ifndef _GTK
#  ifndef _WINDOWS 
   char              fontname[100];
   char              text[20];
#  else /* _WINDOWS */
   HMENU             hMenu;
#  endif /* _WINDOWS */
   int               view, assoc, frame;
   int               ref, item;

   if (pDoc == NULL)
      return;
   for (view = 0; view < MAX_VIEW_DOC; view++) {
       if (pDoc->DocView[view].DvPSchemaView > 0) {
          frame = pDoc->DocViewFrame[view];
          if (frame != 0 && FrameTable[frame].MenuUndo != -1) {
             ref = FrameTable[frame].MenuUndo;
             item = FrameTable[frame].EntryUndo;
#            ifdef _WINDOWS
             hMenu = WIN_GetMenu (frame);
             if (on)
                EnableMenuItem (hMenu, ref + item, MF_ENABLED);
             else
                 EnableMenuItem (hMenu, ref + item, MFS_GRAYED);
#            else  /* !_WINDOWS */
             if (on)
                TtaRedrawMenuEntry (ref, item, NULL, -1, 1);
             else if (TtWDepth > 1)
                  TtaRedrawMenuEntry (ref, item, NULL, InactiveB_Color, 0);
	         else {
                  FontIdentifier ('L', 'T', 2, 11, UnPoint, text, fontname);
                  TtaRedrawMenuEntry (ref, item, fontname, -1, 0);
			 }  
#            endif /* _WINDOWS */
		  }  
	   }  
   } 
   for (assoc = 0; assoc < MAX_ASSOC_DOC; assoc++) {
       frame = pDoc->DocAssocFrame[assoc];
       if (frame != 0 && FrameTable[frame].MenuUndo != -1) {
          ref = FrameTable[frame].MenuUndo;
          item = FrameTable[frame].EntryUndo;
#         ifdef _WINDOWS
          hMenu = WIN_GetMenu (frame);
          if (on)
             EnableMenuItem (hMenu, ref + item, MF_ENABLED);
          else
              EnableMenuItem (hMenu, ref + item, MFS_GRAYED);
#         else  /* !_WINDOWS */
          if (on)
             TtaRedrawMenuEntry (ref, item, NULL, -1, 1);
          else if (TtWDepth > 1)
               TtaRedrawMenuEntry (ref, item, NULL, InactiveB_Color, 0);
          else {
               FontIdentifier ('L', 'T', 2, 11, UnPoint, text, fontname);
               TtaRedrawMenuEntry (ref, item, fontname, -1, 0);
		  }
#         endif /* _WINDOWS */
	   } 
   } 
#  endif /* _GTK */
} 

/*----------------------------------------------------------------------
  SwitchRedo enables (on=TRUE) or disables (on=FALSE) the Redo
  entry in all document frames.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void         SwitchRedo (PtrDocument pDoc, ThotBool on)
#else  /* __STDC__ */
void         SwitchRedo (pDoc, on)
PtrDocument  pDoc;
ThotBool     on;
#endif /* __STDC__ */
{
#ifndef _GTK
#ifndef _WINDOWS 
  char                fontname[100];
  char                text[20];
#else /* _WINDOWS */
  HMENU               hMenu;
#endif /* _WINDOWS */
  int                 view, assoc, frame;
  int                 ref, item;

  if (pDoc == NULL)
    return;
  for (view = 0; view < MAX_VIEW_DOC; view++)
    {
      if (pDoc->DocView[view].DvPSchemaView > 0)
	{
	  frame = pDoc->DocViewFrame[view];
	  if (frame != 0 && FrameTable[frame].MenuRedo != -1)
	    {
	      ref = FrameTable[frame].MenuRedo;
	      item = FrameTable[frame].EntryRedo;
#ifdef _WINDOWS
	      hMenu = WIN_GetMenu (frame);
	      if (on)
		EnableMenuItem (hMenu, ref + item, MF_ENABLED);
	      else
		EnableMenuItem (hMenu, ref + item, MFS_GRAYED);
#else  /* !_WINDOWS */
	      if (on)
		TtaRedrawMenuEntry (ref, item, NULL, -1, 1);
	      else if (TtWDepth > 1)
		TtaRedrawMenuEntry (ref, item, NULL, InactiveB_Color, 0);
	      else
		{
		  FontIdentifier ('L', 'T', 2, 11, UnPoint, text, fontname);
		  TtaRedrawMenuEntry (ref, item, fontname, -1, 0);
		}
#endif /* _WINDOWS */
	    }
	}
    }
  for (assoc = 0; assoc < MAX_ASSOC_DOC; assoc++)
    {
      frame = pDoc->DocAssocFrame[assoc];
      if (frame != 0 && FrameTable[frame].MenuRedo != -1)
	{
	  ref = FrameTable[frame].MenuRedo;
	  item = FrameTable[frame].EntryRedo;
#ifdef _WINDOWS
	  hMenu = WIN_GetMenu (frame);
	  if (on)
	    EnableMenuItem (hMenu, ref + item, MF_ENABLED);
	  else
	    EnableMenuItem (hMenu, ref + item, MFS_GRAYED);
#else  /* !_WINDOWS */
	  if (on)
	    TtaRedrawMenuEntry (ref, item, NULL, -1, 1);
	  else if (TtWDepth > 1)
	    TtaRedrawMenuEntry (ref, item, NULL, InactiveB_Color, 0);
	  else
	    {
	      FontIdentifier ('L', 'T', 2, 11, UnPoint, text, fontname);
	      TtaRedrawMenuEntry (ref, item, fontname, -1, 0);
	    }
#endif /* _WINDOWS */
	}
    }
#endif /* _GTK */
}

/*----------------------------------------------------------------------
  SwitchPaste enables (on=TRUE) or disables (on=FALSE) the Paste
  entry in all frames.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void         SwitchPaste (PtrDocument pDoc, ThotBool on)
#else  /* __STDC__ */
void         SwitchPaste (pDoc, on)
PtrDocument  pDoc;
ThotBool     on;
#endif /* __STDC__ */
{
#ifndef _GTK 
#ifndef _WINDOWS 
  char                fontname[100];
  char                text[20];
#else /* _WINDOWS */
  HMENU               hMenu;
#endif /* _WINDOWS */
  int                 frame;
  int                 ref, item;

  frame = 1;
  while (frame <= MAX_FRAME)
    {
      if (FrameTable[frame].WdFrame != 0 && FrameTable[frame].FrDoc != 0)
	{
	  if (pDoc == NULL ||
	      pDoc == LoadedDocument[FrameTable[frame].FrDoc - 1])
	    {
	      ref = FrameTable[frame].MenuPaste;
	      item = FrameTable[frame].EntryPaste;
	      if (ref != -1)
		{
#ifdef _WINDOWS
		  hMenu = WIN_GetMenu (frame);
		  if (!LoadedDocument[FrameTable[frame].FrDoc - 1]->DocReadOnly)
		    /* active the paste command as soon as the document is editable */
		    EnableMenuItem (hMenu, ref + item, MF_ENABLED);
		  else if (!on)
		    EnableMenuItem (hMenu, ref + item, MFS_GRAYED);
#else  /* !_WINDOWS */
		  if (on && !LoadedDocument[FrameTable[frame].FrDoc - 1]->DocReadOnly)
		    TtaRedrawMenuEntry (ref, item, NULL, -1, 1);
		  else if (!on)
		    {
		      /* active the paste command */
		      if (TtWDepth > 1)
			TtaRedrawMenuEntry (ref, item, NULL, InactiveB_Color, 0);
		      else
			{
			  FontIdentifier ('L', 'T', 2, 11, UnPoint, text, fontname);
			  TtaRedrawMenuEntry (ref, item, fontname, -1, 0);
			}
		    }
#endif /* _WINDOWS */
		}
	    }
	}
      frame++;
    }
#endif /* _GTK */
}

/*----------------------------------------------------------------------
   TtaSetMenuOff desactive le menu (1 a n) de la vue du document ou   
   de la fenetre principale (document = 0, view = 0).                 
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtaSetMenuOff (Document document, View view, int menuID)
#else  /* __STDC__ */
void                TtaSetMenuOff (document, view, menuID)
Document            document;
View                view;
int                 menuID;

#endif /* __STDC__ */
{
#ifndef _GTK
   ThotMenu            w;
   int                 menu;
   int                 frame;
   int                 ref;
   Menu_Ctl*           ptrmenu;
#  ifndef _WINDOWS
   int                 n; 
#  endif /* !_WINDOWS */

#ifndef _WINDOWS
   XmFontList          font;
   Arg                 args[MAX_ARGS];

#endif

   if (document == 0 && view == 0)
     frame = 0;
   else
     frame = GetWindowNumber (document, view);

   /* Check parameters */
   if (frame > MAX_FRAME)
     return;
   else if ((FrameTable[frame].WdFrame) == 0)
     return;

   menu = FindMenu (frame, menuID, &ptrmenu);
   if (menu != -1)
     {
       menu--;
       if (FrameTable[frame].EnabledMenus[menu])
	 {
	   /* Get the button widget */
	   w = FrameTable[frame].WdMenus[menu];
	   if (w != 0)
	     {
	       FrameTable[frame].EnabledMenus[menu] = FALSE;
	       ref = (menu * MAX_ITEM) + frame + MAX_LocalMenu;
	       /* Disable */
#ifdef _WINDOWS
	       WIN_TtaSetPulldownOff (ref, w, TtaGetViewFrame (document, view));
#else  /* !_WINDOWS */
	       TtaSetPulldownOff (ref, w);
#endif /* _WINDOWS */
	       
#ifndef _WINDOWS
	       /* Set the button inactive */
	       if (TtWDepth > 1)
		 {
		   /* Change the color */
		   n = 0;
		   XtSetArg (args[n], XmNforeground, InactiveB_Color);
		   n++;
		   XtSetValues (w, args, n);
		   XtManageChild (w);
		 }
	       else
		 {
		   /* Change the font */
		   font = XmFontListCreate ((XFontStruct *) IFontDialogue, XmSTRING_DEFAULT_CHARSET);
		   n = 0;
		   XtSetArg (args[n], XmNfontList, font);
		   n++;
		   XtSetValues (w, args, n);
		   XtManageChild (w);
		   XmFontListFree (font);
		 }
#endif /* _WINDOWS */
	     }
	 }
     }
#endif /* _GTK */
}


/*----------------------------------------------------------------------
   TtaSetMenuOn reactive le menu (1 a n) de la vue du document ou     
   de la fenetre principale (document = 0, view = 0).                 
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtaSetMenuOn (Document document, View view, int menuID)
#else  /* __STDC__ */
void                TtaSetMenuOn (document, view, menuID)
Document            document;
View                view;
int                 menuID;

#endif /* __STDC__ */
{
#ifndef _GTK
   ThotMenu            w;
   int                 menu;
   int                 frame;
   int                 ref;
   Menu_Ctl*           ptrmenu;

#ifndef _WINDOWS
   Arg                 args[MAX_ARGS];

#endif

   if (document == 0 && view == 0)
     frame = 0;
   else
     frame = GetWindowNumber (document, view);

   /* Check parameters */
   if (frame > MAX_FRAME)
     return;
   else if ((FrameTable[frame].WdFrame) == 0)
     return;

   menu = FindMenu (frame, menuID, &ptrmenu);
   if (menu != -1) {
       menu--;
#      ifndef _WINDOWS
       if (!FrameTable[frame].EnabledMenus[menu]) {
#      endif /* !_WINDOWS */
          /* Get the button widget */
          w = FrameTable[frame].WdMenus[menu];
          if (w != 0) {
             FrameTable[frame].EnabledMenus[menu] = TRUE;
             ref = (menu * MAX_ITEM) + frame + MAX_LocalMenu;
             /* Enaable */
#            ifdef _WINDOWS
             WIN_TtaSetPulldownOn (ref, w, TtaGetViewFrame (document, view));
#            else /* !_WINDOWS */
             TtaSetPulldownOn (ref, w);
#            endif /* _WINDOWS */

#            ifndef _WINDOWS
             /* Set the button active */
             if (TtWDepth > 1) {
                /* Change the color */
                XtSetArg (args[0], XmNforeground, FgMenu_Color);
                XtSetValues (w, args, 1);
                XtManageChild (w);
			 } else {
                    /* Change the font */
                    XtSetArg (args[0], XmNfontList, DefaultFont);
                    XtSetValues (w, args, 1);
                    XtManageChild (w);
			 }
#            endif
#         ifndef _WINDOWS
		  }  
#         endif /* !_WINDOWS */
	   } 
   }  
#endif /* _GTK */
}


/*----------------------------------------------------------------------
   TtaSetToggleItem positionne l'item du menu de la vue du document   
   ou de la fenetre principale (document = 0, view = 0).   
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtaSetToggleItem (Document document, View view, int menuID, int itemID, ThotBool on)
#else  /* __STDC__ */
void                TtaSetToggleItem (document, view, menuID, itemID, on)
Document            document;
View                view;
int                 menuID;
int                 itemID;
ThotBool            on;
#endif /* __STDC__ */
{
   int                 frame;
   int                 ref;
   int                 menu, submenu;
   int                 item, action;

   /* Check parameters */
   if (menuID == 0 || itemID == 0)
      return;
   if (document == 0 && view == 0)
      frame = 0;
   else
      frame = GetWindowNumber (document, view);

   if (frame > MAX_FRAME)
      return;
   else if ((FrameTable[frame].WdFrame) == 0)
      return;


   /* Search the menu, submenu and item */
   FindItemMenu (frame, menuID, itemID, &menu, &submenu, &item, &action);
   if (menu >= 0 && item >= 0)
     {
	/* entry found */
	ref = ((menu - 1) * MAX_ITEM) + frame + MAX_LocalMenu;
	if (submenu != 0)
	   ref += submenu * MAX_MENU * MAX_ITEM;
	/* enable the entry */
#ifdef _WINDOWS
	WIN_TtaSetToggleMenu (ref, item, on, FrMainRef[frame]);
#else  /* _WINDOWS */
	TtaSetToggleMenu (ref, item, on);
#endif /* _WINDOWS */
     }
}


/*----------------------------------------------------------------------
   TtaSetItemOff desactive l'item actionName de la vue du document  
   ou de la fenetre principale (document = 0, view = 0).   
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtaSetItemOff (Document document, View view, int menuID, int itemID)
#else  /* __STDC__ */
void                TtaSetItemOff (document, view, menuID, itemID)
Document            document;
View                view;
int                 menuID;
int                 itemID;
#endif /* __STDC__ */
{
   int                 frame;
   int                 ref;
   int                 menu, submenu;
   int                 item;
   int                 action;
#ifndef _WINDOWS 
   char                fontname[100];
   char                text[20];
#else /* _WINDOWS */
   HMENU               hMenu;
#endif /* _WINDOWS */

   /* Check parameters */
   if (document == 0 && view == 0)
     frame = 0;
   else
     frame = GetWindowNumber (document, view);

   if (frame > MAX_FRAME)
     return;
   else if ((FrameTable[frame].WdFrame) == 0)
     return;

   /* Search the menu, submenu and item */
   FindItemMenu (frame, menuID, itemID, &menu, &submenu, &item, &action);
   if (action > 0 && MenuActionList[action].ActionActive[frame])
     /* the entry is found and is active */
     MenuActionList[action].ActionActive[frame] = FALSE;
   if (menu > 0)
     {
       ref = ((menu - 1) * MAX_ITEM) + frame + MAX_LocalMenu;
       if (submenu != 0)
	 ref += submenu * MAX_MENU * MAX_ITEM;
       /* enable the entry */
#ifdef _WINDOWS
       hMenu = GetMenu (TtaGetViewFrame (document, view));
       EnableMenuItem (hMenu, ref + item, MFS_GRAYED);
#else  /* !_WINDOWS */
       if (TtWDepth > 1)
	 TtaRedrawMenuEntry (ref, item, NULL, InactiveB_Color, 0);
       else
	 {
	   FontIdentifier ('L', 'T', 2, 11, UnPoint, text, fontname);
	   TtaRedrawMenuEntry (ref, item, fontname, -1, 0);
	 }
#endif /* _WINDOWS */
     }
}


/*----------------------------------------------------------------------
   TtaSetItemOn active l'item actionName de la vue du document      
   ou de la fenetre principale (document = 0, view = 0).   
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtaSetItemOn (Document document, View view, int menuID, int itemID)
#else  /* __STDC__ */
void                TtaSetItemOn (document, view, menuID, itemID)
Document            document;
View                view;
int                 menuID;
int                 itemID;

#endif /* __STDC__ */
{
   PtrDocument         pDoc;
   int                 frame;
   int                 ref;
   int                 menu, submenu;
   int                 item;
   int                 action;
#  ifdef _WINDOWS
   HMENU               hMenu;
#  endif /* _WINDOWS */

   /* Si les parametres sont invalides */
   if (document == 0 && view == 0)
      frame = 0;
   else
      frame = GetWindowNumber (document, view);
   if (frame > MAX_FRAME)
      return;
   else if ((FrameTable[frame].WdFrame) == 0)
      return;
   /* Recherche les bons indices de menu, sous-menu et item */
   FindItemMenu (frame, menuID, itemID, &menu, &submenu, &item, &action);
   if (action > 0 && !MenuActionList[action].ActionActive[frame])
     /* the entry is found and is not active */
     MenuActionList[action].ActionActive[frame] = TRUE;
   if (menu > 0)
     {
       /* enable the menu entry */
       ref = ((menu - 1) * MAX_ITEM) + frame + MAX_LocalMenu;
       if (submenu != 0)
	 ref += submenu * MAX_MENU * MAX_ITEM;
       
       pDoc = LoadedDocument [document - 1];
       if (ref == FrameTable[frame].MenuRedo &&
	   item == FrameTable[frame].EntryRedo &&
	   (pDoc->DocReadOnly || pDoc->DocNbUndone == 0))
	 return;
       else if (ref == FrameTable[frame].MenuUndo &&
		item == FrameTable[frame].EntryUndo &&
		(pDoc->DocReadOnly || pDoc->DocNbEditsInHistory == 0))
	 return;
       else if (ref == FrameTable[frame].MenuPaste &&
		item == FrameTable[frame].EntryPaste &&
		(pDoc->DocReadOnly ||
		 (FirstSavedElement == NULL && ClipboardThot.BuLength == 0)))
	 return;
#ifdef _WINDOWS
       hMenu = GetMenu (TtaGetViewFrame (document, view));
       EnableMenuItem (hMenu, ref + item, MF_ENABLED);
#else  /* !_WINDOWS */
       TtaRedrawMenuEntry (ref, item, NULL, -1, 1);
#endif /* _WINDOWS */
     }
}


/*----------------------------------------------------------------------
   TtaSetCallback

   Specifies the procedure that is called when the user activates a set of forms
   and/or menus created by the application.
   The parameter set gives the number of forms and/or menus created by the 
   application managed by this porcedure.
   This function must be called before processing any event, only if the
   application uses the Dialogue tool kit for generating specific forms or menus.
   This function replaces the DefineCallback function in the Dialogue tool kit.
   This procedure is called with three parameters: the menu or form reference,
   data type, and data value.

   void callbakProcedure(reference, datatype, data)
   int reference;
   int datatype;
   char *data; 

   Parameter:
   callbakProcedure: the application callback procedure.
   set: the number of forms and/or menus managed.
   Return:
   reference of the first form or menu.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 TtaSetCallback (void (*callbakProcedure) (), int set)
#else  /* __STDC__ */
int                 TtaSetCallback (callbakProcedure)
void                (*callbakProcedure) ();
int                 set;

#endif /* __STDC__ */
{
   PtrCallbackCTX      ctxCallback;

   UserErrorCode = 0;
   if (FirstCallbackAPI == NULL)
     {
	/* le premier bloc de callback */
	FirstCallbackAPI = (PtrCallbackCTX) TtaGetMemory (sizeof (CallbackCTX));
	ctxCallback = FirstCallbackAPI;
     }
   else
     {
	ctxCallback = FirstCallbackAPI;
	while (ctxCallback->callbackNext != NULL)
	   ctxCallback = ctxCallback->callbackNext;
	ctxCallback->callbackNext = (PtrCallbackCTX) TtaGetMemory (sizeof (CallbackCTX));
	ctxCallback = ctxCallback->callbackNext;
     }

   ctxCallback->callbackProc = callbakProcedure;
   ctxCallback->callbackSet = set;
   ctxCallback->callbackNext = NULL;
   return (TtaGetReferencesBase (set));
}				/*TtaSetCallback */


/*----------------------------------------------------------------------
   ThotCallback ge`re tous les retours du dialogue de Thot.        
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                ThotCallback (int ref, int typedata, STRING data)

#else  /* __STDC__ */
void                ThotCallback (ref, typedata, data)
int                 ref;
int                 typedata;
STRING              data;

#endif /* __STDC__ */

{
  int                 frame, item;
  int                 menu, base;
  int                 menuThot;
  Menu_Ctl           *ptrmenu;
  int                 action, i, j;
  Document            document;
  View                view;
  PtrCallbackCTX      ctxCallback;

  /* Termine l'insertion courante s'il y en a une */
#ifdef _WINDOWS
  menu_item = ref + (int) data;
#endif /* _WINDOWS */
  CloseInsertion ();

  if (ref >= MAX_ThotMenu)
    {
      if (FirstCallbackAPI == NULL)
	return;		/* pas de callback definis */
      else
	{
	  /* recherc he le bon callback */
	  ctxCallback = FirstCallbackAPI;
	  base = MAX_ThotMenu;
	  while (ref >= base + ctxCallback->callbackSet)
	    {
	      if (ctxCallback->callbackNext == NULL)
		return;
	      else
		{
		  base = base + ctxCallback->callbackSet;
		  ctxCallback = ctxCallback->callbackNext;
		}
	    }
	  (*ctxCallback->callbackProc) (ref, typedata, data);
	}
    }
  else if (ref < MAX_LocalMenu)
    /*** Action interne et optionnelle de l''eur ***/
    switch (ref)
      {
      case NumMenuInsert:
	(*ThotLocalActions[T_rcinsertpaste]) (TRUE, FALSE, (int) data + 1);
	break;
      case NumMenuPaste:
	(*ThotLocalActions[T_rcinsertpaste]) (FALSE, TRUE, (int) data + 1);
	break;
      case NumMenuInclude:
	(*ThotLocalActions[T_rcinsertpaste]) (FALSE, FALSE, (int) data + 1);
	break;
      case NumMenuElChoice:
	(*ThotLocalActions[T_rchoice]) ((int) data + 1, NULL);
	break;
      case NumSelectNatureName:
	(*ThotLocalActions[T_rchoice]) (0, data);
	break;
      case NumMenuCreateReferenceElem:
	/* Pop-up menu 'Creation element reference'' */
	(*ThotLocalActions[T_raskfornew]) ((int) data);
	break;
      case NumMenuChangeType:
	/* Pop-up menu 'ChangeType' */
	(*ThotLocalActions[T_rchangetype]) ((int)data);
	break;
      case NumMenuSurround:
	/* Pop-up menu 'Surround' */
	(*ThotLocalActions[T_rsurround]) ((int)data);
	break;
	
      case NumMenuAttrRequired:
      case NumMenuAttrNumNeeded:
      case NumMenuAttrTextNeeded:
      case NumMenuAttrEnumNeeded:
	(*ThotLocalActions[T_rattrreq]) (ref, (int) data, data);
	break;
      case NumMenuAttr:
      case NumMenuAttrNumber:
      case NumMenuAttrText:
      case NumMenuAttrEnum:
	(*ThotLocalActions[T_rattrval]) (ref, (int) data, data);
	break;
	
      case NumSelectLanguage:
	(*ThotLocalActions[T_rattrlang]) (ref, 0, data);
	break;
      case NumFormLanguage:
      case NumMenuAlphaLanguage:
	(*ThotLocalActions[T_rattrlang]) (ref, (int) data, NULL);
	break;
	
      case NumFormCreateDoc:
      case NumZoneDocNameToCreate:
      case NumZoneDocDirToCreate:
      case NumSelDocClassToCreate:
	(*ThotLocalActions[T_createdoc]) (ref, typedata, data);
	break;
      case NumFormConfirm:
	(*ThotLocalActions[T_confirmcreate]) (ref, typedata, data);
	break;
      case NumFormOpenDoc:
      case NumZoneDirOpenDoc:
      case NumSelDoc:
      case NumZoneDocNameToOpen:
      case NumToggleDocTypeToOpen:
	(*ThotLocalActions[T_opendoc]) (ref, typedata, data);
	break;
      case NumSelectImportClass:
      case NumFormImportClass:
	(*ThotLocalActions[T_import]) (ref, typedata, data);
	break;
      case NumFormPresentationSchema:
      case NumZonePresentationSchema:
	(*ThotLocalActions[T_presentation]) (ref, typedata, data);
	break;
      case NumFormClose:
	(*ThotLocalActions[T_rconfirmclose]) (ref, typedata, data);
	break;
	
      case NumMenuZoom:
	(*ThotLocalActions[T_chzoom]) (ref, typedata, data);
	break;
      case NumMenuVisibility:
	(*ThotLocalActions[T_chvisibility]) (ref, typedata, data);
	break;
      case NumMenuViewsToOpen:
	(*ThotLocalActions[T_openview]) (ref, typedata, data);
	break;
	
      case NumZoneFirstPage:
      case NumZoneLastPage:
      case NumZoneNbOfCopies:
      case NumZoneReduction:
      case NumMenuNbPagesPerSheet:
      case NumMenuViewsToPrint:
	(*ThotLocalActions[T_rextprint]) (ref, (int) data, NULL);
	break;
      case NumFormPrint:
      case NumMenuOptions:
      case NumMenuSupport:
      case NumMenuPaperFormat:
	(*ThotLocalActions[T_rprint]) (ref, (int) data, NULL);
	break;
      case NumZonePrinterName:
	(*ThotLocalActions[T_rprint]) (ref, 0, data);
	break;
	
      case NumZoneDocNameTooSave:
      case NumZoneDirDocToSave:
      case NumMenuFormatDocToSave:
      case NumMenuCopyOrRename:
      case NumFormSaveAs:
	(*ThotLocalActions[T_rsavedoc]) (ref, typedata, data);
	break;
      case NumFormPresChar:
      case NumFormPresFormat:
      case NumFormPresGraphics:
      case NumFormColors:
      case NumMenuCharFamily:
      case NumMenuCharFontStyle:
      case NumMenuCharFontWeight:
      case NumMenuCharFontSize:
      case NumMenuUnderlineType:
      case NumMenuUnderlineWeight:
      case NumMenuAlignment:
      case NumMenuJustification:
      case NumMenuWordBreak:
      case NumZoneRecess:
      case NumMenuRecessSense:
      case NumZoneLineSpacing:
      case NumMenuLineSpacing:
      case NumMenuStrokeStyle:
      case NumZoneStrokeWeight:
      case NumToggleWidthUnchanged:
      case NumTogglePatternUnchanged:
      case NumToggleForegroundUnchanged:
      case NumToggleBackgroundUnchanged:
	(*ThotLocalActions[T_present]) (ref, (int) data, NULL);
	break;
      case NumSelectPattern:
      case NumSelectForegroundColor:
      case NumSelectBackgroundColor:
	(*ThotLocalActions[T_present]) (ref, 0, data);
	break;
      case NumFormPresentStandard:
      case NumMenuPresentStandard:
	(*ThotLocalActions[T_presentstd]) (ref, (int) data);
	break;
      case NumZoneSearchPage:
      case NumFormSearchPage:
	(*ThotLocalActions[T_searchpage]) (ref, (int) data);
	break;
      case NumFormSearchEmptyElement:
	(*ThotLocalActions[T_searchemptyelt]) (ref, (int) data);
	break;
      case NumFormSearchReference:
	(*ThotLocalActions[T_searchrefto]) (ref, (int) data);
	break;
      case NumFormSearchEmptyReference:
	(*ThotLocalActions[T_searchemptyref]) (ref, (int) data);
	break;
      case NumFormSearchText:
      case NumMenuReplaceMode:
      case NumToggleUpperEqualLower:
      case NumMenuSearchNature:
	/* sous-menu mode de remplacement */
	(*ThotLocalActions[T_searchtext]) (ref, (int) data, NULL);
	break;
      case NumZoneTextSearch:
      case NumZoneTextReplace:
      case NumSelTypeToSearch:
	
      case NumSelAttributeToSearch:
	/* zone de saisie du texte de remplacement */
	(*ThotLocalActions[T_searchtext]) (ref, 0, data);
	break;
      case NumMenuOrSearchText:
	(*ThotLocalActions[T_locatesearch]) (ref, (int) data);
	break;  
	
      default:
	if (ref >= NumMenuAttrName && ref <= NumMenuAttrName + MAX_ITEM)
	  /* retour du menu des attributs */
	  {
#ifndef _WINDOWS
	    TtaSetDialoguePosition ();
#endif /* !_WINDOWS */
	    (*ThotLocalActions[T_rattr]) (ref, (int) data, ActiveFrame);
	  }
	if (ref >= NumMenuPresNature && ref <= NumMenuPresNature + NbMaxMenuPresNature)
	  /* retour des menus de changement de schema de presentation */
	  if (ThotLocalActions[T_rchangepres] != NULL)
	    (*ThotLocalActions[T_rchangepres]) (ref, (int)data);
	break;
      }
  else
    {
      /*** Action attachee au retour du dialoque de l'application ***/
      /* Calcule les indices menu, item et frame */
      /* ref = (((item+1) * MAX_MENU + menu) * MAX_ITEM) + frame + MAX_LocalMenu */
      j = ref - MAX_LocalMenu;
      i = j / MAX_ITEM;
      frame = j - (i * MAX_ITEM);	/* reste de la division */
#ifdef _WINDOWS
      if (frame != -1)
	{
	  if (frame != currentFrame)
	    frame = currentFrame;
	  currentWindow = FrRef [frame];
	}
#endif /* _WINDOWS */
      item = i / MAX_MENU;
      menu = i - (item * MAX_MENU);	/* reste de la division */
      if (frame == 0)
	{
	  document = 0;
	  view = 0;
	}
      else
	{
	  FrameToView (frame, &document, &view);
	  if (document == 0)
	    return;
	  menuThot = FindMenu (frame, FrameTable[frame].MenuAttr, &ptrmenu) - 1;
	  if (menu == menuThot)
	    {
	      /* traitement du menu attribut */
#ifndef _WINDOWS
	      TtaSetDialoguePosition ();
#endif /* !_WINDOWS */
	      (*ThotLocalActions[T_rattr]) (ref, (int) data, frame);
	      return;
	    }
	  menuThot = FindMenu (frame, FrameTable[frame].MenuSelect, &ptrmenu) - 1;
	     if (menu == menuThot)
	       {
		  /* traitement du menu selection */
#ifndef _WINDOWS
		  TtaSetDialoguePosition ();
#endif /* !_WINDOWS */
		  (*ThotLocalActions[T_rselect]) (ref, (int) data + 1, frame);
		  return;
	       }
	}

      /* Appel de l'action */
      ptrmenu = GetMenu_Ctl (frame, menu);
      action = 0;
      if (ptrmenu != NULL)
	{
	  if (item != 0)
	    {
	      item--;
	      if (item < ptrmenu->ItemsNb && ptrmenu->ItemsList != NULL)
		ptrmenu = ptrmenu->ItemsList[item].SubMenu;
	    }
	}
      if (ptrmenu != NULL)
	{
	  if ((int) data < ptrmenu->ItemsNb && ptrmenu->ItemsList != NULL)
	    action = ptrmenu->ItemsList[(int) data].ItemAction;
	  /*action = GetActionItem(frame, menu, (int)data); */
	  if (action > 0)
	    /* l'action existe et le menu est actif */
	    if (MenuActionList[action].ActionActive[frame])
	      {
		if (MenuActionList[action].Call_Action)
		  (*MenuActionList[action].Call_Action) (document, view);
	      }
	}
    }
}
/* End Of Module Thot */
