# Author:  Chao-Kuei Hung
# For more info, including license, please see doc/index.html

package DCEdge;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
use Edge;

require Exporter;
use Carp;

@ISA = qw(Exporter Edge);
@EXPORT = qw();
@EXPORT_OK = qw();
%EXPORT_TAGS = (all => [@EXPORT_OK]);

$VERSION = '0.1';

sub new {
    my ($class, $src, $tgt, %opts) = @_;
    $class = ref($class) if ref($class);
    my ($updated_opt) = ::merge_config_opts($class, \%opts);
    return $class->SUPER::new($src, $tgt, %$updated_opt);
}

sub twin {
    my ($self, $nv) = @_;
    my ($r) = $self->{adj}{twin};
    $self->{adj}{twin} = $nv if $#_ >= 1;
    return $r;
}

sub prev {
    my ($self, $nv) = @_;
    my ($r) = $self->{adj}{prev};
    $self->{adj}{prev} = $nv if $#_ >= 1;
    return $r;
}

sub next {
    my ($self, $nv) = @_;
    my ($r) = $self->{adj}{next};
    $self->{adj}{next} = $nv if $#_ >= 1;
    return $r;
}

sub configure {
    my ($self, %opts) = @_;
    $self->SUPER::configure(%opts);
    $self->twin()->SUPER::configure(%opts)
	if (not $self->cget(-directed) and ref $self->twin());
}

1;

