/*
 * libDASM
 *
 * Copyright (C) 2000-2003 Patrick Alken
 * This library comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this library is distributed.
 *
 * $Id: asm-x86.h,v 1.4 2003/08/26 00:09:03 cosine Exp $
 */

#ifndef INCLUDED_asm_x86_h
#define INCLUDED_asm_x86_h

#ifndef INCLUDED_libDASM_assemble_h
#include "assemble.h"           /* struct asmWorkspace */
#define INCLUDED_libDASM_assemble_h
#endif

struct instructionInfo
{
  /*
   * These fields are filled in by parseInstructionAsm()
   */

  int name;                      /* index into x86InstructionNames[] */

  int opnum;                     /* number of operands */
  unsigned int operands[3];      /* operand flags */
  int opinfo[3];                 /* additional operand info */

  struct immediateInfo immInfo;  /* numerical constant information */
  int hasImmed;                  /* has an immediate operand? */
};

/*
 * Prototypes
 */

int x86procAsm(struct asmWorkspace *ws, char *str,
               unsigned char *outbuf);

#endif /* INCLUDED_asm_x86_h */
