/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: scroll.h,v 1.1.1.1 2003/08/14 03:28:50 cosine Exp $
 */

#ifndef INCLUDED_scroll_h
#define INCLUDED_scroll_h

#ifndef INCLUDED_alddefs_h
#include "alddefs.h"       /* MAXLINE */
#define INCLUDED_alddefs_h
#endif

#ifndef INCLUDED_defs_h
#include "defs.h"          /* USE_CURSES */
#define INCLUDED_defs_h
#endif

#ifdef USE_CURSES

#ifndef INCLUDED_ncurses_h
#include <ncurses.h>       /* WINDOW */
#define INCLUDED_ncurses_h
#endif

/*
 * Prototypes
 */

struct Frame;

void PageUp(struct Frame *window);
void PageDown(struct Frame *window);
void KeyUp(struct Frame *window);
void KeyDown(struct Frame *window);
void KeyHome(struct Frame *window);
void KeyEnd(struct Frame *window);
void SetCurrentElement(struct Frame *window, int index);
void DrawWindow(struct Frame *swin);
struct Frame *CreateScrollingWindow();
void AddScrollData(struct Frame *window, char *data);
struct Frame *FindActiveScrollingWindow(WINDOW *win);
void ClearScrollData(struct Frame *window);
void ClearScrollWindow(struct Frame *window);
int DumpCurrentWindow(FILE *fptr);

/*
 * External declarations
 */

#endif /* USE_CURSES */

#endif /* INCLUDED_scroll_h */
