/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: main.h,v 1.1.1.1 2003/08/14 03:28:50 cosine Exp $
 */

#ifndef INCLUDED_main_h
#define INCLUDED_main_h

#include "command.h"
#include "print.h"
#include "rc.h"
#include "terminal.h"

#ifndef INCLUDED_libDebug_h
#include "libDebug.h"
#define INCLUDED_libDebug_h
#endif

#ifndef INCLUDED_libDASM_h
#include "libDASM.h"
#define INCLUDED_libDASM_h
#endif

#ifndef INCLUDED_libOFF_h
#include "libOFF.h"         /* struct offWorkspace */
#define INCLUDED_libOFF_h
#endif

struct aldWorkspace
{
  char *filename;                    /* command line filename, if any */

  /*
   * File loading parameters
   */
  void *MapPtr;                      /* pointer to mapped memory */
  size_t MappedSize;                 /* size of mapped memory */

  int objectFileDescriptor;          /* file we are debugging */
  char *objectFileName;              /* name of file we are debugging */

  unsigned int virtualFileAddress;   /* virtual address of file beginning */
  unsigned int virtualEntryPoint;    /* virtual address of entry point */
  unsigned int entryPoint;           /* entry point of object file */

  unsigned int objectFileOffset;     /* file offset */
  unsigned int virtualObjectFileOffset; /* virtual address of current offset */

  unsigned int settings;             /* boolean settings (see set.h) */
  unsigned int flags;                /* bitmask flags (AW_xxx) */
  unsigned int stepDisplayFlags;     /* regs to display on singlesteps (DB_REGFL_xxx) */

  /*
   * Disassemble variables
   */
  unsigned long nextInstruction;     /* next instruction to disassemble */
  unsigned int currentSectionStart;  /* start of current section */

  struct commandWorkspace *commandWorkspace_p;
  struct loadWorkspace *loadWorkspace_p;
  struct printWorkspace *printWorkspace_p;
  struct rcWorkspace *rcWorkspace_p;
  struct terminalWorkspace *terminalWorkspace_p;

  struct debugWorkspace *debugWorkspace_p;
  struct disasmWorkspace *disasmWorkspace_p;
  struct offWorkspace *offWorkspace_p;
};

#define AW_ATTACHED           (1 << 0)  /* attached to running process */
#define AW_FILELOADED         (1 << 1)  /* file loaded into memory */

#define awSetAttached(x)      ((x)->flags |= AW_ATTACHED)
#define awSetFileLoaded(x)    ((x)->flags |= AW_FILELOADED)

#define awIsAttached(x)       ((x)->flags & AW_ATTACHED)
#define awIsFileLoaded(x)     ((x)->flags & AW_FILELOADED)

#define awClearAttached(x)    ((x)->flags &= ~AW_ATTACHED)
#define awClearFileLoaded(x)  ((x)->flags &= ~AW_FILELOADED)

/*
 * Prototypes
 */

struct aldWorkspace *initALD(int argc, char *argv[]);
void termALD(struct aldWorkspace *ws);
int procALD(struct aldWorkspace *ws);

/*
 * External declarations
 */

extern struct aldWorkspace *mainWorkspace_p;

extern int ModeConsole;
extern int ModeCurses;
extern int PlatformEndian;

#endif /* INCLUDED_main_h */
