#!/bin/sh
# $Id: akpop3d.sh,v 1.3 2003/04/04 15:42:59 ak Exp $
# /etc/init.d/akpop3d: start and stop the akpop3d POP3 daemon
# (c) 2002-2003 Andreas Krennmair <ak@synflood.at>

PIDFILE=/var/run/akpop3d.pid
AKPOP3D=/usr/sbin/akpop3d

test -x /usr/sbin/akpop3d || exit 0

case "$1" in
  start)
    echo -n "Starting POP3 daemon: akpop3d"
    start-stop-daemon --background --start --quiet -m --pidfile $PIDFILE --exec $AKPOP3D
    echo "."
    ;;
  stop)
    echo -n "Stopping POP3 daemon: akpop3d"
    start-stop-daemon --stop --quiet --oknodo --pidfile $PIDFILE
    echo "."
    ;;
  restart)
    echo -n "Restarting POP3 daemon: akpop3d"
    start-stop-daemon --stop --quiet --oknodo --pidfile $PIDFILE
    sleep 3
    start-stop-daemon --background --start --quiet -m --pidfile $PIDFILE --exec $AKPOP3D &
    echo "."
    ;;
  *)
    echo "Usage /etc/init.d/akpop3d {start|stop|restart}"
    exit 1
esac

exit 0
