#!/bin/sh
# $Id: akpop3d-ssl.sh,v 1.3 2003/04/04 15:42:59 ak Exp $
# /etc/init.d/akpop3d-ssl: start and stop the akpop3d POP3-over-SSL daemon
# (c) 2002-2003 Andreas Krennmair <ak@synflood.at>

PIDFILE="/var/run/akpop3d-ssl.pid"
AKPOP3D="/usr/sbin/akpop3d -- -s"
SSD=start-stop-daemon

test -x /usr/sbin/akpop3d || exit 0

case "$1" in
  start)
    echo -n "Starting POP3 daemon: akpop3d"
    $SSD --start --background --quiet -m --pidfile $PIDFILE --exec $AKPOP3D &
    echo "."
    ;;
  stop)
    echo -n "Stopping POP3 daemon: akpop3d"
    $SSD --stop --quiet --oknodo --pidfile $PIDFILE
    echo "."
    ;;
  restart)
    echo -n "Restarting POP3 daemon: akpop3d"
    $SSD --stop --quiet --oknodo --pidfile $PIDFILE
    sleep 1
    $SSD --start --background --quiet -m --pidfile $PIDFILE --exec $AKPOP3D &
    sleep 1
    echo "."
    ;;
  *)
    echo "Usage /etc/init.d/akpop3d {start|stop|restart}"
    exit 1
esac

exit 0
