/* aide, Advanced Intrusion Detection Environment
 *
 * Copyright (C) 2000 Rami Lehti and Pablo Virolainen
 * $Header: /cvs-root-aide/aide/src/db_sql.c,v 1.5 2000/04/20 12:44:57 rammer Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"

#ifdef WITH_PSQL
 
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include "cipher.h"
#include "base64.h"
#include "db.h"

#ifdef WITH_MHASH
#include <mhash.h>
#endif

#include "db_config.h"
#include "libpq-fe.h"
#include "report.h"

char* db_get_sql(db_line*,db_config*);

const static char* db_sql_types[] = {
  "text", "int", "int", "int", "int", "int", "int", "int", 
  "int", "int", "int", "text", "text", "text", "text", "text", "text",
  "text", "text", "text", "text" };

int db_writespec_sql(db_config* conf){
  PGresult *res;
  int i;
  char* s;
  int ret = RETOK;
  s = (char*) malloc(sizeof(char)*1024); /* Hope 1023 bytes is
					    enouhg for string...
					    390 + length of table
					    name should be enough.
					 */
  s = strcat(s, "CREATE TABLE ");

  s = strcat(s, ((psql_data*)conf->db_out)->table);
  s = strcat(s, "(");
  
  for (i=0;i<conf->db_out_size;i++) {
    if (i!=0) {
      s = strcat(s, ",");
    }
    s = strcat(s, db_names[conf->db_out_order[i]]);
    s = strcat(s, " ");
    s = strcat(s, db_sql_types[conf->db_out_order[i]]);
  }
  s = strcat(s,");");

  error(255,"SQL:%s\n",s);

  res = PQexec(((psql_data*)conf->db_out)->conn,s);

  if (!res || PQresultStatus(res) != PGRES_COMMAND_OK){
      ret = RETFAIL;
      if (res!=NULL) {
	error(0,"Sql error %s while doing %s\n",
	      PQerrorMessage(((psql_data*)conf->db_out)->conn),s);
      } else {
	error(0,"Sql error while doing %s.\n",s);
      }
    } else {
      error(255,"Sql went ok.\n");
    }
  
  PQclear(res);  
  free(s); /* Just say no to memoryleaks. */
  
  return ret;
  
  /* FIXME!! No error checkin may be broken. Fix malloc also */ 
}

int db_writeline_sql(db_line* line,db_config* conf){

  PGresult *res;
  int i;
  int ret=RETOK;
  char* s=db_get_sql(line,conf) ;
  
  if (s==NULL) {
    return RETFAIL;
  }
  
  error(255,"SQL:%s",s);
  
  res = PQexec(((psql_data*)conf->db_out)->conn,s);
  
  if (!res || PQresultStatus(res) != PGRES_COMMAND_OK){
      ret = RETFAIL;
      if (res!=NULL) {
	error(0,"Sql error %s while doing %s\n",
	      PQerrorMessage(((psql_data*)conf->db_out)->conn),s);
      } else {
	error(0,"Sql error while doing %s.\n",s);
      }
    } else {
      error(255,"Sql went ok.\n");
    } 
  
  PQclear(res);
  
  return ret;
}

void sql_writeint(int data,char *s,int i){
  char t[10];
  t[0]=0;
  if (i!=0) {
    s = strcat(s,",");
  }
  sprintf(t,"%i",data);
  
  strcat(s,t);
  
}

void sql_writeoct(int data,char *s,int i){
  char t[10];
  t[0]=0;
  if (i!=0) {
    s = strcat(s,",");
  }
  sprintf(t,"%lo",data);
  
  strcat(s,t);
  
}

void sql_write_time_base64(time_t data,char* s,int i){
  static char* ptr=NULL;
  char* tmpstr=NULL;
  int retval=0;
  
  if(i!=0){
    strcat(s,",");
  }
  
  if(data==0){
    strcat(s,"''");
    return;
  }


  ptr=(char*)malloc(sizeof(char)*TIMEBUFSIZE);
  if (ptr==NULL) {
    error(0,"\nCannot allocate memory..\n");
    abort();
  }
  
  memset((void*)ptr,0,sizeof(char)*TIMEBUFSIZE);

  sprintf(ptr,"%li",data);


  tmpstr=encode_base64(ptr,strlen(ptr));
  strcat(s,"'");
  strcat(s,tmpstr);
  strcat(s,"'");

  free(tmpstr);
  free(ptr);
  
  return;
  
}

void sql_write_byte_base64(byte*data,size_t len,char* s,int i )
{
  char* tmpstr=NULL;
  int retval=0;
  
  tmpstr=encode_base64(data,len);
  if(i){
    strcat(s,",");
  }
  
  strcat(s,"'");
  
  if(tmpstr){
    strcat(s,tmpstr);
    free(tmpstr);
  }else {
    /* Do nothing.. */
  }
  
  strcat(s,"'");
  return;
}


char* db_get_sql(db_line* line,db_config* conf){
  
  int i;
  char* s=(char*) malloc(sizeof(char)*10240); /* FIXME .. */

  if (s==NULL) {
    error(0,"\nCannot allocate memory..\n");
    abort();
  }
  
  s[0]=0;
  
  s = strcat(s,"INSERT INTO aide values(");
  
  for(i=0;i<conf->db_out_size;i++){
    switch (conf->db_out_order[i]) {
    case db_filename : {
      if ( i!=0 ) {
	s = strcat(s,",");
      }
      strcat(s,"'");
      s = strcat(s,line->filename);
      strcat(s,"'");
      /*
	db_writechar(line->filename,conf->db_out,i);
      */
      
      break;
    }
    case db_bcount : {
      sql_writeint(line->bcount,s,i);
      break;
    }
    
    case db_mtime : {
      sql_write_time_base64(line->mtime,s,i);
      break;
    }
    case db_atime : {
      sql_write_time_base64(line->atime,s,i);
      break;
    }
    case db_ctime : {
      sql_write_time_base64(line->ctime,s,i);
      break;
    }
    case db_inode : {
      sql_writeint(line->inode,s,i);
      break;
    }
    case db_lnkcount : {
      sql_writeint(line->nlink,s,i);
      break;
    }
    case db_uid : {
      sql_writeint(line->uid,s,i);
      break;
    }
    case db_gid : {
      sql_writeint(line->gid,s,i);
      break;
    }
    case db_size : {
      sql_writeint(line->size,s,i);
      break;
    }
    case db_md5 : {
      sql_write_byte_base64(line->md5,
			   md_digest_length(DIGEST_ALGO_MD5),s,i);
      break;
    }
    case db_sha1 : {
      sql_write_byte_base64(line->sha1,
			   md_digest_length(DIGEST_ALGO_SHA1),s,i);
      break;
    }
    case db_rmd160 : {
      sql_write_byte_base64(line->rmd160,
			   md_digest_length(DIGEST_ALGO_RMD160),
			   s,i);
      break;
    }
    case db_tiger : {
      sql_write_byte_base64(line->tiger,
			   md_digest_length(DIGEST_ALGO_TIGER),
			   s,i);
      break;
    }
    case db_perm : {
      sql_writeoct(line->perm,s,i);
      break;
    }
#ifdef WITH_MHASH
    case db_crc32 : {
      sql_write_byte_base64(line->crc32,
			   mhash_get_block_size(MHASH_CRC32),
			   s,i);
      break;
    }
    case db_crc32b : {
      sql_write_byte_base64(line->crc32b,
			   mhash_get_block_size(MHASH_CRC32B),
			   s,i);
      break;
    }
    case db_haval : {
      sql_write_byte_base64(line->haval,
			   mhash_get_block_size(MHASH_HAVAL),
			   s,i);
      break;
    }
    case db_gost : {
      sql_write_byte_base64(line->gost ,
			   mhash_get_block_size(MHASH_GOST),
			   s,i);
      break;
    }
#endif
    default : {
      error(0,"Not implemented in sql_writeline_file %i\n",
	    conf->db_out_order[i]);
      return NULL;
    }
    
    }
    
  }

  strcat(s,");");

  return s;
}

#endif
