/* aide, Advanced Intrusion Detection Environment
 *
 * Copyright (C) 1999,2000 Rami Lehti,Pablo Virolainen
 * $Header: /cvs-root-aide/aide/src/be.c,v 1.12 2000/04/20 12:44:55 rammer Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <errno.h>
#include "aide.h"
#include "db_config.h"
#include "db_file.h"
#include "report.h"

#ifdef WITH_PSQL
#include "libpq-fe.h"
#endif

char* get_first_value(char** in){
  int i=0;
  char* ret = (*in);
  while((*in)[i]!=':' && (*in)[i]!='\0') {
    i++;
  }
  /*  
      if (i==0) {
      return NULL;
      }
  */
  if ((*in)[i]!='\0') { /* Lets not go beond the sting.. */
    (*in)[i]='\0';
    (*in)+=i+1;
  }
  return ret;
}

void* be_init(int inout,url_t* u,int iszipped)
{
  FILE* fh=NULL;
  long a=0;
  char* err=NULL;
  int retval;

#ifdef WITH_ZLIB
  if(iszipped) {
    int pipefd[2];
    
    if(pipe(pipefd)<0){
      error(0,"Couldn't open a pipe for zipped output\n");
      return NULL;
    }
    if((retval=fork())==0){
      /* child process */
      close(pipefd[1]);
      fh=be_init(inout,u,0);
      conf->db_gzout=gzdopen(fileno(fh),"wb");
      handle_gzipped_output(pipefd[0]);
    } else {
      /* parent process */
      close(pipefd[0]);
      fh=fdopen(pipefd[1],"w");
    }
    return fh;
  }
#endif
  
  switch (u->type) {
  case url_file : {
    error(200,"Opening file \"%s\" for %s\n",u->value,inout?"r":"w+");
    fh=fopen(u->value,inout?"r":"w+");
    if(fh==NULL){
      error(0,"Couldn't open file %s for %s",u->value,
	    inout?"reading\n":"writing\n");
    }
    return fh;
  }
  case url_stdout : {
    return stdout;
  }
  case url_stdin : {
    return stdin;
  }
  case url_stderr : {
    return stderr;
  }
  case url_fd : {
    a=strtol(u->value,&err,10);
    if(*err!='\0'||errno==ERANGE){
      error(0,"Illegal file descriptor value:%s\n",u->value);
    }
    fh=fdopen(a,inout?"r":"w");
    if(fh==NULL){
      error(0,"Couldn't reopen file descriptor %i\n",a);
    }
    return fh;
  }
#ifdef WITH_PSQL
  case url_sql : {
    char *pghost, *pgport, *pgoptions, *pgtty, *dbName, *login, *pwd;
    char *tmp,*tmp2;
    psql_data* ret = (psql_data*) malloc(sizeof(psql_data)*1);

    if (ret==NULL) {
      error(0,"Not enough memory for postgres sql connection\n");
      return ret;
    }


    tmp=strdup(u->value);
    tmp2=tmp;
    
    pgtty=NULL;pgoptions=NULL;
    
    if ((pghost=get_first_value(&tmp)) == NULL) {
      error(0,"Must define host for Postgres sql connection\n");
      free(tmp2);
      return NULL;
    } else {
      error(100,"Psql host is %s\n",pghost);
      if ((pgport=get_first_value(&tmp)) == NULL) {
	error(0,"Must define port for Postgres sql connection\n");
	free(tmp2);
	return NULL;
      } else {
	error(100,"Psql port is %s\n",pgport);
	if ((dbName=get_first_value(&tmp)) == NULL) {
	  error(0,"Must define name for database for Postgres sql connection\n");
	  free(tmp2);
	  return NULL;
	} else {
	  error(100,"Psql db is %s\n",dbName);
	  if ((login=get_first_value(&tmp)) == NULL) {
	    error(0,"Must define login for Postgres sql connection\n");
	    free(tmp2);
	    return NULL;
	  } else {
	    error(100,"Psql login is %s\n",login);
	    if ((pwd=get_first_value(&tmp)) == NULL) {
	      error(0,"Must define password for database for Postgres sql connection\n");
	      free(tmp2);
	      return NULL;
	    } else {
	      error(100,"Psql passwd is %s\n",pwd);
	      if ((ret->table=get_first_value(&tmp))==NULL) {
		error(0,"Must define table for sql..\n");
		free(tmp2);
		return NULL;
	      } else {
		if (ret->table[0]=='\0') {
		  error(0,"Must define table for sql..\n");
		  free(tmp2);
		  return NULL;
		} else {
		  /* everything went ok.. */
		}
	      }
	    }
	  }
	}
      }
    }
   
    /*printf("host:\"%s\" port:\"%s\" database:\"%s\" login:\"%s\" passwd:\"%s\" table:\"%s\"\n",pghost,pgport,dbName,login,pwd,ret->table); */
    
    
    if (login[0] == '\0' ) {
      login = NULL;
    }
    if (pwd[0] == '\0' ) {
      pwd = NULL;
    }
    
    ret->conn = PQsetdbLogin(pghost,pgport,pgoptions,pgtty,dbName,login,pwd);
    if (PQstatus(ret->conn) == CONNECTION_BAD){
      error(0,"Postgres sql error during connection\n");
      free(tmp2);
      return NULL;
    }
    /* Otherwise we would become to situation that name of table would
       be freeed 
    */
    ret->table = strdup(ret->table);

    free(tmp2);
    return ret;
  }
#endif

  default:{
    error(0,"Unsupported backend:%i", u->type);
    return NULL;
  }    
  }
  /* Not reached */
  return NULL;

}
