/*  $Id: Controller.cpp,v 1.10 2009/02/27 03:08:33 sarrazip Exp $
    Controller.h - Source of commands from the user.

    afternoonstalker - A robot-killing video game.
    Copyright (C) 2001-2009 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#include "Controller.h"


// These button numbers are not portable accross different gamepads.
enum
{
    A_BTN = 0,
    B_BTN = 1,
    Y_BTN = 3,
    X_BTN = 2,
    START_BTN = 6,
    BACK_BTN = 10
};


// These axis numbers are specific to Xbox 360 USB controller
enum
{
    MAIN_X = 0,
    MAIN_Y = 1,
    SECONDARY_X = 6,
    SECONDARY_Y = 7
};


Controller::Controller()
  : menuKS(SDLK_ESCAPE),
    leftKS(SDLK_LEFT),
    rightKS(SDLK_RIGHT),
    upKS(SDLK_UP),
    downKS(SDLK_DOWN),
    selectKS(SDLK_SPACE, SDLK_RETURN),
    shootKS(SDLK_LCTRL, SDLK_RCTRL),
    pauseKS(SDLK_p),
    shootLeftKS(SDLK_h),
    shootRightKS(SDLK_l),
    shootUpKS(SDLK_k),
    shootDownKS(SDLK_j),
    joystick(NULL),
    joystickButtons(),
    xAxis(0),
    yAxis(0),
    shootLeftBI(X_BTN),
    shootRightBI(B_BTN),
    shootUpBI(Y_BTN),
    shootDownBI(A_BTN),
    startBI(START_BTN),
    pauseBI(BACK_BTN)
{
    if (SDL_Init(SDL_INIT_JOYSTICK) == 0 && SDL_NumJoysticks() > 0)
    {
	joystick = SDL_JoystickOpen(0);
	if (joystick != NULL)
	    joystickButtons.resize(size_t(SDL_JoystickNumButtons(joystick)), false);
    }
}


Controller::~Controller()
{
    if (joystick != NULL)
	SDL_JoystickClose(joystick);
}


void
Controller::processKey(SDLKey keysym, bool pressed)
{
    menuKS.check(keysym, pressed);
    leftKS.check(keysym, pressed);
    rightKS.check(keysym, pressed);
    upKS.check(keysym, pressed);
    downKS.check(keysym, pressed);
    selectKS.check(keysym, pressed);
    shootKS.check(keysym, pressed);
    pauseKS.check(keysym, pressed);
    shootLeftKS.check(keysym, pressed);
    shootDownKS.check(keysym, pressed);
    shootUpKS.check(keysym, pressed);
    shootRightKS.check(keysym, pressed);
}


void
Controller::update()
{
    menuKS.remember();
    leftKS.remember();
    rightKS.remember();
    upKS.remember();
    downKS.remember();
    selectKS.remember();
    shootKS.remember();
    pauseKS.remember();
    shootLeftKS.remember();
    shootRightKS.remember();
    shootUpKS.remember();
    shootDownKS.remember();

    if (joystick != NULL)
    {
	// Remember current joystick button states for next tick.
	for (size_t i = joystickButtons.size(); i--; )
	    joystickButtons[static_cast<size_t>(i)] = (getJButton(i) != 0);

	Sint16 dpadAxis = SDL_JoystickGetAxis(joystick, SECONDARY_X);
	xAxis = (abs(dpadAxis) == 32767 ? dpadAxis : SDL_JoystickGetAxis(joystick, MAIN_X));

	dpadAxis = SDL_JoystickGetAxis(joystick, SECONDARY_Y);
	yAxis = (abs(dpadAxis) == 32767 ? dpadAxis : SDL_JoystickGetAxis(joystick, MAIN_Y));

	// Update joystick button states.
	SDL_JoystickUpdate();
    }
}
