/*  $Id: RobotSprite.cpp,v 1.1 2001/12/28 20:08:31 sarrazip Exp $
    RobotSprite.cpp - Sprite that represents a robot.

    afternoonstalker - A robot-killing video game.
    Copyright (C) 2001 Pierre Sarrazin <sarrazip@iname.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/


#include "RobotSprite.h"


RobotSprite::RobotSprite(const PixmapArray &pixmapArray,
			    const Couple &pos,
			    const Couple &collBoxPos,
			    const Couple &collBoxSize,
			    const PixmapArray &explosionPA)
  : Sprite(pixmapArray, pos, Couple(), Couple(), collBoxPos, collBoxSize),
    timeOfLastShot(-1),
    smart(false),
    numShotsBeforeDeath(1),
    endOfBlinkTime(0),
    bigBullets(false),
    theExplosionPA(&explosionPA),
    blinkSprite(NULL)
{
}


RobotSprite::~RobotSprite()
{
}


void
RobotSprite::startBlinking(PixmapArray &pa, unsigned long endOfBlinkTime)
{
    blinkSprite = new Sprite(pa,
			Couple(), Couple(), Couple(), Couple(), Couple());
    this->endOfBlinkTime = endOfBlinkTime;
}


Sprite *RobotSprite::getBlinkSprite() const
{
    return blinkSprite;
}


void RobotSprite::stopBlinking()
{
    delete blinkSprite;
    blinkSprite = NULL;
    endOfBlinkTime = 0;
}
