/* aewm - a minimalist X11 window mananager. vim:sw=4:ts=4:et
 * Copyright 1998-2004 Decklin Foster <decklin@red-bean.com>
 * This program is free software; see LICENSE for details. */

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include <stdlib.h>

Display *dpy;
Window root;

int send_xmessage(Window w, Atom a, int x)
{
    XClientMessageEvent e;

    e.type = ClientMessage;
    e.window = w;
    e.message_type = a;
    e.format = 32;
    e.data.l[0] = x;

    return XSendEvent(dpy, w, False,
        SubstructureNotifyMask|SubstructureRedirectMask,
        (XEvent *)&e);
}

int main(int argc, char **argv)
{
    Atom net_current_desktop;
    int desk;

    if (argc < 2) {
        fprintf(stderr, "must specify a desk\n");
        exit(2);
    }

    dpy = XOpenDisplay(NULL);
    root = DefaultRootWindow(dpy);
    net_current_desktop = XInternAtom(dpy, "_NET_CURRENT_DESKTOP", False);

    if (!dpy) {
        fprintf(stderr, "can't open $DISPLAY: '%s'\n", getenv("DISPLAY"));
        exit(1);
    }

    desk = atoi(argv[1]);

    send_xmessage(root, net_current_desktop, desk);
    XCloseDisplay(dpy);
    return 0;
}
