/* aewm - a minimalist X11 window mananager. vim:sw=4:ts=4:et
 * Copyright 1998-2004 Decklin Foster <decklin@red-bean.com>
 * This program is free software; see LICENSE for details. */

#include <stdlib.h>
#include <signal.h>
#include <sys/wait.h>
#include <X11/Xmd.h>
#include <X11/Xatom.h>
#include "panel.h"
#include "strut.h"
#include "switch.h"

Atom net_wm_strut;
Atom net_wm_strut_partial;
Atom net_wm_window_type;
Atom net_wm_window_type_dock;

void sig_handler(int signal)
{
    if (signal == SIGCHLD) wait(NULL);
}

void set_strut(Window w, strut_t *s)
{
    CARD32 data[4];

    data[0] = s->left;
    data[1] = s->right;
    data[2] = s->top;
    data[3] = s->bottom;

    XChangeProperty(dpy, w, net_wm_strut, XA_CARDINAL,
        32, PropModeReplace, (unsigned char *)data, 4);
    XFlush(dpy);
}
