/* aewm - a minimalist X11 window mananager. vim:sw=4:ts=4:et
 * Copyright 1998-2004 Decklin Foster <decklin@red-bean.com>
 * This program is free software; see LICENSE for details. */

#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include "aeclients.h"
#include "launch.h"
#include "switch.h"
#include "panel.h"

void add_launch_menu_item(menu_t, char *, char *);
menu_t add_launch_sub_menu(menu_t, char *);
void make_client_button(menu_t, Window);
void update_client_button(unsigned char *, void *);
void cleanup_client_button(client_t *, GtkWidget *);
GdkFilterReturn check_event(GdkXEvent *, GdkEvent *, gpointer);
void show_menu_cb(GtkWidget *, gpointer);
void raise_win_cb(GtkWidget *, Window);
void fork_exec_cb(GtkWidget *, char *);

#define NAME_SIZE 256

client_t *head_client = NULL;

GtkWidget *menu_button = NULL;
int opt_bottom;

int main(int argc, char **argv)
{
    GtkWidget *toplevel, *frame, *cmds_box, *launch_menu, *quit_button;
    GtkWidget *clients_box;
    client_t *c;
    strut_t s = { 0, 0, 0, 0 };
    int root_width, root_height;
    char *opt_config = NULL;
    struct sigaction act;
    int i;

    gtk_init(&argc, &argv);
#ifdef USE_OLD_GTK
    gdk_error_warnings = 0; /* gag me with a spoon... */
#else
    gdk_error_trap_push(); /* slightly better, i guess */
#endif

    for (i = 1; i < argc; i++) {
        if ARG("config", "rc", 1)  {
            opt_config = argv[++i];
            continue;
        }
        if ARG("bottom", "b", 0)  {
            opt_bottom = 1;
            continue;
        }
        /* nothing matched */
        fprintf(stderr, "usage: aepanel [--bottom|-b] [--config|-rc <file>]\n");
        exit(2);
    }

    act.sa_handler = sig_handler;
    act.sa_flags = 0;
    sigaction(SIGCHLD, &act, NULL);

    dpy = GDK_DISPLAY();
    root = GDK_ROOT_WINDOW();

    wm_state = XInternAtom(dpy,
        "WM_STATE", False);
    net_client_list = XInternAtom(dpy,
        "_NET_CLIENT_LIST", False);
    net_current_desktop = XInternAtom(dpy,
        "_NET_CURRENT_DESKTOP", False);
    net_wm_desktop = XInternAtom(dpy,
        "_NET_WM_DESKTOP", False);
    net_wm_strut = XInternAtom(dpy,
        "_NET_WM_STRUT", False);
    net_wm_strut_partial = XInternAtom(dpy,
        "_NET_WM_STRUT_PARTIAL", False);
    net_wm_state = XInternAtom(dpy,
        "_NET_WM_STATE", False);
    net_wm_state_skip_taskbar = XInternAtom(dpy,
        "_NET_WM_STATE_SKIP_TASKBAR", False);
    net_wm_state_skip_pager = XInternAtom(dpy,
        "_NET_WM_STATE_SKIP_PAGER", False);
    net_wm_window_type = XInternAtom(dpy,
        "_NET_WM_WINDOW_TYPE", False);
    net_wm_window_type_dock = XInternAtom(dpy,
        "_NET_WM_WINDOW_TYPE_DOCK", False);

    toplevel = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    g_signal_connect(G_OBJECT(toplevel), "delete_event",
        G_CALLBACK(gtk_main_quit), NULL);

    launch_menu = gtk_menu_new();

    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
    gtk_container_add(GTK_CONTAINER(toplevel), frame);

    cmds_box = gtk_hbox_new(FALSE, SPACING);
    gtk_container_set_border_width(GTK_CONTAINER(cmds_box), SPACING-1);
    gtk_container_add(GTK_CONTAINER(frame), cmds_box);

    menu_button = gtk_button_new_with_label("Menu");
    gtk_signal_connect(GTK_OBJECT(menu_button), "clicked",
        GTK_SIGNAL_FUNC(show_menu_cb), launch_menu);
    gtk_box_pack_start(GTK_BOX(cmds_box), menu_button, FALSE, FALSE, 0);

    quit_button = gtk_button_new_with_label("Quit");
    gtk_signal_connect(GTK_OBJECT(quit_button), "clicked",
        GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
    gtk_box_pack_start(GTK_BOX(cmds_box), quit_button, FALSE, FALSE, 0);

    clients_box = gtk_hbox_new(TRUE, SPACING);
    gtk_container_add(GTK_CONTAINER(cmds_box), clients_box);
    gtk_container_set_resize_mode(GTK_CONTAINER(clients_box),
        GTK_RESIZE_QUEUE);

    XSelectInput(dpy, GDK_ROOT_WINDOW(), PropertyChangeMask);
    gdk_window_add_filter(gdk_get_default_root_window(),
        check_event, clients_box);

    make_launch_menu(opt_config, launch_menu,
        add_launch_menu_item, add_launch_sub_menu);
    atom_foreach(root, net_client_list, XA_WINDOW,
        update_client_button, (void *)clients_box);
    for (c = head_client; c; c = c->next)
        cleanup_client_button(c, clients_box);

    gtk_widget_show_all(frame);
    gtk_widget_realize(toplevel);

    gtk_window_set_skip_taskbar_hint(GTK_WINDOW(toplevel), TRUE);
    gtk_window_set_skip_pager_hint(GTK_WINDOW(toplevel), TRUE);
    gtk_window_set_decorated(GTK_WINDOW(toplevel), FALSE);
    gtk_window_stick(GTK_WINDOW(toplevel));

    /* this last call is not working for some reason, so we'll just
     * have to kludge it for now. */

#ifdef _HEY_LOOK_AT_THAT_SOMEBODY_FIXED_THE_GTKWINDOW_TYPE_HINT_CRAP
    gtk_window_set_type_hint(GTK_WINDOW(toplevel),
        GDK_WINDOW_TYPE_HINT_DOCK);
#else
    set_atom(GDK_WINDOW_XID(toplevel->window), net_wm_window_type,
        XA_ATOM, net_wm_window_type_dock);
#endif

    if (opt_bottom) s.bottom = toplevel->allocation.height;
    else s.top = toplevel->allocation.height;
    set_strut(GDK_WINDOW_XID(toplevel->window), &s);

    gdk_window_get_size(gdk_get_default_root_window(),
        &root_width, &root_height);

    gtk_widget_set_size_request(toplevel, root_width, -1);
    gtk_widget_show_all(toplevel);

    /* Ihe way this is SUPPOSED to work is that I call it before
     * mapping the window, and GTK magically sets the PPosition hint
     * instead of doing an actual move. But it doesn't, so I have to
     * move it after mapping. Ugly ugly ugly. */

    gtk_window_move(GTK_WINDOW(toplevel),
        0, opt_bottom ? root_height - toplevel->allocation.height : 0);

    gtk_main();
    return 0;
}

void add_launch_menu_item(menu_t menu, char *label, char *cmd)
{
    GtkWidget *item;

    item = gtk_menu_item_new_with_label(label);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
        GTK_SIGNAL_FUNC(fork_exec_cb), cmd);
    gtk_widget_show(item);
}

menu_t add_launch_sub_menu(menu_t menu, char *label)
{
    GtkWidget *item, *new_menu;

    new_menu = gtk_menu_new();
    item = gtk_menu_item_new_with_label(label);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), new_menu);
    gtk_widget_show(item);

    return new_menu;
}

void update_client_button(unsigned char *data, void *cb_data)
{
    Window w = *(Window *)data;
    GtkWidget *container = GTK_WIDGET(cb_data);
    client_t *c;
    char buf[NAME_SIZE];

    for (c = head_client; c; c = c->next) {
        if (c->window == w) {
            if (is_on_cur_desk(w)) {
                gtk_widget_show(GTK_WIDGET(c->widget));
            } else {
                gtk_widget_hide(GTK_WIDGET(c->widget));
            }
            c->save = 1;
            return;
        }
    }

    if (is_on_cur_desk(w) && !is_skip(w)) {
        c = malloc(sizeof *c);
        c->next = head_client;
        head_client = c;
        c->window = w;
        c->save = 1;

        get_wm_name(w, buf, sizeof buf);
        c->widget = gtk_button_new_with_label(buf);
        gtk_signal_connect(GTK_OBJECT(c->widget), "clicked",
            GTK_SIGNAL_FUNC(raise_win_cb), (gpointer)w);
        gtk_box_pack_start(GTK_BOX(container),
            c->widget, TRUE, TRUE, 0);
        gtk_misc_set_alignment(GTK_MISC(GTK_BIN(c->widget)->child),
            0, 0.5);
        gtk_widget_show(c->widget);

        XSelectInput(dpy, c->window, PropertyChangeMask);
        gdk_window_add_filter(gdk_window_lookup(c->window),
            check_event, container);
    }
}

void cleanup_client_button(client_t *c, GtkWidget *container)
{
    client_t *p;

    if (c->save) {
        c->save = 0;
    } else {
        gtk_container_remove(GTK_CONTAINER(container),
            GTK_WIDGET(c->widget));
        if (head_client == c) head_client = c->next;
        else for (p = head_client; p && p->next; p = p->next)
            if (p->next == c) p->next = c->next;
        free(c);
    }
}

GdkFilterReturn check_event(GdkXEvent *gdk_xevent, GdkEvent *event,
    gpointer container)
{
    XEvent *e = (XEvent *)gdk_xevent;
    client_t *c, *next;
    char buf[NAME_SIZE];

    if (e->type == PropertyNotify) {
        if (e->xproperty.window == root) {
            if (e->xproperty.atom == net_current_desktop ||
                    e->xproperty.atom == net_client_list) {
                atom_foreach(root, net_client_list, XA_WINDOW,
                    update_client_button, (void *)container);
                for (c = head_client; c; c = next) {
                    next = c->next;
                    cleanup_client_button(c, GTK_WIDGET(container));
                }
            }
        } else {
            for (c = head_client; c; c = c->next) {
                if (c->window == e->xproperty.window) {
                    get_wm_name(c->window, buf, sizeof buf);
                    gtk_label_set_text(GTK_LABEL(GTK_BIN(c->widget)->child),
                        buf);
                }
            }
        }
    }

    return GDK_FILTER_CONTINUE;
}

#ifdef USE_OLD_GTK
void menu_position(GtkMenu *menu, gint *x, gint *y, gpointer data)
#else
void menu_position(GtkMenu *menu, gint *x, gint *y,
    gboolean *push_in, gpointer data)
#endif
{
    GtkWidget *button = GTK_WIDGET(data);
    gint wx, wy;

    gdk_window_get_root_origin(button->window, &wx, &wy);
    *x = wx + button->allocation.x;
    *y = wy + button->allocation.y;

    if (opt_bottom) {
        /* This is crap. I shouldn't have to do anything here, but if
         * the menu-position func gives coords near the bottom of the
         * screen, GTK+ will blindly try to follow them rather than
         * flipping the menu up (around the coord parallel to the
         * screen edge) like it would do in every other case (that is,
         * any instance where the coords are determined automatically).
         * Feh. All toolkits suck. Not only that, but this hack seems
         * to make drawing the menu a little bit slower. */
        GtkRequisition req;
        gtk_widget_size_request(GTK_WIDGET(menu), &req);
        *y -= req.height;
    } else {
        *y += button->allocation.height;
    }
}

void show_menu_cb(GtkWidget *widget, gpointer menu)
{
    gtk_menu_popup(menu, NULL, NULL, menu_position, menu_button, 0, 0);
}

void raise_win_cb(GtkWidget *widget, Window w)
{
    raise_win(w);
}

void fork_exec_cb(GtkWidget *widget, char *data)
{
    fork_exec(data);
}
