/* aewm - a minimalist X11 window mananager. vim:sw=4:ts=4:et
 * Copyright 1998-2004 Decklin Foster <decklin@red-bean.com>
 * This program is free software; see LICENSE for details. */

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include "aeclients.h"
#include "launch.h"
#include "switch.h"
#include "xaw-util.h"

void make_launch_menu_item(menu_t, char *, char *); 
menu_t make_launch_sub_menu(menu_t, char *);
void make_client_menu_item(unsigned char *, void *);
void raise_win_cb(Widget, XtPointer, XtPointer);
void fork_exec_cb(Widget, XtPointer, XtPointer);

int main(int argc, char **argv)
{
    Widget toplevel, main_menu;
    int i, mode = LAUNCH;
    char *opt_config = NULL;

    toplevel = XtInitialize(argv[0], "AeMenu", NULL, 0, &argc, argv);
    dpy = XtDisplay(toplevel);
    root = DefaultRootWindow(dpy);
    main_menu = XtVaCreatePopupShell("menu",
        simpleMenuWidgetClass, toplevel, NULL);

    for (i = 1; i < argc; i++) {
        if ARG("config", "rc", 1)  {
            opt_config = argv[++i];
            continue;
        }
        if ARG("launch", "l", 0)   {
            mode = LAUNCH;
            continue;
        }
        if ARG("switch", "s", 0)   {
            mode = SWITCH;
            continue;
        }
        /* nothing matched */
        fprintf(stderr, "usage: aemenu [--switch|-s] [--config|-rc <file>]\n");
        exit(2);
    }


    if (mode == LAUNCH) {
        make_launch_menu(opt_config, main_menu,
            make_launch_menu_item, make_launch_sub_menu);
    } else /* mode == SWITCH */ {
        wm_state = XInternAtom(dpy,
            "WM_STATE", False);
        net_client_list = XInternAtom(dpy,
            "_NET_CLIENT_LIST", False);
        net_current_desktop = XInternAtom(dpy,
            "_NET_CURRENT_DESKTOP", False);
        net_wm_desktop = XInternAtom(dpy,
            "_NET_WM_DESKTOP", False);
        net_wm_state = XInternAtom(dpy,
            "_NET_WM_STATE", False);
        net_wm_state_skip_taskbar = XInternAtom(dpy,
            "_NET_WM_STATE_SKIP_TASKBAR", False);
        net_wm_state_skip_pager = XInternAtom(dpy,
            "_NET_WM_STATE_SKIP_PAGER", False);
        atom_foreach(root, net_client_list, XA_WINDOW,
            make_client_menu_item, (void *)main_menu);
    }

    popup_cb(NULL, main_menu, NULL);
    XtMainLoop();
    return 0;
}

void make_launch_menu_item(menu_t menu, char *label, char *cmd)
{
    Widget menu_item = XtVaCreateManagedWidget(label,
        smeBSBObjectClass, menu, NULL);
    XtAddCallback(menu_item, XtNcallback, fork_exec_cb, cmd);
}

menu_t make_launch_sub_menu(menu_t menu, char *label)
{
    Widget new_menu, menu_item;
    new_menu = XtVaCreatePopupShell(label,
        simpleMenuWidgetClass, menu, NULL);
    menu_item = XtVaCreateManagedWidget(label,
        smeBSBObjectClass, menu,
        XtNmenuName, label, NULL);
    XtAddCallback(menu_item,
        XtNcallback, popup_cb, (XtPointer)new_menu);
    return new_menu;
}

void make_client_menu_item(unsigned char *data, void *cb_data)
{
    Window w = *(Window *)data;
    Widget menu = cb_data;
    Widget menu_item;
    char buf[BUF_SIZE];

    if (get_wm_state(w) != WithdrawnState &&
            is_on_cur_desk(w) && !is_skip(w)) {
        get_wm_name(w, buf, sizeof buf);
        menu_item = XtVaCreateManagedWidget(buf,
            smeBSBObjectClass, menu, NULL);
        XtAddCallback(menu_item,
            XtNcallback, raise_win_cb, (XtPointer)w);
    }
}

void raise_win_cb(Widget w, XtPointer data, XtPointer call)
{
    raise_win((Window)data);
    exit(0);
}

void fork_exec_cb(Widget w, XtPointer data, XtPointer call)
{
    fork_exec(data);
    exit(0);
}
