/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include "aewm.h"
#include <string.h>
#include <signal.h>
#include <X11/cursorfont.h>

Display *dpy;
Window root;
int screen;
XFontStruct *font;
#ifdef XFT
XftFont *xftfont;
XftColor xft_fg;
#endif
GC invert_gc, string_gc, border_gc;
XColor fg, bg, bd;
Cursor move_curs, resize_curs;
Atom wm_state, wm_change_state, wm_protos, wm_delete, wm_cmapwins;
#ifdef MWM_HINTS
Atom mwm_hints;
#endif
Client *head_client;
char *opt_font = DEF_FONT;
char *opt_fg = DEF_FG;
char *opt_bg = DEF_BG;
char *opt_bd = DEF_BD;
char *opt_new1 = DEF_NEW1;
char *opt_new2 = DEF_NEW2;
char *opt_new3 = DEF_NEW3;
int opt_bw = DEF_BW;
#ifdef SHAPE
Bool shape;
int shape_event;
#endif

static void scan_wins(void);
static void setup_display(void);

int main(int argc, char **argv)
{
    int i;
    struct sigaction act;

#define OPT_STR(name, variable)                                      \
    if (strcmp(argv[i], name) == 0 && i+1<argc) {                    \
        variable = argv[++i];                                        \
        continue;                                                    \
    }
#define OPT_INT(name, variable)                                      \
    if (strcmp(argv[i], name) == 0 && i+1<argc) {                    \
        variable = atoi(argv[++i]);                                  \
        continue;                                                    \
    }

    for (i = 1; i < argc; i++) {
        OPT_STR("-fn", opt_font)
        OPT_STR("-fg", opt_fg)
        OPT_STR("-bg", opt_bg)
        OPT_STR("-bd", opt_bd)
        OPT_INT("-bw", opt_bw)
        OPT_STR("-new1", opt_new1)
        OPT_STR("-new2", opt_new2)
        OPT_STR("-new3", opt_new3)
        if (strcmp(argv[i], "-version") == 0) {
            printf("aewm: version " VERSION "\n");
            exit(0);
        }
        /* shouldn't get here; must be a bad option */
        err("usage: aewm [options]\n"
            "   options are: -fn <font>, -fg|-bg|-bd <color>\n"
            "   -bw <width>, -new1|-new2|-new3 <cmd>");
        return 2;
    }

    act.sa_handler = sig_handler;
    act.sa_flags = 0;
    sigaction(SIGTERM, &act, NULL);
    sigaction(SIGINT, &act, NULL);
    sigaction(SIGHUP, &act, NULL);
    sigaction(SIGCHLD, &act, NULL);

    setup_display();
    scan_wins();
    do_event_loop();
    return 1; /* just another brick in the -Wall */
}

static void scan_wins(void)
{
    unsigned int nwins, i;
    Window dummyw1, dummyw2, *wins;
    XWindowAttributes attr;

    XQueryTree(dpy, root, &dummyw1, &dummyw2, &wins, &nwins);
    for (i = 0; i < nwins; i++) {
        XGetWindowAttributes(dpy, wins[i], &attr);
        if (!attr.override_redirect && attr.map_state == IsViewable)
            make_new_client(wins[i]);
    }
    XFree(wins);
}

static void setup_display(void)
{
    XColor dummyc;
    XGCValues gv;
    XSetWindowAttributes sattr;
#ifdef SHAPE
    int dummy;
#endif

    dpy = XOpenDisplay(NULL);

    if (!dpy) {
        err("can't open display! check your DISPLAY variable.");
        exit(1);
    }

    XSetErrorHandler(handle_xerror);
    screen = DefaultScreen(dpy);
    root = RootWindow(dpy, screen);

    wm_state = XInternAtom(dpy, "WM_STATE", False);
    wm_change_state = XInternAtom(dpy, "WM_CHANGE_STATE", False);
    wm_protos = XInternAtom(dpy, "WM_PROTOCOLS", False);
    wm_delete = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
    wm_cmapwins = XInternAtom(dpy, "WM_COLORMAP_WINDOWS", False);
#ifdef MWM_HINTS
    mwm_hints = XInternAtom(dpy, _XA_MWM_HINTS, False);
#endif

    XAllocNamedColor(dpy, DefaultColormap(dpy, screen), opt_fg, &fg, &dummyc);
    XAllocNamedColor(dpy, DefaultColormap(dpy, screen), opt_bg, &bg, &dummyc);
    XAllocNamedColor(dpy, DefaultColormap(dpy, screen), opt_bd, &bd, &dummyc);

    font = XLoadQueryFont(dpy, opt_font);
    if (!font) { err("font '%s' not found", opt_font); exit(1); }

#ifdef XFT
    xft_fg.color.red = fg.red;
    xft_fg.color.green = fg.green;
    xft_fg.color.blue = fg.blue;
    xft_fg.color.alpha = 0xffff;
    xft_fg.pixel = fg.pixel;

    xftfont = XftFontOpenXlfd(dpy, DefaultScreen(dpy), opt_font);
    if (!xftfont) { err("font '%s' not found", opt_font); exit(1); }
#endif

#ifdef SHAPE
    shape = XShapeQueryExtension(dpy, &shape_event, &dummy);
#endif

    move_curs = XCreateFontCursor(dpy, XC_fleur);
    resize_curs = XCreateFontCursor(dpy, XC_plus);

    gv.function = GXcopy;
    gv.foreground = fg.pixel;
    gv.font = font->fid;
    string_gc = XCreateGC(dpy, root, GCFunction|GCForeground|GCFont, &gv);

    gv.foreground = bd.pixel;
    gv.line_width = opt_bw;
    border_gc = XCreateGC(dpy, root, GCFunction|GCForeground|GCLineWidth, &gv);

    gv.function = GXinvert;
    gv.subwindow_mode = IncludeInferiors;
    invert_gc = XCreateGC(dpy, root, GCFunction|GCSubwindowMode|GCLineWidth|GCFont, &gv);

    sattr.event_mask = ChildMask|ColormapChangeMask|ButtonMask;
    XChangeWindowAttributes(dpy, root, CWEventMask, &sattr);
}
