/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include "lib/switch-misc.h"

#define NAME_SIZE 80

void make_client_button(Window);
void raise_win_cb(Widget, XtPointer, XtPointer);
Widget toplevel, box;

int main(int argc, char **argv)
{
    toplevel = XtInitialize(argv[0], "Switch", NULL, 0, &argc, argv);
    box = XtVaCreateManagedWidget("box", boxWidgetClass, toplevel, NULL);

    dpy = XtDisplay(toplevel);
    root = DefaultRootWindow(dpy);
    wm_state = XInternAtom(dpy, "WM_STATE", False);

    update_clients(root, make_client_button, NULL);

    XtRealizeWidget(toplevel);
    XtMainLoop();
    return 0;
}

void make_client_button(Window w)
{
    Widget button;
    char buf[NAME_SIZE];

    get_wm_name(w, buf, sizeof buf);
    button = XtVaCreateManagedWidget(buf, commandWidgetClass, box, NULL);
    XtAddCallback(button, XtNcallback, raise_win_cb, (XtPointer)w);
}

void raise_win_cb(Widget w, XtPointer data, XtPointer call)
{
    raise_win((Window)data);
    exit(0);
}
