/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include "lib/panel-misc.h"

void make_cmd_button(char *, char *);
void fork_exec_cb(Widget, XtPointer, XtPointer);
Widget toplevel, box;

int main(int argc, char **argv)
{
    toplevel = XtInitialize(argv[0], "Panel", NULL, 0, &argc, argv);
    box = XtVaCreateManagedWidget("box", boxWidgetClass, toplevel, NULL);
    add_cmd_buttons(make_cmd_button);

    XtRealizeWidget(toplevel);
    XtMainLoop();
    return 0;
}

void make_cmd_button(char *label, char *cmd)
{
    Widget button = XtVaCreateManagedWidget(label,
        commandWidgetClass, box, NULL);
    XtAddCallback(button, XtNcallback, fork_exec_cb, cmd);
}

void fork_exec_cb(Widget w, XtPointer data, XtPointer call)
{
    fork_exec(data);
    exit(0);
}
