/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <signal.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include "lib/panel-misc.h"
#include "lib/switch-misc.h"
#include "lib/palette-misc.h"

#define NAME_SIZE 40

void make_cmd_button(char *, char *);
void make_client_button(Window);
void remove_client_button(Window);
void update_client_button(Window);
void watch_window(Window, long);
void check_event(Widget, XtPointer, XEvent *, Boolean *);
int ignore_xerror(Display *, XErrorEvent *);
void fork_exec_cb(Widget, XtPointer, XtPointer);
void raise_win_cb(Widget, XtPointer, XtPointer);
void quit_cb(Widget, XtPointer, XtPointer);

Widget clients_box, menu, dummy;

int main(int argc, char **argv)
{
    Widget toplevel, paned, menu_button, cmds_box, quit_button;
    struct sigaction act;

    act.sa_handler = sig_handler;
    act.sa_flags = 0;
    sigaction(SIGCHLD, &act, NULL);

    toplevel = XtInitialize(argv[0], "Palette", NULL, 0, &argc, argv);
    dpy = XtDisplay(toplevel);
    root = DefaultRootWindow(dpy);
    wm_state = XInternAtom(dpy, "WM_STATE", False);
    client_tab = XUniqueContext();
    XSetErrorHandler(ignore_xerror);

    dummy = XtVaCreateWidget("dummy",
        coreWidgetClass, toplevel, XtNwidth, 1, XtNheight, 1, NULL);
    watch_window(root, SubstructureNotifyMask);
    XtAddRawEventHandler(dummy,
        SubstructureNotifyMask|StructureNotifyMask|PropertyChangeMask,
        False, check_event, NULL);

    paned = XtVaCreateManagedWidget("paned",
        panedWidgetClass, toplevel, NULL);
    cmds_box = XtVaCreateManagedWidget("commands",
        boxWidgetClass, paned, NULL);
    menu_button = XtVaCreateManagedWidget("Menu",
        menuButtonWidgetClass, cmds_box, NULL);
    menu = XtVaCreatePopupShell("menu",
        simpleMenuWidgetClass, menu_button, NULL);
    quit_button = XtVaCreateManagedWidget("Quit",
        commandWidgetClass, cmds_box, NULL);
    XtAddCallback(quit_button,
        XtNcallback, quit_cb, NULL);
    clients_box = XtCreateManagedWidget("clients",
        boxWidgetClass, paned, NULL, 0);

    add_cmd_buttons(make_cmd_button);
    update_clients(root, make_client_button, update_client_button);

    XtRealizeWidget(toplevel);
    XtMainLoop();
    return 0;
}

void make_cmd_button(char *label, char *cmd)
{
    Widget menu_item = XtVaCreateManagedWidget(label, smeBSBObjectClass, menu, NULL);
    XtAddCallback(menu_item, XtNcallback, fork_exec_cb, cmd);
}

void make_client_button(Window w)
{
    Widget button;
    char buf[NAME_SIZE];

    get_wm_name(w, buf, sizeof buf);

    button = XtVaCreateManagedWidget(buf, commandWidgetClass, clients_box, NULL);
    XtAddCallback(button, XtNcallback, raise_win_cb, (XtPointer)w);

    XSaveContext(dpy, w, client_tab, (XPointer)button);
    watch_window(w, StructureNotifyMask|PropertyChangeMask);
}

void remove_client_button(Window w)
{
    Widget button;

    if (XFindContext(dpy, w, client_tab, (XPointer*)&button) == Success) {
        XtDestroyWidget(button);
        XDeleteContext(dpy, w, client_tab);
    }
}

void update_client_button(Window w)
{
    Widget button;
    char buf[NAME_SIZE];

    if (get_wm_state(w) == WithdrawnState) {
        remove_client_button(w);
    } else if (XFindContext(dpy, w, client_tab, (XPointer*)&button) == Success) {
        get_wm_name(w, buf, sizeof buf);
        XtVaSetValues(button, XtNlabel, buf, NULL);
    }
}

void watch_window(Window w, long mask)
{
    XtRegisterDrawable(dpy, w, dummy);
    XSelectInput(dpy, w, mask);
}

void check_event(Widget w, XtPointer data, XEvent *e, Boolean *dispatch)
{
    switch (e->type) {
        case MapNotify:
            update_clients(e->xmap.window, make_client_button, update_client_button);
            break;
        case PropertyNotify:
            update_clients(e->xproperty.window, make_client_button, update_client_button);
            break;
        case DestroyNotify:
            remove_client_button(e->xdestroywindow.window);
            break;
    }
}

/* icky icky icky */

int ignore_xerror(Display *dpy, XErrorEvent *e)
{
    return 0;
}

void fork_exec_cb(Widget w, XtPointer data, XtPointer call)
{
    fork_exec(data);
}

void raise_win_cb(Widget w, XtPointer data, XtPointer call)
{
    raise_win((Window)data);
}

void quit_cb(Widget w, XtPointer data, XtPointer call)
{
    exit(0);
}
