/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

Display *dpy;
Window root;
Atom wm_state;
XContext client_tab;

long get_wm_state(Window w)
{
    Atom real_type; int real_format;
    unsigned long items_read, items_left;
    long *data, state = WithdrawnState;

    if (XGetWindowProperty(dpy, w, wm_state, 0L, 2L, False,
            wm_state, &real_type, &real_format, &items_read, &items_left,
            (unsigned char **) &data) == Success && items_read) {
        state = *data;
        XFree(data);
    }
    return state;
}

void get_wm_name(Window w, char *buf, size_t len)
{
    char *name;

    XFetchName(dpy, w, &name);
    if (!name) { buf[0] = '\0'; return; }

    if (get_wm_state(w) == NormalState) {
        if (strlen(name) >= len) strcpy(name+len-4, "...");
        strcpy(buf, name);
    } else {
        if (strlen(name) >= len-2) strcpy(name+len-6, "...");
        sprintf(buf, "(%s)", name);
    }

    XFree(name);
}

/* 'root' here as in the root of the subtree. we'll sometimes get
 * passed a WM frame so we have to search downwards until we find a
 * client window. If we don't want to check for existing but changed
 * windows then pass in NULL for update_client_button(). */

void update_clients(Window root, void (*make_client_button)(Window),
    void (*update_client_button)(Window))
{
    Window dummy_w, *wins;
    unsigned int i, nwins;
    XPointer dummy_p;

    if (update_client_button
            && XFindContext(dpy, root, client_tab, &dummy_p) == Success) {
        update_client_button(root);
    } else if (get_wm_state(root) != WithdrawnState) {
        make_client_button(root);
    } else if (XQueryTree(dpy, root, &dummy_w, &dummy_w, &wins, &nwins)) {
        for (i = 0; i < nwins; i++)
            update_clients(wins[i], make_client_button, update_client_button);
        XFree(wins);
    }
}

void raise_win(Window w)
{
    XMapRaised(dpy, w);
    XSync(dpy, False);
}
