/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <string.h>
#include <gtk/gtk.h>
#include "lib/panel-misc.h"

#define SPACING 4

void make_cmd_button(char *, char *);
void fork_exec_cb(GtkWidget *, char *);
GtkWidget *window, *box;

int main(int argc, char **argv)
{
    gtk_init(&argc, &argv);
    window = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_container_set_border_width(GTK_CONTAINER(window), SPACING);
    gtk_signal_connect(GTK_OBJECT(window), "destroy",
        GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

    box = gtk_vbox_new(FALSE, SPACING);
    gtk_container_add(GTK_CONTAINER(window), box);
    add_cmd_buttons(make_cmd_button);

    gtk_widget_show_all(window);
    gtk_main();
    return 0;
}

void make_cmd_button(char *label, char *cmd)
{
    GtkWidget *button = gtk_button_new_with_label(label);

    gtk_signal_connect(GTK_OBJECT(button), "clicked",
        GTK_SIGNAL_FUNC(fork_exec_cb), cmd);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
        GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
    gtk_box_pack_start(GTK_BOX(box), button, FALSE, FALSE, 0);
}

void fork_exec_cb(GtkWidget *widget, char *data)
{
    fork_exec(data);
    gtk_main_quit();
}
