/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include "lib/panel-misc.h"
#include "lib/menu-misc.h"

void add_menu_item(menu_t menu, char *label, char *cmd); 
menu_t add_sub_menu(menu_t menu, char *label);
void fork_exec_cb(GtkWidget *widget, char *data);

int main(int argc, char **argv)
{
    GtkWidget *rootmenu;

    gtk_init(&argc, &argv);
    dpy = GDK_DISPLAY();

    rootmenu = gtk_menu_new();
    build_menu(rootmenu, add_menu_item, add_sub_menu);
    gtk_signal_connect_object(GTK_OBJECT(rootmenu), "deactivate",
        GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
    gtk_menu_popup(GTK_MENU(rootmenu), NULL, NULL, NULL, NULL, 0, 0);

    gtk_main();
    return 0;
}

void add_menu_item(menu_t menu, char *label, char *cmd) 
{
    GtkWidget *item;

    item = gtk_menu_item_new_with_label(label);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
        GTK_SIGNAL_FUNC(fork_exec_cb), cmd);
    gtk_widget_show(item);
}

menu_t add_sub_menu(menu_t menu, char *label)
{
    GtkWidget *item, *newmenu;

    newmenu = gtk_menu_new();
    item = gtk_menu_item_new_with_label(label);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), newmenu);
    gtk_widget_show(item);

    return newmenu;
}

void fork_exec_cb(GtkWidget *widget, char *data)
{
    fork_exec(data);
    gtk_main_quit();
}
