/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Xatom.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Cardinals.h>

#ifndef BUFSIZ
#define BUFSIZ 2048
#endif

extern struct _app_resources
{
  Boolean enableBackups;
  char *backupNamePrefix;
  char *backupNameSuffix;
}
app_resources;

typedef enum
{
  NO_READ, READ_OK, WRITE_OK
}
FileAccess;

extern void Feep ();

extern void XeditPrintf (char *buf);
extern Widget MakeCommandButton ();
extern Widget MakeStringBox ();
extern String GetString ();
extern FileAccess MaybeCreateFile (), CheckFilePermissions ();

extern void DoQuit ();
extern void DoSave ();
extern void DoLoad ();

extern void mainxedit (Widget top);

extern int xedit_newfile (char *filename);
