/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "xedit.h"
#include "../param.h"

static XtActionsRec actions[] = {
  {"quit", DoQuit}
};

static Atom wm_delete_window;

Widget textwindow, messwidget, labelwindow, filenamewindow;

void ResetSourceChanged ();

static void makeButtonsAndBoxes ();

Display *CurDpy;

struct _app_resources app_resources;

#define Offset(field) XtOffsetOf(struct _app_resources, field)

static XtResource resources[] = {
  {"enableBackups", "EnableBackups", XtRBoolean, sizeof (Boolean),
   Offset (enableBackups), XtRImmediate, FALSE}
  ,
  {"backupNamePrefix", "BackupNamePrefix", XtRString, sizeof (char *),
   Offset (backupNamePrefix), XtRString, ""},
  {"backupNameSuffix", "BackupNameSuffix", XtRString, sizeof (char *),
   Offset (backupNameSuffix), XtRString, ".BAK"}
};

#undef Offset

void
mainxedit (Widget top)
{
  CurDpy = XtDisplay (top);
  makeButtonsAndBoxes (top, NULL);
}

static void
makeButtonsAndBoxes (parent, filename)
     Widget parent;
     char *filename;
{
  Widget outer, b_row;
  Widget m_box, t_box, l_box;
  Arg arglist[10];
  Cardinal num_args;

  w_n = 0;
  w_dim (400, 600);
  w_inbord (0);
  w_arg (XtNdefaultDistance, 1);
  outer =
    XtCreateManagedWidget ("paned", formWidgetClass, parent, w_args, w_n);

  w_n = 0;
  w_dim (400, 20);
  w_rel (NULL, 0, 0);
  w_bord (0);
  w_inbord (0);
  w_noresize ();
  b_row =
    XtCreateManagedWidget ("buttons", boxWidgetClass, outer, w_args, w_n);
  {
    MakeCommandButton (b_row, "Close", DoQuit);
    MakeCommandButton (b_row, "Update", DoSave);
    MakeCommandButton (b_row, "Load", DoLoad);
    filenamewindow = MakeStringBox (b_row, "filename", filename);
  }

  w_n = 0;
  w_dim (400, 140);
  w_relh (NULL, 0);
  w_relv (b_row, 0);
  w_bord (0);
  w_inbord (0);
  w_noresize ();
  m_box =
    XtCreateManagedWidget ("Messages", formWidgetClass, outer, w_args, w_n);

  num_args = 0;
  XtSetArg (arglist[num_args], XtNwidth, 400);
  num_args++;
  XtSetArg (arglist[num_args], XtNheight, 140);
  num_args++;
  XtSetArg (arglist[num_args], XtNeditType, XawtextEdit);
  num_args++;
  messwidget = XtCreateManagedWidget ("messageWindow", asciiTextWidgetClass,
				      m_box, arglist, num_args);

  w_n = 0;
  w_dim (400, 20);
  w_relh (NULL, 0);
  w_relv (m_box, 0);
  w_bord (0);
  w_inbord (0);
  w_noresize ();
  l_box =
    XtCreateManagedWidget ("Labels", formWidgetClass, outer, w_args, w_n);

  num_args = 0;
  XtSetArg (arglist[num_args], XtNwidth, 400);
  num_args++;
  XtSetArg (arglist[num_args], XtNheight, 20);
  num_args++;
  if (filename != NULL)
    {
      XtSetArg (arglist[num_args], XtNlabel, filename);
      num_args++;
    }

  labelwindow = XtCreateManagedWidget ("ABVisual module", labelWidgetClass,
				       l_box, arglist, num_args);
  w_n = 0;
  w_dim (400, 460);
  w_relh (NULL, 0);
  w_relv (l_box, 0);
  w_bord (0);
  w_inbord (0);
  w_arg (XtNleft, XtChainLeft);
  w_arg (XtNtop, XtChainTop);
  w_arg (XtNbottom, XtChainBottom);
  w_arg (XtNright, XtChainRight);

  t_box = XtCreateManagedWidget ("Text", formWidgetClass, outer, w_args, w_n);

  num_args = 0;
  XtSetArg (arglist[num_args], XtNwidth, 400);
  num_args++;
  XtSetArg (arglist[num_args], XtNheight, 460);
  num_args++;
  XtSetArg (arglist[num_args], XtNfromVert, labelwindow);
  num_args++;
  XtSetArg (arglist[num_args], XtNvertDistance, 0);
  num_args++;
  XtSetArg (arglist[num_args], XtNtype, XawAsciiFile);
  num_args++;
  XtSetArg (arglist[num_args], XtNeditType, XawtextEdit);
  num_args++;
  textwindow = XtCreateManagedWidget ("editWindow", asciiTextWidgetClass,
				      t_box, arglist, num_args);
  w_n = 0;
  w_bONw ();
  w_set (textwindow);

  if (filename != NULL)
    DoLoad ();
  else
    ResetSourceChanged (textwindow);
}

void
Feep ()
{
  XBell (CurDpy, 0);
}
