/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdio.h>
#include "mainwin.h"
#include "worksheet.h"
#include "memory.h"
#include <X11/keysym.h>

#include "callback.h"
#include "buildall.h"
#include "popnindex.h"
#include "gr_interf.h"

extern int lindrag (double l);
extern int coldrag (double l);

static XtActionsRec actionsTable[] = {
  {"DocBtn1Up", cb_DocBtn1Up},
  {"PopDown", cb_popdown},
  {"DocMotion", cb_DocMotion},
  {"DocBtn1Motion", cb_DocBtn1Motion},
  {"DocBtn1Down", cb_DocBtn1Down},
  {"DocBtn2Up", cb_DocBtn2Up},
  {"DocBtn2Motion", cb_DocBtn2Motion},
  {"DocBtn2Down", cb_DocBtn2Down},
  {"DocUp", cb_TextUp},
  {"DocDown", cb_TextDown},
  {"DocLeft", cb_TextLeft},
  {"DocRight", cb_TextRight},
  {"TextBtn1Up", cb_TextChange},
  {"TextReturn", cb_TextReturn},
  {"TextUp", cb_TextUp},
  {"TextDown", cb_TextDown},
  {"TextLeft", cb_TextLeft},
  {"TextRight", cb_TextRight},
  {"DocBtn3Up", cb_DocBtn3Up},
  {"Delete", cb_Delete},
  {"DocDelete", cb_DocDelete},
  {"BackSpace", cb_BackSpace},
  {"PageUp", cb_PageUp},
  {"PageDown", cb_PageDown},
  {"PageLeft", cb_PageLeft},
  {"PageRight", cb_PageRight},
  {"PageHome", cb_PageHome},
  {"Break", cb_Break},
};
static char defaultTranslations[] = "\
<Btn1Up>:     DocBtn1Up()\n\
<Btn1Motion>: DocBtn1Motion()\n\
<Btn2Up>:     DocBtn2Up()\n\
<Btn2Motion>: DocBtn2Motion()\n\
<Motion>:    DocMotion()\n\
<Btn1Down>:  PopDown() DocBtn1Down()\n\
<Btn2Down>:  PopDown() DocBtn2Down()\n\
<Btn3Down>:  PopDown()\n\
<Key>Delete: DocDelete() \n\
<Key>Page_Up: PageUp() \n\
<Key>Page_Down: PageDown() \n\
Shift<Key>Tab: PageLeft() \n\
<Key>Tab: PageRight() \n\
<Key>Home: PageHome() \n\
<Key>Up:    DocUp() \n\
<Key>Down:  DocDown() \n\
<Key>Left:  DocLeft() \n\
<Key>Right:  DocRight() \n\
Ctrl<Key>B: Break() \n\
";

static char textTranslations[] = "\
<Key>Return:   TextReturn(%d)\n\
<Key>KP_Enter:   TextReturn(%d)\n\
<Key>osfUp:    TextUp() \n\
<Key>osfDown:   TextDown() \n\
<Key>osfLeft:   TextLeft() \n\
<Key>osfRight:   TextRight() \n\
<Key>Up:    TextUp() \n\
<Key>Down:  TextDown() \n\
<Key>Left:  TextLeft() \n\
<Key>Right:  TextRight() \n\
<Key>BackSpace: BackSpace() \n\
<Key>Delete: Delete() \n\
<Btn1Up>:     TextBtn1Up()\n\
<Key>Home: PageHome() \n\
<Key>Up:    DocUp() \n\
<Key>Page_Up: PageUp() \n\
<Key>Page_Down: PageDown() \n\
Shift<Key>Tab: PageLeft() \n\
<Key>Tab: PageRight() \n\
";

static char popupTranslations[] = "\
<Motion>:       unhighlight() highlight()\n\
<Btn1Up>:           PopDown() notify() unhighlight()\n\
";

Mainwin *ActiveMainwin = NULL;

void
scrollv (v)
     int v;
{
  double V = v;
  if (!BatchMode)
    lindrag (V);
  return;
}

void
scrollh (v)
     int v;
{
  double V = v;
  if (!BatchMode)
    coldrag (V);
  return;
}

void
setscrollv (double v)
{
  if (BatchMode)
    return;
  setscrollval (ActiveMainwin->scrollv, v);

}

void
setscrollh (double v)
{
  if (!BatchMode)
    setscrollval (ActiveMainwin->scrollh, v);
}

void
setscrollvlimit (vmin, vmax)
     int vmin, vmax;
{
  if (BatchMode)
    return;

  setscrolllimit (ActiveMainwin->scrollv, vmin, vmax);
}

void
setscrollhlimit (vmin, vmax)
     int vmin, vmax;
{
  if (!BatchMode)
    setscrolllimit (ActiveMainwin->scrollh, vmin, vmax);
}

extern GC getTheGc ();
extern Pixel getforeground ();
extern Pixel getbackground ();

int
popupcell (int dx, int dy, int w, int h)
{
  w_n = 0;
  if (BatchMode)
    return 0;
  XtSetArg (w_args[w_n], XtNforeground,
	    (Pixel) getcolor (cell_getfg (ActiveCell)));
  w_n++;
  XtSetArg (w_args[w_n], XtNbackground,
	    (Pixel) getcolor (cell_getbg (ActiveCell)));
  w_n++;
  XtSetArg (w_args[w_n], XtNfont,
	    (XFontStruct *) font2fontstr (cell_getfont (ActiveCell),
					  cell_getfontw (ActiveCell),
					  cell_getfonts (ActiveCell)));
  w_n++;

  w_rel (NULL, dx + 40, dy + 20);
  w_dim (w, h);
  XtSetValues (ActiveMainwin->cell, w_args, w_n);
  XtManageChild (ActiveMainwin->cell);
  return 0;
}

int
LetextLooseFocus ()
{
  if (ActiveMainwin == NULL)
    return 0;
  XtSetSensitive (ActiveMainwin->commandline_obj->text, False);
  XtSetKeyboardFocus (ActiveMainwin->toplevel, ActiveMainwin->draw);
  XawTextDisplayCaret (ActiveMainwin->commandline_obj->text, False);
  return 0;
}

int
LetextGetFocus ()
{
  if (ActiveMainwin == NULL)
    return 0;

  XtSetSensitive (ActiveMainwin->commandline_obj->text, True);
  XtSetKeyboardFocus (ActiveMainwin->toplevel,
		      ActiveMainwin->commandline_obj->text);
  XawTextDisplayCaret (ActiveMainwin->commandline_obj->text, True);
  return 0;
}

int
mainwin_inform (char *str)
{
  Arg arglist[1];
  if (BatchMode)
    return 0;
  XtSetArg (arglist[0], XtNstring, str);
  XtSetValues (ActiveMainwin->commandline_obj->info, arglist, 1);
  return 0;
}

Display *
mainwin_drawdpy ()
{
  if (BatchMode)
    return NULL;
  else
    return XtDisplay (ActiveMainwin->draw);
}

int
popdowncell ()
{
  if (BatchMode)
    return 0;
  XtUnmanageChild (ActiveMainwin->cell);
  return 0;
}

Widget make_cell (Widget parent, char *name)
{
  Widget entry;
  w_n = 0;
  XtSetArg (w_args[w_n], XtNeditType, XawtextEdit);
  w_n++;
  XtSetArg (w_args[w_n], XtNborderWidth, 1);
  w_n++;
  XtSetArg (w_args[w_n], XtNbackground, abswhite);
  w_n++;
  XtSetArg (w_args[w_n], XtNforeground, absblack);
  w_n++;
  w_dim (50, 18);
  w_rel (NULL, 0, 0);
  entry =
    XtCreateManagedWidget ("Cell", asciiTextWidgetClass, parent, w_args, w_n);
  XawTextDisplayCaret (entry, False);

  return entry;
}

void
mainwin_resize (widget, pointer, event, ctd)
     Widget widget;
     XtPointer pointer;
     XEvent *event;
     Boolean *ctd;
{
  int n;
  Dimension h, w;
  Widget wi;
  Arg args[2];
  wi = (Widget) pointer;

  n = 0;
  XtSetArg (args[n], XtNheight, &h);
  n++;
  XtSetArg (args[n], XtNwidth, &w);
  n++;
  XtGetValues (wi, args, n);
  cb_resize (w, h);
}

Mainwin *
newmainwin (Widget top)
{
  XtTranslations trans_table;
  XtTranslations text_trans_table;
  XtTranslations popup_trans_table;
  Mainwin *mainwin =
    (Mainwin *) absmalloc (sizeof (Mainwin), "newmainwin:mainwin");
  ActiveMainwin = mainwin;

  mainwin->toplevel = top;
  mainwin->dpy = XtDisplay (top);
  w_n = 0;
  w_dim (800, 600);
  w_inbord (0);
  w_arg (XtNdefaultDistance, 1);
  mainwin->baseform = XtCreateManagedWidget
    ("main_window", formWidgetClass, mainwin->toplevel, w_args, w_n);

  w_n = 0;
  w_dim (800, 20);
  w_rel (NULL, 0, 0);
  w_bord (0);
  w_inbord (0);
  w_noresize ();
  mainwin->menubar = XtCreateManagedWidget
    ("menubar", boxWidgetClass, mainwin->baseform, w_args, w_n);
  mainwin->menubar_obj = (Menubar *) newmenubar (mainwin->menubar);

  XtAddEventHandler (mainwin->menubar, ExposureMask, FALSE, shadow,
		     (XtPointer) mainwin->menubar);

  w_n = 0;
  w_dim (800, 20);
  w_relh (NULL, 0);
  w_relv (mainwin->menubar, 0);
  w_bord (0);
  w_inbord (0);
  w_noresize ();
  mainwin->buttonbar = XtCreateManagedWidget
    ("buttonbar", boxWidgetClass, mainwin->baseform, w_args, w_n);
  XtAddEventHandler (mainwin->buttonbar, ExposureMask, FALSE, shadow,
		     (XtPointer) mainwin->buttonbar);
  mainwin->buttonbar_ismanaged = 1;

  w_n = 0;
  w_dim (800, 20);
  w_relh (NULL, 0);
  w_relv (mainwin->buttonbar, 0);
  w_bord (0);
  w_inbord (0);
  w_noresize ();
  mainwin->formatbar = XtCreateManagedWidget
    ("formatbar", boxWidgetClass, mainwin->baseform, w_args, w_n);
  XtAddEventHandler (mainwin->formatbar, ExposureMask, FALSE, shadow,
		     (caddr_t) mainwin->formatbar);
  mainwin->formatbar_ismanaged = 1;

  w_n = 0;
  w_dim (800, 25);
  w_relh (NULL, 0);
  w_relv (mainwin->formatbar, 0);
  w_bord (0);
  w_novresize ();
  w_hresize ();
  w_arg (XtNright, XtChainRight);
  mainwin->commandline = XtCreateManagedWidget
    ("commandline", formWidgetClass, mainwin->baseform, w_args, w_n);

  mainwin->commandline_obj = newcommandline (mainwin->commandline);

  w_n = 0;
  w_relh (NULL, 0);
  w_relv (mainwin->commandline, 0);
  w_bord (0);
  w_arg (XtNleft, XtChainLeft);
  w_arg (XtNtop, XtChainTop);
  w_arg (XtNbottom, XtChainBottom);
  w_arg (XtNright, XtChainRight);
  w_arg (XtNdefaultDistance, 0);

  mainwin->wbform =
    (Widget) XtCreateManagedWidget ("window", formWidgetClass,
				    mainwin->baseform, w_args, w_n);
  XtAddEventHandler (mainwin->wbform, ExposureMask, FALSE, shadow,
		     (XtPointer) mainwin->wbform);
  XtAddEventHandler (mainwin->wbform, StructureNotifyMask, False,
		     mainwin_resize, (XtPointer) mainwin->wbform);

  w_n = 0;
  w_dim (40, 20);
  w_rel (NULL, 0, 0);
  w_bord (0);
  w_noresize ();
  mainwin->corner =
    (Widget) XtCreateManagedWidget ("window", simpleWidgetClass,
				    mainwin->wbform, w_args, w_n);

  w_n = 0;
  w_dim (40, 510);
  w_relh (NULL, 0);
  w_relv (mainwin->corner, 0);
  w_bord (0);
  w_nohresize ();
  w_vresize ();
  w_arg (XtNtop, XtChainTop);
  mainwin->linindex =
    (Widget) XtCreateManagedWidget ("window", panedWidgetClass,
				    mainwin->wbform, w_args, w_n);

  w_n = 0;
  w_dim (774, 20);
  w_relv (NULL, 0);
  w_relh (mainwin->corner, 0);
  w_bord (0);
  w_novresize ();
  w_hresize ();
  w_arg (XtNleft, XtChainLeft);
  mainwin->colindex =
    (Widget) XtCreateManagedWidget ("window", panedWidgetClass,
				    mainwin->wbform, w_args, w_n);

  w_n = 0;
  w_dim (774, 510);
  w_relv (mainwin->colindex, 0);
  w_relh (mainwin->linindex, 0);
  w_bord (0);
  w_hresize ();
  w_vresize ();
  mainwin->draw =
    (Widget) XtCreateManagedWidget ("window", panedWidgetClass,
				    mainwin->wbform, w_args, w_n);

  w_n = 0;
  w_relv (mainwin->commandline, 0);
  w_relh (mainwin->wbform, 1);
  w_bord (0);
  w_arg (XtNtop, XtChainTop);
  w_arg (XtNleft, XtChainRight);
  w_arg (XtNright, XtChainRight);
  w_arg (XtNbottom, XtChainBottom);
  w_arg (XtNdefaultDistance, 1);
  mainwin->scrollv =
    CreateMyscroll (mainwin->baseform, 528, 14, 0, 400, scrollv);

  w_n = 0;
  w_dim (80, 20);
  w_relh (NULL, 0);
  w_relv (mainwin->wbform, 0);
  w_bord (0);
  w_inbord (0);
  w_arg (XtNdefaultDistance, 0);
  w_arg (XtNtop, XtChainBottom);
  w_arg (XtNbottom, XtChainBottom);
  w_arg (XtNleft, XtChainLeft);
  w_arg (XtNright, XtChainLeft);
  mainwin->sheetbtn =
    XtCreateManagedWidget ("window", formWidgetClass, mainwin->baseform,
			   w_args, w_n);

  w_n = 0;
  w_dim (320, 20);
  w_relh (NULL, 80);
  w_relv (mainwin->wbform, 0);
  w_bord (0);
  w_inbord (0);
  w_arg (XtNtop, XtChainBottom);
  w_arg (XtNbottom, XtChainBottom);
  w_arg (XtNleft, XtChainLeft);
  w_arg (XtNright, XtChainLeft);
  mainwin->sheetselform =
    XtCreateManagedWidget ("window", formWidgetClass, mainwin->baseform,
			   w_args, w_n);
  build_thumb (mainwin->sheetselform);

  w_n = 0;
  w_relv (mainwin->wbform, 1);
  w_relh (NULL, 453);
  w_bord (0);
  w_arg (XtNtop, XtChainBottom);
  w_arg (XtNbottom, XtChainBottom);
  w_arg (XtNleft, XtChainLeft);
  w_arg (XtNright, XtChainRight);
  w_arg (XtNdefaultDistance, 1);
  mainwin->scrollh =
    CreateMyscroll (mainwin->baseform, 14, 350, 0, NB_COLUMN, scrollh);

  mainwin->buttonbar_obj = newbuttonbar (mainwin->buttonbar);
  mainwin->formatbar_obj = newformatbar (mainwin->formatbar);

  mainwin->popup = (Widget) make_alone_popup (mainwin->wbform, "pop1");

  XtAddEventHandler (mainwin->draw, ExposureMask, FALSE, event_Repaint, NULL);
  XtAddEventHandler (mainwin->draw, StructureNotifyMask, FALSE, event_Repaint,
		     NULL);

  XtAppAddActions (XtWidgetToApplicationContext (mainwin->toplevel),
		   actionsTable, XtNumber (actionsTable));

  trans_table = XtParseTranslationTable (defaultTranslations);
  text_trans_table = XtParseTranslationTable (textTranslations);
  popup_trans_table = XtParseTranslationTable (popupTranslations);

  XtOverrideTranslations (mainwin->commandline_obj->text, text_trans_table);

  XtOverrideTranslations (mainwin->popup, popup_trans_table);

  XtOverrideTranslations (mainwin->draw, trans_table);
  XtOverrideTranslations (mainwin->linindex, trans_table);
  XtOverrideTranslations (mainwin->colindex, trans_table);
  XtOverrideTranslations (mainwin->corner, trans_table);

  XtAddEventHandler (mainwin->draw, ButtonReleaseMask, True, event_DocBtn3Up,
		     (XtPointer) mainwin->popup);

  XtAddEventHandler (mainwin->commandline_obj->text, KeyReleaseMask, True,
		     event_KeyReleased, mainwin->commandline_obj->text);
  XtAddEventHandler (mainwin->commandline_obj->text, KeyPressMask, True,
		     event_KeyPressed, mainwin->commandline_obj->text);
  XtAddEventHandler (mainwin->draw, KeyReleaseMask, True,
		     event_KeyReleased, mainwin->commandline_obj->text);
  XtAddEventHandler (mainwin->draw, KeyPressMask, True,
		     event_KeyPressed, mainwin->commandline_obj->text);

  XtRealizeWidget (mainwin->toplevel);

  mainwin->cell = make_cell (mainwin->wbform, "Cell");
  popdowncell ();

  return mainwin;
}

int
mainwin_popup_abv ()
{
  XtManageChild (ActiveMainwin->abv_editor);
  return 0;
}

int
mainwin_popdown_abv ()
{
  XtUnmanageChild (ActiveMainwin->abv_editor);
  return 0;
}

void
buttonbar_onoff ()
{
  if (ActiveMainwin == NULL)
    return;

  if (ActiveMainwin->buttonbar_ismanaged)
    {
      XtUnmanageChild (ActiveMainwin->buttonbar);
      ActiveMainwin->buttonbar_ismanaged = 0;

      w_n = 0;
      w_relv (ActiveMainwin->menubar, 0);
      if (ActiveMainwin->formatbar_ismanaged)
	{
	  w_set (ActiveMainwin->formatbar);
	}
      else
	{
	  w_set (ActiveMainwin->commandline);
	}
    }
  else
    {
      XtManageChild (ActiveMainwin->buttonbar);
      ActiveMainwin->buttonbar_ismanaged = 1;
      w_n = 0;
      w_relv (ActiveMainwin->buttonbar, 0);
      if (ActiveMainwin->formatbar_ismanaged)
	{
	  w_set (ActiveMainwin->formatbar);
	}
      else
	{
	  w_set (ActiveMainwin->commandline);
	}
    }

}
void
formatbar_onoff ()
{
  if (ActiveMainwin == NULL)
    return;
  if (ActiveMainwin->formatbar_ismanaged)
    {
      XtUnmanageChild (ActiveMainwin->formatbar);
      ActiveMainwin->formatbar_ismanaged = 0;
      w_n = 0;
      if (ActiveMainwin->buttonbar_ismanaged)
	{
	  w_relv (ActiveMainwin->buttonbar, 0);
	}
      else
	{
	  w_relv (ActiveMainwin->menubar, 0);
	}
      w_set (ActiveMainwin->commandline);
    }
  else
    {
      ActiveMainwin->formatbar_ismanaged = 1;
      XtManageChild (ActiveMainwin->formatbar);
      w_relv (ActiveMainwin->formatbar, 0);
      w_set (ActiveMainwin->commandline);
    }

}

void
NewWindow ()
{
  ActiveMainwin = newmainwin ((Widget) gettop ());
}

void
event_KeyPressed (Widget widget, XtPointer pointer, XEvent * event,
		  Boolean * ctd)
{

  switch (event->xkey.keycode)
    {
    case 50:
      cb_Shift (1);
      break;
    case 62:
      cb_Shift (2);
      break;
    case 37:
      cb_Control (1);
      break;

    }

}

void
event_KeyReleased (Widget widget, XtPointer pointer, XEvent * event,
		   Boolean * ctd)
{

  if (event->xkey.keycode >= 67 && event->xkey.keycode <= 76)
    return;
  switch (event->xkey.keycode)
    {
    case 50:
      cb_Shift (0);
    case 62:
      cb_Shift (0);
    case 37:
      cb_Control (0);
    case 95:
    case 96:
    case 111:
    case 115:
    case 117:
    case 9:
    case 23:
    case 66:
    case 64:
    case 113:
    case 106:
    case 107:
      return;

    }
  KeyPressed ();
}
