/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdio.h>

#include "param.h"
#include "workbook.h"
#include "macrodialog.h"
#include "gr_interf.h"
#include "memory.h"

static Widget macropromptShell = NULL;
static Widget macropromptDialog;
static Widget list;

static void (*macropromptfunction) ();

extern Widget gettop ();

static char **macrolist;

void
MacroCancelAction (Widget widget, XtPointer closure, XtPointer call_data)
{
  if (macropromptShell)
    {
      XtPopdown (macropromptShell);

      freemacrolist ();
    }
  reactivate_zoom ();
}

void
MacroAcceptAction (Widget widget, XtPointer closure, XtPointer call_data)
{

  int macronum;

  XawListReturnStruct *selected = XawListShowCurrent (list);
  macronum = selected->list_index;
  MacroCancelAction (widget, closure, call_data);
  playmacro (ActiveWorkbook->project, macronum);

}

void
MacroPlayAction (Widget widget, XtPointer closure, XtPointer call_data)
{
  int macronum;

  XawListReturnStruct *selected = XawListShowCurrent (list);
  macronum = selected->list_index;
  playmacro (ActiveWorkbook->project, macronum);

}

void
MacroEditAction (Widget widget, XtPointer closure, XtPointer call_data)
{
  int macronum;

  XawListReturnStruct *selected = XawListShowCurrent (list);
  macronum = selected->list_index;
  MacroCancelAction (widget, closure, call_data);
  editmacro (ActiveWorkbook->project, macronum);
}

void
MacroMakePrompt (Widget centerw, char *prompt, void (*func) (), char *def)
{

  Arg centerArgs[2];
  Arg args[20];
  int n;
  Position source_x, source_y;
  Position dest_x, dest_y;
  Dimension center_width, center_height;
  Dimension prompt_width, prompt_height;

  Widget cancel, ok, play, edit, viewport1, box;

  desactivate_zoom ();

  if (macropromptShell == NULL)
    {
      n = 0;
      XtSetArg (args[n], XtNinput, True);
      n++;
      XtSetArg (args[n], XtNwidth, 330);
      n++;
      XtSetArg (args[n], XtNheight, 450);
      n++;
      macropromptShell = XtCreatePopupShell
	("macropromptShell", transientShellWidgetClass, gettop (), args, 3);

      n = 0;
      XtSetArg (args[n], XtNwidth, 250);
      n++;
      XtSetArg (args[n], XtNheight, 350);
      n++;
      macropromptDialog =
	XtCreateManagedWidget ("macropromptDialog", formWidgetClass,
			       macropromptShell, args, n);
      n = 0;
      XtSetArg (args[n], XtNwidth, 250);
      n++;
      XtSetArg (args[n], XtNheight, 1);
      n++;
      XtSetArg (args[n], XtNborderWidth, 0);
      n++;
      box = XtCreateManagedWidget ("macropromptDialog", formWidgetClass,
				   macropromptDialog, args, n);
      n = 0;
      XtSetArg (args[n], XtNwidth, 1);
      n++;
      XtSetArg (args[n], XtNheight, 350);
      n++;
      XtSetArg (args[n], XtNborderWidth, 0);
      n++;
      box = XtCreateManagedWidget ("macropromptDialog", formWidgetClass,
				   macropromptDialog, args, n);

      w_n = 0;

      w_dim (160, 180);
      w_rel (NULL, 20, 30);
      XtSetArg (w_args[w_n], XtNuseRight, True);
      w_n++;
      XtSetArg (w_args[w_n], XtNallowVert, True);
      w_n++;
      XtSetArg (w_args[w_n], XtNforceBars, True);
      w_n++;

      viewport1 = XtCreateManagedWidget ("viewport1",
					 viewportWidgetClass,
					 macropromptDialog, w_args, w_n);

      w_n = 0;

      XtSetArg (w_args[w_n], XtNdefaultColumns, 1);
      w_n++;
      XtSetArg (w_args[w_n], XtNforceColumns, True);
      w_n++;
      list = XtCreateManagedWidget ("list", listWidgetClass,
				    viewport1, w_args, w_n);

      w_n = 0;
      w_dim (85, 20);
      w_rel (NULL, 200, 45);
      play = XtCreateManagedWidget
	("Play", commandWidgetClass, macropromptDialog, w_args, w_n);
      XtAddCallback (play, XtNcallback, MacroPlayAction, NULL);

      w_n = 0;
      w_dim (85, 20);
      w_rel (NULL, 200, 80);
      ok = XtCreateManagedWidget
	("Play & Close", commandWidgetClass, macropromptDialog, w_args, w_n);
      XtAddCallback (ok, XtNcallback, MacroAcceptAction, NULL);

      w_n = 0;
      w_dim (85, 20);
      w_rel (NULL, 200, 115);
      edit = XtCreateManagedWidget
	("Edit", commandWidgetClass, macropromptDialog, w_args, w_n);
      XtAddCallback (edit, XtNcallback, MacroEditAction, NULL);

      w_n = 0;
      w_dim (85, 20);
      w_rel (NULL, 200, 150);
      cancel = XtCreateManagedWidget
	("Cancel", commandWidgetClass, macropromptDialog, w_args, w_n);
      XtAddCallback (cancel, XtNcallback, MacroCancelAction, NULL);

      XtRealizeWidget (macropromptShell);
    }

  XtSetArg (centerArgs[0], XtNwidth, &center_width);
  XtSetArg (centerArgs[1], XtNheight, &center_height);
  XtGetValues (centerw, centerArgs, 2);
  XtSetArg (centerArgs[0], XtNwidth, &prompt_width);
  XtSetArg (centerArgs[1], XtNheight, &prompt_height);
  XtGetValues (macropromptShell, centerArgs, 2);
  source_x = (int) (center_width - prompt_width) / 2;
  source_y = (int) (center_height - prompt_height) / 3;
  XtTranslateCoords (centerw, source_x, source_y, &dest_x, &dest_y);
  XtSetArg (centerArgs[0], XtNx, dest_x);
  XtSetArg (centerArgs[1], XtNy, dest_y);
  XtSetValues (macropromptShell, centerArgs, 2);

  XtPopup (macropromptShell, XtGrabNone);
  macropromptfunction = func;
  remake_macro_list ();
}

int
remake_macro_list ()
{
  int nmac = 0;
  int i;

  nmac = getnmacro (ActiveWorkbook->project);

  macrolist =
    (char **) absmalloc ((nmac + 2) * sizeof (char *),
			 "remake_macro_list:macrolist ");
  macrolist[0] = NULL;
  for (i = 0; i < nmac; i++)
    {
      macrolist[i] = (char *) getmacroname (ActiveWorkbook->project, i);

      macrolist[i + 1] = NULL;
    }

  XawListChange (list, macrolist, 0, 0, True);

  return 0;
}

int
freemacrolist ()
{

  if (macrolist != NULL)
    {

      absfree (macrolist, "freemacrolist:macrolist ");
    }
  return 0;
}
