/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <stdio.h>

#include "xgc.h"

extern XStuff X;
extern Widget topform;

static Widget popupshell = NULL;
Widget filename_text_widget;

extern XtAppContext appcontext;

static void kill_popup_shell ();

void
get_filename (success, failure)
     void (*success) ();

     void (*failure) ();

{
  static Widget popupform;
  static Widget label;
  static Widget cancel;

  Window dummy1, dummy2;
  int x1, y1, x2, y2;
  unsigned int mask;

  static char *translationtable = "Ctrl<Key>J:    KillPopup() Done()\n\
     Ctrl<Key>M:    KillPopup() Done()\n\
     <Key>Linefeed: KillPopup() Done()\n\
     <Key>Return:   KillPopup() Done()\n\
     Ctrl<Key>O:    Nothing()\n\
     Meta<Key>I:    Nothing()\n\
     Ctrl<Key>N:    Nothing()\n\
     Ctrl<Key>P:    Nothing()\n\
     Ctrl<Key>Z:    Nothing()\n\
     Meta<Key>Z:    Nothing()\n\
     Ctrl<Key>V:    Nothing()\n\
     Meta<Key>V:    Nothing()";

  static XtActionsRec actiontable[] = {
    {"KillPopup", (XtActionProc) kill_popup_shell},
    {"Done", NULL},
    {"Nothing", NULL}
  };

  static Arg popupshellargs[] = {
    {XtNx, (XtArgVal) NULL},
    {XtNy, (XtArgVal) NULL}
  };

  static Arg labelargs[] = {
    {XtNborderWidth, (XtArgVal) 0},
    {XtNjustify, (XtArgVal) XtJustifyRight}
  };

  static Arg textargs[] = {
    {XtNeditType, (XtArgVal) XawtextEdit},
    {XtNwidth, (XtArgVal) 200},
    {XtNhorizDistance, (XtArgVal) 10},
    {XtNfromHoriz, (XtArgVal) NULL},
  };

  static Arg cancelargs[] = {
    {XtNfromHoriz, (XtArgVal) NULL},
    {XtNcallback, (XtArgVal) NULL}
  };

  static XtCallbackRec cancelcallbacklist[] = {
    {(XtCallbackProc) kill_popup_shell, NULL},
    {NULL, NULL},
    {NULL, NULL}
  };

  if (popupshell != NULL)
    {
      XtPopup (popupshell, XtGrabExclusive);
      return;
    }

  (void) XQueryPointer (X.dpy, XtWindow (topform), &dummy1, &dummy2, &x1, &y1,
			&x2, &y2, &mask);

  popupshellargs[0].value = (XtArgVal) x2;
  popupshellargs[1].value = (XtArgVal) y2;

  popupshell = XtCreatePopupShell ("popup", overrideShellWidgetClass,
				   topform, popupshellargs,
				   XtNumber (popupshellargs));

  popupform = XtCreateManagedWidget ("form", formWidgetClass, popupshell,
				     NULL, 0);

  label = XtCreateManagedWidget ("Filename: ", labelWidgetClass, popupform,
				 labelargs, XtNumber (labelargs));

  textargs[3].value = (XtArgVal) label;

  filename_text_widget = XtCreateManagedWidget ("text", asciiTextWidgetClass,
						popupform,
						textargs,
						XtNumber (textargs));

  actiontable[1].proc = (XtActionProc) success;

  XtAppAddActions (appcontext, actiontable, XtNumber (actiontable));
  XtOverrideTranslations (filename_text_widget,
			  XtParseTranslationTable (translationtable));
  cancelcallbacklist[1].callback = (XtCallbackProc) failure;

  cancelargs[0].value = (XtArgVal) filename_text_widget;
  cancelargs[1].value = (XtArgVal) cancelcallbacklist;

  cancel = XtCreateManagedWidget ("Cancel", commandWidgetClass, popupform,
				  cancelargs, XtNumber (cancelargs));

  XtPopup (popupshell, XtGrabExclusive);
}

static void
kill_popup_shell ()
{
  XtPopdown (popupshell);
}
