/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "formatbar.h"
#include "entrypop.h"
#include "separ.xpm"
#include "justleft.xpm"
#include "justcenter.xpm"
#include "justright.xpm"

#include "notbold.xpm"

#include "notitalic.xpm"
#include "fit.xpm"
#include "memory.h"
#include "cblist.h"
#include "button.h"
#include "main.h"

static Entry_Pop *font;
static Entry_Pop *size;

void
justleft ()
{
  makejust (0);
}

void
justcenter ()
{
  makejust (1);
}

void
justright ()
{
  makejust (2);
}

void
cb_italic ()
{
  makefont (-1, 2, -1);
}

void
bold ()
{
  makefont (-1, 1, -1);
}

static struct buttonEntry FormatLineEntries[] = {
  {"separ", separ_xpm, NULL},
  {"Bold", notbold_xpm, bold},
  {"Italic", notitalic_xpm, cb_italic},
  {"separ", separ_xpm, NULL},
  {"justleft", justleft_xpm, justleft},
  {"justcenter", justcenter_xpm, justcenter},
  {"justright", justright_xpm, justright},
  {"fit", fit_xpm, formatcolumn},
  {"separ", separ_xpm, NULL},
};

static char *format_font[] = {
  "Fixed", "Courier", "Helvetica", "Times", "Symbol", NULL,
};

static char *format_fonts[] = {
  "6", "8", "10", "12", "14", "18", "24", NULL,
};

void
newfontvalue (widget, pointer, junk)
     Widget widget;
     XtPointer pointer;
     XtPointer junk;
{
  int i = 0;
  while (format_font[i] != NULL)
    {
      if (!strcmp (pointer, format_font[i]))
	{
	  makefont (i, -1, -1);
	  return;
	}
      i++;
    }
}

void
setfontlabel (int z)
{

}

void
newfontsizevalue (widget, pointer, junk)
     Widget widget;
     XtPointer pointer;
     XtPointer junk;
{
  int i = 0;
  while (format_fonts[i] != NULL)
    {
      if (!strcmp (pointer, format_fonts[i]))
	{
	  makefont (-1, -1, i);
	  return;
	}
      i++;
    }
}

void
setfontsizelabel (int z)
{

}

Formatbar *
newformatbar (formatbar)
     Widget formatbar;
{
  int i;
  Formatbar *bb_obj;
  bb_obj =
    (Formatbar *) absmalloc (sizeof (Formatbar), "newformatbar:bb_obj ");

  font = newentrypop (formatbar, "fontlist", popdown, 80, 20);
  entrypop_callback (font, newfontvalue);
  entrypop_add_items (font, format_font);
  entrypop_init_val (font, "Arial");
  size = newentrypop (formatbar, "sizelist", popdown, 30, 20);
  entrypop_callback (size, newfontsizevalue);
  entrypop_add_items (size, format_fonts);
  entrypop_init_val (size, "10");

  for (i = 0; i < XtNumber (FormatLineEntries); i++)
    make_button_pixmap (formatbar,
			FormatLineEntries[i].name,
			FormatLineEntries[i].pixmapname,
			FormatLineEntries[i].function, NULL);

  return bb_obj;
}
