/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifndef _HPUX_SOURCE
#include <dirent.h>
#define DIRSTRUCT struct dirent
#endif

#ifdef _HPUX_SOURCE
#define DIRSTRUCT struct direct
#include <sys/dir.h>
#ifndef S_IFDIR
#define S_IFDIR  0040000
#endif
#endif

#include <unistd.h>

#include "param.h"
#include "file_selector.h"
#include "memory.h"

#include "gr_interf.h"

static Widget promptShell = NULL;
static Widget promptDialog;
static Widget valueWidget;
static Widget dirvalueWidget;
static Widget filtervalueWidget;
static Widget list;
static Widget dirlist;

static char dialogTranslation[] = "\
<Key>Return: Accept()\n\
";

static XtActionsRec dialogactionsTable[] = {
  {"Accept", AcceptAction},
};

static void (*promptfunction) ();

extern Widget gettop ();

static char curdir[512];

static char **labels = NULL;
static char **dirlabels = NULL;

void
set_filename (Widget w, XtPointer closure, XtPointer call_data)
{
  Arg arglist[1];
  XawListReturnStruct *item = (XawListReturnStruct *) call_data;
  XtSetArg (arglist[0], XtNstring, item->string);
  XtSetValues (valueWidget, arglist, 1);

}

void
MakeFullPath (char *root, char *filename, char *pathname)
{
  strcpy (pathname, root);
  strcat (pathname, "/");
  strcat (pathname, filename);
}

void
change_dir (Widget w, XtPointer closure, XtPointer call_data)
{
  int len = strlen (curdir);

  XawListReturnStruct *item = (XawListReturnStruct *) call_data;

  if (strcmp (item->string, "..") == 0)
    {
      if (len <= 1)
	return;

      while (len > 1 && curdir[len - 1] == '/')
	len--;

      while (len > 1 && curdir[len - 1] != '/')
	len--;

      if (len > 1)
	{
	  curdir[len] = '\0';
	}
      else
	{
	  sprintf (curdir, "/");
	}

    }
  else
    {
      if (strcmp (item->string, ".") != 0)
	{
	  if (len > 1 && curdir[len - 1] != '/')
	    strcat (curdir, "/");
	  strcat (curdir, item->string);
	}
    }
  freelist ();
  remake_list ();
  w_n = 0;
  XtSetArg (w_args[w_n], XtNstring, curdir);
  w_n++;
  XtSetValues (dirvalueWidget, w_args, w_n);

}

void
cb_Cancel (Widget w, XtPointer client_data, XtPointer call_data)
{
  if (promptShell)
    {
      freelist ();
      XtPopdown (promptShell);
    }
  reactivate_zoom ();
}

void
CancelAction (Widget w, XEvent * event, String * params,
	      Cardinal * num_params)
{
  cb_Cancel (w, NULL, NULL);
}

void
cb_Rescan (Widget w, XtPointer client_data, XtPointer call_data)
{
  char *str;
  Arg arglist[1];
  XtSetArg (arglist[0], XtNstring, &str);
  XtGetValues (filtervalueWidget, arglist, 1);

  freelist ();
  remake_list ();
}

void
RescanAction (Widget w, XEvent * event, String * params,
	      Cardinal * num_params)
{
  cb_Rescan (w, NULL, NULL);
}

void
cb_Accept (Widget w, XtPointer client_data, XtPointer call_data)
{
  char *filename;
  char *str;
  Arg arglist[1];
  int len = 2;
  XtSetArg (arglist[0], XtNstring, &str);
  XtGetValues (valueWidget, arglist, 1);
  if (curdir != NULL)
    len += strlen (curdir);
  if (str != NULL)
    len += strlen (str);
  filename =
    (char *) absmalloc (sizeof (char) * len, "AcceptAction:filename");
  sprintf (filename, "%s/%s", curdir, str);

  cb_Cancel (w, client_data, call_data);
  (*promptfunction) (filename);
  absfree (filename, "AcceptAction:filename");
}

void
AcceptAction (Widget w, XEvent * event, String * params,
	      Cardinal * num_params)
{
  cb_Accept (w, NULL, NULL);
}

int
MakePrompt (Widget centerw, char *prompt, void (*func) (), char *def)
{

  Arg centerArgs[2];
  Arg args[20];
  int n;
  Position source_x, source_y;
  Position dest_x, dest_y;
  Dimension center_width, center_height;
  Dimension prompt_width, prompt_height;

  XtTranslations dialog_trans_table;

  Widget cancel, ok, rescan, filter, filename, dirname, viewport1, viewport2,
    box;
  Widget vsrl;

  desactivate_zoom ();

  if (promptShell == NULL)
    {
      n = 0;
      XtSetArg (args[n], XtNinput, True);
      n++;
      XtSetArg (args[n], XtNwidth, 540);
      n++;
      XtSetArg (args[n], XtNheight, 350);
      n++;
      promptShell = XtCreatePopupShell
	("promptShell", transientShellWidgetClass, gettop (), args, 3);

      n = 0;
      XtSetArg (args[n], XtNwidth, 540);
      n++;
      XtSetArg (args[n], XtNheight, 350);
      n++;
      promptDialog = XtCreateManagedWidget ("promptDialog", formWidgetClass,
					    promptShell, args, n);
      n = 0;
      XtSetArg (args[n], XtNwidth, 540);
      n++;
      XtSetArg (args[n], XtNheight, 1);
      n++;
      XtSetArg (args[n], XtNborderWidth, 0);
      n++;
      box = XtCreateManagedWidget ("promptDialog", formWidgetClass,
				   promptDialog, args, n);
      n = 0;
      XtSetArg (args[n], XtNwidth, 1);
      n++;
      XtSetArg (args[n], XtNheight, 350);
      n++;
      XtSetArg (args[n], XtNborderWidth, 0);
      n++;
      box = XtCreateManagedWidget ("promptDialog", formWidgetClass,
				   promptDialog, args, n);

      w_n = 0;
      w_dim (200, 20);
      w_rel (NULL, 9, 5);
      w_bord (0);
      XtSetArg (w_args[w_n], XtNlabel, "File name:");
      w_n++;
      XtSetArg (w_args[w_n], XtNjustify, XtJustifyLeft);
      w_n++;
      filename = XtCreateManagedWidget
	("Filename", labelWidgetClass, promptDialog, w_args, w_n);

      w_n = 0;
      w_dim (130, 20);
      w_rel (filename, 20, -20);
      XtSetArg (w_args[w_n], XtNborderWidth, 0);
      w_n++;
      XtSetArg (w_args[w_n], XtNlabel, "Directory:");
      w_n++;
      XtSetArg (w_args[w_n], XtNjustify, XtJustifyLeft);
      w_n++;
      dirname = XtCreateManagedWidget
	("Dirname", labelWidgetClass, promptDialog, w_args, w_n);

      w_n = 0;
      w_dim (200, 20);
      w_bord (0);
      w_rel (filename, -200, 2);
      XtSetArg (w_args[w_n], XtNstring, "");
      w_n++;
      XtSetArg (w_args[w_n], XtNeditType, XawtextEdit);
      w_n++;
      w_bONw ();
      valueWidget = XtCreateManagedWidget
	("text", asciiTextWidgetClass, promptDialog, w_args, w_n);
      addshadow (valueWidget, 3);

      w_n = 0;
      w_dim (290, 20);
      w_rel (dirname, -130, 2);
      w_bord (0);
      XtSetArg (w_args[w_n], XtNlabel, "");
      w_n++;
      XtSetArg (w_args[w_n], XtNborderWidth, 0);
      w_n++;
      XtSetArg (w_args[w_n], XtNjustify, XtJustifyLeft);
      w_n++;
      w_bONw ();
      dirvalueWidget = XtCreateManagedWidget
	("dirtext", labelWidgetClass, promptDialog, w_args, w_n);

      w_n = 0;
      w_bord (0);
      w_dim (200, 240);
      w_rel (valueWidget, -200, 9);
      XtSetArg (w_args[w_n], XtNuseRight, True);
      w_n++;
      XtSetArg (w_args[w_n], XtNallowVert, True);
      w_n++;
      XtSetArg (w_args[w_n], XtNforceBars, True);
      w_n++;

      viewport1 = XtCreateManagedWidget ("viewport1",
					 viewportWidgetClass, promptDialog,
					 w_args, w_n);
      vsrl = XtNameToWidget (viewport1, "vertical");
      if (vsrl != (Widget) NULL)
	{
	  modscroll (vsrl);
	}

      addshadow (viewport1, 6);

      w_n = 0;
      w_bord (0);
      XtSetArg (w_args[w_n], XtNdefaultColumns, 1);
      w_n++;
      XtSetArg (w_args[w_n], XtNforceColumns, True);
      w_n++;
      w_bONw ();
      list = XtCreateManagedWidget ("list", listWidgetClass,
				    viewport1, w_args, w_n);
      XtAddCallback (list, XtNcallback, set_filename, NULL);
      addshadow (list, 6);

      w_n = 0;
      w_bord (0);
      w_dim (200, 240);
      w_rel (dirvalueWidget, -290, 9);
      w_bord (0);
      XtSetArg (w_args[w_n], XtNuseRight, True);
      w_n++;
      XtSetArg (w_args[w_n], XtNallowVert, True);
      w_n++;
      XtSetArg (w_args[w_n], XtNforceBars, True);
      w_n++;
      viewport2 = XtCreateManagedWidget ("viewport2",
					 viewportWidgetClass, promptDialog,
					 w_args, w_n);
      vsrl = XtNameToWidget (viewport2, "vertical");
      if (vsrl != (Widget) NULL)
	{
	  modscroll (vsrl);
	}
      addshadow (viewport2, 6);

      w_n = 0;
      w_bord (0);
      XtSetArg (w_args[w_n], XtNdefaultColumns, 1);
      w_n++;
      XtSetArg (w_args[w_n], XtNforceColumns, True);
      w_n++;
      w_bONw ();
      dirlist = XtCreateManagedWidget ("dirlist", listWidgetClass,
				       viewport2, w_args, w_n);
      XtAddCallback (dirlist, XtNcallback, change_dir, NULL);
      addshadow (dirlist, 5);

      w_n = 0;
      w_dim (200, 20);
      w_rel (viewport1, -200, 9);
      w_bord (0);
      XtSetArg (w_args[w_n], XtNlabel, "Filter:");
      w_n++;
      XtSetArg (w_args[w_n], XtNjustify, XtJustifyLeft);
      w_n++;
      filter = XtCreateManagedWidget
	("Filter", labelWidgetClass, promptDialog, w_args, w_n);

      w_n = 0;
      w_dim (200, 20);
      w_rel (filter, -200, 9);
      w_bord (0);
      XtSetArg (w_args[w_n], XtNlabel, "");
      w_n++;
      XtSetArg (w_args[w_n], XtNborderWidth, 0);
      w_n++;
      XtSetArg (w_args[w_n], XtNjustify, XtJustifyLeft);
      w_n++;
      w_bONw ();
      filtervalueWidget = XtCreateManagedWidget
	("filtertext", labelWidgetClass, promptDialog, w_args, w_n);
      addshadow (filtervalueWidget, 3);

      w_n = 0;
      w_dim (85, 20);
      w_rel (NULL, 435, 80);
      ok = XtCreateManagedWidget
	("Ok", commandWidgetClass, promptDialog, w_args, w_n);
      XtAddCallback (ok, XtNcallback, cb_Accept, (XtPointer) NULL);

      w_n = 0;
      w_dim (85, 20);
      w_rel (NULL, 435, 115);
      rescan = XtCreateManagedWidget
	("Rescan", commandWidgetClass, promptDialog, w_args, w_n);
      XtAddCallback (rescan, XtNcallback, cb_Rescan, (XtPointer) NULL);

      w_n = 0;
      w_dim (85, 20);
      w_rel (NULL, 435, 150);
      cancel = XtCreateManagedWidget
	("Cancel", commandWidgetClass, promptDialog, w_args, w_n);
      XtAddCallback (cancel, XtNcallback, cb_Cancel, (XtPointer) NULL);

      XtAppAddActions (XtWidgetToApplicationContext (gettop ()),
		       dialogactionsTable, XtNumber (dialogactionsTable));

      dialog_trans_table = XtParseTranslationTable (dialogTranslation);
      XtOverrideTranslations (promptDialog, dialog_trans_table);
      XtOverrideTranslations (valueWidget, dialog_trans_table);

      XtRealizeWidget (promptShell);
      if (getcwd (curdir, 511) == NULL)
	sprintf (curdir, ".");
    }

  XtSetArg (centerArgs[0], XtNwidth, &center_width);
  XtSetArg (centerArgs[1], XtNheight, &center_height);
  XtGetValues (centerw, centerArgs, 2);
  XtSetArg (centerArgs[0], XtNwidth, &prompt_width);
  XtSetArg (centerArgs[1], XtNheight, &prompt_height);
  XtGetValues (promptShell, centerArgs, 2);
  source_x = (int) (center_width - prompt_width) / 2;
  source_y = (int) (center_height - prompt_height) / 3;
  XtTranslateCoords (centerw, source_x, source_y, &dest_x, &dest_y);
  XtSetArg (centerArgs[0], XtNx, dest_x);
  XtSetArg (centerArgs[1], XtNy, dest_y);
  XtSetValues (promptShell, centerArgs, 2);

  XtPopup (promptShell, XtGrabNone);

  promptfunction = func;
  remake_list ();
  return 0;
}

Boolean IsDirectory (char *root, char *path)
{
  char fullpath[512];
  struct stat statbuf;

  if (path == NULL)
    return (False);
  MakeFullPath (root, path, fullpath);
  if (stat (fullpath, &statbuf))
    return (False);

  if (statbuf.st_mode & S_IFDIR)
    return (True);
  else
    return (False);
}

void
remake_list ()
{
  int n;
  int len;

  DIR *dir;
  DIRSTRUCT *entry;
  int i, diri;
  int j, k;
  char *tmp;

  w_n = 0;
  XtSetArg (w_args[w_n], XtNlabel, curdir);
  w_n++;
  XtSetValues (dirvalueWidget, w_args, w_n);

  dir = opendir (curdir);
  if (dir == NULL)
    {
      fprintf (stderr, "impossible to open dir (%s)\n", curdir);
      return;
    }

  n = 0;
  while (readdir (dir) != NULL)
    n++;

  rewinddir (dir);

  labels =
    (char **) absmalloc ((n + 3) * sizeof (char *), "remake_list:labels ");
  dirlabels =
    (char **) absmalloc ((n + 3) * sizeof (char *), "remake_list:dirlabels ");

  i = 0;
  diri = 0;
  while ((entry = readdir (dir)) != NULL)
    {

      len = 256;

      if (IsDirectory (curdir, entry->d_name) && diri < n + 2)
	{
	  len = strlen (entry->d_name);

	  dirlabels[diri] =
	    (char *) absmalloc (sizeof (char) * (len + 1),
				"remake_list:dirlabels[diri] ");
	  strcpy (dirlabels[diri], entry->d_name);
	  diri++;
	}
      else
	{
	  if (strncmp (entry->d_name, ".", 1) && i < n + 2)
	    {
	      len = strlen (entry->d_name);

	      labels[i] =
		(char *) absmalloc (sizeof (char) * (len + 1),
				    "remake_list:labels[i] ");
	      strcpy (labels[i], entry->d_name);
	      i++;
	    }
	}
    }
  closedir (dir);

  labels[i] = NULL;
  dirlabels[diri] = NULL;

  if (i < 500)
    for (j = 0; j < i; j++)
      for (k = j + 1; k < i; k++)
	if (strcmp (labels[j], labels[k]) > 0)
	  {
	    tmp = labels[j];
	    labels[j] = labels[k];
	    labels[k] = tmp;
	  }

  if (diri < 500)
    for (j = 0; j < diri; j++)
      for (k = j + 1; k < diri; k++)
	if (strcmp (dirlabels[j], dirlabels[k]) > 0)
	  {
	    tmp = dirlabels[j];
	    dirlabels[j] = dirlabels[k];
	    dirlabels[k] = tmp;
	  }

  XawListChange (list, labels, 0, 0, True);
  XawListChange (dirlist, dirlabels, 0, 0, True);

  return;

}

void
freelist ()
{
  int i;

  if (labels != NULL)
    {
      i = 0;
      while (labels[i] != NULL)
	{

	  absfree (labels[i], "freelist:labels[i] ");
	  i++;
	}
      absfree (labels, "freelist:labels ");
      labels = NULL;
    }
  if (dirlabels != NULL)
    {
      i = 0;
      while (dirlabels[i] != NULL)
	{

	  absfree (dirlabels[i], "freelist:dirlabels[i] ");
	  i++;
	}
      absfree (dirlabels, "freelist:dirlabels ");
      dirlabels = NULL;
    }
}
