/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdio.h>
#include <unistd.h>

static int nplug = 0;
static int abs2child[10][2];
static int child2abs[10][2];

int
spawn (plugname, arg1, arg2, arg3, arg4)
     char *plugname;
     char *arg1, *arg2, *arg3, *arg4;
{
  int pid;

  if (pipe (abs2child[nplug]) == -1)
    {
      perror ("pipe failed");
      exit (1);
    }
  if (pipe (child2abs[nplug]) == -1)
    {
      perror ("pipe failed");
      exit (1);
    }

  perror ("will fork");
  if ((pid = fork ()) < 0)
    {
      perror ("fork 1 failed");
      exit (2);
    }
  perror ("had fork");
  if (pid == 0)
    {
      close (abs2child[nplug][1]);
      dup2 (abs2child[nplug][0], 0);
      close (abs2child[nplug][0]);

      close (child2abs[nplug][0]);
      dup2 (child2abs[nplug][1], 1);
      close (child2abs[nplug][1]);

      execlp (plugname, plugname, arg1, arg2, arg3, arg4, NULL);
      perror (plugname);
      exit (3);
    }
  else
    {
      close (abs2child[nplug][0]);
      dup2 (abs2child[nplug][1], 1);
      close (abs2child[nplug][1]);

      close (child2abs[nplug][1]);
      dup2 (child2abs[nplug][0], 0);
      close (child2abs[nplug][0]);
      nplug++;
      return nplug - 1;
    }
  exit (0);
}

int
send (int plugin, char *buf)
{
  fprintf (stderr, "send to %d string %s\n", plugin, buf);
  write (abs2child[plugin][1], buf, strlen (buf));
  return 0;
}

static char getbuf[256];

char *
receive (plugin)
     int plugin;
{
  int nread;
  char *buf;

  read (child2abs[plugin][0], buf, 5);
  fprintf (stderr, "buf: %s\n", buf);
  sscanf (buf, "%d", &nread);

  getbuf[0] = '\0';
  read (child2abs[plugin][0], getbuf, nread);
  buf[nread] = '\0';
  fprintf (stderr, "buf: %s\n", getbuf);

  return getbuf;

}
