/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "stdlib.h"
#include "stdio.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Core.h>
#include <X11/Shell.h>
#include "scale.h"
#include "font.h"

static Boolean
seek_fontset (fid, fontset, size_ret)
     Font fid;
     XFontSet *fontset;
     int *size_ret;
{
  extern struct _xfstruct x_fontinfo[];
  static int font_types[] = { 0, 2 };
  struct xfont *nf;
  int i;

  for (i = 0; i < XtNumber (font_types); i++)
    {
      nf = x_fontinfo[font_types[i]].xfontlist;
      while (nf != NULL && nf->fstruct->fid != fid)
	nf = nf->next;
      if (nf != NULL)
	{

	  *size_ret = nf->size;
	  return TRUE;
	}
    }
  return FALSE;
}

Boolean is_i18n_font (font)
     XFontStruct *
       font;
{
  XFontSet fontset;
  int font_size;
  return seek_fontset (font->fid, &fontset, &font_size);
}

#define MAX(a, b)  ((a) < (b)) ? (b) : (a)

static int text_bitmap_width = -1;
static int text_bitmap_height = -1;
static Pixmap text_bitmap = None;
static char *scale_buf = NULL;
static GC depth_one_gc = None;

static void
AllocTextBitmapAndScaleBuf (display, d, width, height)
     Display *display;
     Drawable d;
     int width;
     int height;
{
  if (height > text_bitmap_height || width > text_bitmap_width)
    {
      if (0 < text_bitmap_height && 0 < text_bitmap_width)
	{
	  XFreePixmap (display, text_bitmap);
	  free (scale_buf);
	}

      if (height < 1)
	height = 1;
      if (width < 1)
	width = 1;
      text_bitmap_height = height;
      text_bitmap_width = width;
      text_bitmap = XCreatePixmap (display, d,
				   text_bitmap_width, text_bitmap_height, 1);
      scale_buf = (char *) malloc (text_bitmap_height * sizeof (char));
    }
}

static void
ScaleUp (from_image, to_image, width, height, scale)
     XImage *from_image;
     XImage *to_image;
     int width;
     int height;
     int scale;
{
  register int i, j;
  register int x1, y1, x2, y2;

  i = -1;
  for (x2 = 0; x2 < width; x2++)
    {
      x1 = (x2 * 100) / scale;
      if (x1 != i)
	{
	  j = -1;
	  for (y2 = 0; y2 < height; y2++)
	    {
	      y1 = (y2 * 100) / scale;
	      if (y1 != j)
		{
		  if ((scale_buf[y2] = XGetPixel (from_image, x1, y1)))
		    XPutPixel (to_image, x2, y2, 1);
		  j = y1;
		}
	      else
		{
		  if ((scale_buf[y2] = scale_buf[y2 - 1]))
		    XPutPixel (to_image, x2, y2, 1);
		}
	    }
	  i = x1;
	}
      else
	{
	  for (y2 = 0; y2 < height; y2++)
	    {
	      if (scale_buf[y2] == 1)
		XPutPixel (to_image, x2, y2, 1);
	    }
	}
    }
}

static void
ScaleDown (from_image, to_image, width, height, scale)
     XImage *from_image;
     XImage *to_image;
     int width;
     int height;
     int scale;
{
  int ymax, y1, y2;
  register int xmax, x1, x2, last_x2;

  xmax = (width * 100) / scale;
  ymax = (height * 100) / scale;

  for (y1 = 0; y1 < ymax; y1++)
    {
      y2 = (y1 * scale) / 100;
      last_x2 = -1;
      for (x1 = 0; x1 < xmax; x1++)
	{
	  x2 = (x1 * scale) / 100;
	  if (x2 != last_x2 && XGetPixel (from_image, x1, y1))
	    {
	      XPutPixel (to_image, x2, y2, 1);
	      last_x2 = x2;

	    }

	}

    }
}

void
i18n_draw_string (dpy, drawable, gc, x, y, str, len, base_width, base_height,
		  scale)
     Display *dpy;
     Drawable drawable;
     GC gc;
     int x, y;
     char *str;
     int len;
     int base_width, base_height;
     int scale;
{
  static Pixmap paint_bitmap = None;
  static int paint_bitmap_width = -1;
  static int paint_bitmap_height = -1;
  static XImage *to_image = NULL;
  static char *to_image_data = NULL;
  static int to_image_size = -1;
  static GC my_gc = None;
  static int width, height, ascent;
  XImage *from_image;
  XGCValues values;
  XCharStruct overall;
  int descent, direction;

  if (scale == 0)
    scale = 75;

  XGetGCValues (dpy, gc, GCFont, &values);

  XQueryTextExtents (dpy, values.font, str, len, &direction, &ascent,
		     &descent, &overall);

  width = (overall.width) * scale / 100 + 1;
  height = (overall.ascent + overall.descent) * scale / 100 + 1;
  ascent = ascent * scale / 100;
  descent = descent * scale / 100;

  AllocTextBitmapAndScaleBuf (dpy, drawable,
			      MAX (base_width, width + 1), MAX (base_height,
								height + 1));
  if (depth_one_gc == None)
    {
      depth_one_gc = XCreateGC (dpy, text_bitmap, (unsigned long) 0, 0);
      XSetBackground (dpy, depth_one_gc, 0);
      XSetFillStyle (dpy, depth_one_gc, FillSolid);
      XSetFunction (dpy, depth_one_gc, GXcopy);
    }
  if (my_gc != None)
    XFreeGC (dpy, my_gc);
  my_gc = XCreateGC (dpy, drawable, (unsigned long) 0, 0);
  if (to_image == NULL
      || to_image->width < text_bitmap_width
      || to_image->height < text_bitmap_height)
    {
      if (to_image != NULL)
	XDestroyImage (to_image);
      to_image_size =
	(unsigned) (text_bitmap_width / 8 + 1) * text_bitmap_height;
      to_image_data = malloc (to_image_size);
      to_image = XCreateImage (dpy, DefaultVisual (dpy, DefaultScreen (dpy)),
			       1, XYBitmap, 0, to_image_data,
			       text_bitmap_width, text_bitmap_height, 8, 0);
    }
  if (paint_bitmap_width < width || paint_bitmap_height < height)
    {
      if (paint_bitmap != None)
	XFreePixmap (dpy, paint_bitmap);
      paint_bitmap = XCreatePixmap (dpy, drawable, width, height, 1);
      paint_bitmap_width = width;
      paint_bitmap_height = height;
    }
  XSetForeground (dpy, depth_one_gc, 0);
  XFillRectangle (dpy, paint_bitmap, depth_one_gc, 0, 0,
		  paint_bitmap_width, paint_bitmap_height);

  XSetForeground (dpy, depth_one_gc, 0);
  XFillRectangle (dpy, text_bitmap, depth_one_gc, 0, 0,
		  text_bitmap_width, text_bitmap_height);
  XSetForeground (dpy, depth_one_gc, 1);
  XSetFont (dpy, depth_one_gc, values.font);
  XDrawString (dpy, text_bitmap, depth_one_gc, 0, overall.ascent, str, len);

  from_image = XGetImage (dpy, text_bitmap, 0, 0,
			  text_bitmap_width, text_bitmap_height, 1, ZPixmap);

  bzero (to_image_data, to_image_size);
  if (100 < scale)
    {
      ScaleUp (from_image, to_image, width, height, scale);
    }
  else
    {
      ScaleDown (from_image, to_image, width, height, scale);
    }
  XDestroyImage (from_image);

  XPutImage (dpy, paint_bitmap, depth_one_gc, to_image, 0, 0, 0, 0, width,
	     height);

  XCopyGC (dpy, gc, GCForeground | GCBackground | GCFunction | GCPlaneMask,
	   my_gc);
  XSetFillStyle (dpy, my_gc, FillStippled);
  XSetStipple (dpy, my_gc, paint_bitmap);
  XSetTSOrigin (dpy, my_gc, x, y - (overall.ascent * scale / 100));
  XFillRectangle (dpy, drawable, my_gc, x, y - (overall.ascent * scale / 100),
		  width, height);

}
