/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef MAIN_H
#define MAIN_H

#include "cell.h"
#include "range.h"

int coltoalpha (char *buf, int i);
int numtoalpha2 (char *buf, int j, int i, int dj, int di);
int numtoalpha (char *buf, int j, int i);
int alphatonum (char *buf, int *ii, int *jj);
void updategraph ();
int get_select (int *i1, int *j1, int *i2, int *j2);
int is_selecting ();
int printplot (int number);
void plot ();
int printfile2 (char *filename);
int printascii (char *filename);
void makeprint (int destination, char *destname, int format);
int myfprintf (FILE * fp, char *word, int l);
int moveselect (int fri, int frj, int toi, int toj, int k);
int selection (int ii, int jj);
int selectall ();
int selectcol (int col, int shift);
int selectlin (int lin, int shift);
int setselection (int i1, int j1, int i2, int j2);
int setselectionrange (Range * range);
int getselection (int *i1, int *j1, int *i2, int *j2);
int resetselect (int ii, int jj, int k);
int insertcolumn ();
int insertline ();
int delcolumn ();
int delline ();
int copyr ();
int copyd ();
int makecolor (int fg, int bg);
int color ();
void formatline ();
void formatcolumn ();
int fit ();
int border (int border, int type);
int makefont (int fontnum, int fontweight, int fontsize);
int makejust (int just);
int makeformat (int type, int decimal);
int cut ();
int paste ();
int copy ();
void m_exit ();
void exportfile (char *filename, int icomma, int itab, int ispace,
		 int idotcom, int other, int asone, char *o);
int insertfile (char *filename, int icomma, int itab, int ispace, int idotcom,
		int other, int asone, char *o);
int nextline ();
int add2matrix (char *word);
int addi2matrix (int v);
int addd2matrix (double v);
int makesortd ();
int makesorta ();
int makebrush ();
int setbrush (Cell * cell);
int incr ();
int
printfile (char *filename, char *language, int center, int portrait,
	   char *paper, int multiplepage, double magnification, int copies,
	   double xshift, double yshift);
extern int extendselection (int i, int j);
#endif
