/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef WORKBOOK_VB_H
#define WORKBOOK_VB_H
#include "workbook.h"
#include "class.h"

extern obj vb_getworkbook (int narg, obj * arg);
extern obj vb_get_ActiveWorkbook ();

extern obj vb_get_Workbooks ();

extern obj vb_workbook_setactivesheet (int narg, obj * arg);
extern obj vb_workbook_getactivesheet (int narg, obj * arg);
extern obj vb_workbook_activate (int narg, obj * arg);
extern obj vb_workbook_calculate (int narg, obj * arg);
extern obj vb_workbook_close (int narg, obj * arg);
extern obj vb_workbook_printout (int narg, obj * arg);
extern obj vb_workbook_save (int narg, obj * arg);
extern obj vb_workbook_saveas (int narg, obj * arg);

extern obj vb_workbooks_setcount (int narg, obj * arg);
extern obj vb_workbooks_getcount (int narg, obj * arg);
extern obj vb_workbooks_add (int narg, obj * arg);
extern obj vb_workbooks_open (int narg, obj * arg);
extern obj vb_workbooks_close (int narg, obj * arg);

static Memberdata Workbooksdata[] = {
  {"Count", INTEGER, &vb_workbooks_setcount, &vb_workbooks_getcount},
  {NULL, 0, NULL, NULL}
};

static Fct Workbooksfct[] = {
  {"Add", &vb_workbooks_add, WORKBOOK, 0},
  {"Open", &vb_workbooks_open, WORKBOOK, 5},
  {"Close", &vb_workbooks_close, INTEGER, 0},
  {NULL, NULL, 0, 0}
};

static Memberdata Workbookdata[] = {
  
    {"ActiveSheet", WORKSHEET, &vb_workbook_setactivesheet,
   &vb_workbook_getactivesheet},
  {NULL, 0, NULL, NULL}
};

static Fct Workbookfct[] = {
  {"Activate", &vb_workbook_activate, WORKBOOK, 0},
  {"Calculate", &vb_workbook_calculate, INTEGER, 0},
  {"Close", &vb_workbook_close, INTEGER, 0},
  {"PrintOut", &vb_workbook_printout, INTEGER, 6},
  {"Save", &vb_workbook_save, INTEGER, 0},
  {"SaveAs", &vb_workbook_saveas, INTEGER, 0},
  {NULL, NULL, 0, 0}
};

#endif
