/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdio.h>
#include "formula_interpret.h"
#include "interpret.h"
#include "y.tab.h"
#include "oper.h"
#include "symboltable.h"
#include "cell_vb.h"
#include "properties.h"

#define PRINTOBJ

static int brk = 0;
static int err = 0;
static int warn = 0;

int
message (char *txt)
{
  if (brk)
    fprintf (stderr, "Break: %s\n", txt);
  if (warn)
    fprintf (stderr, "Warning: %s\n", txt);
  if (err)
    fprintf (stderr, "Error: %s\n", txt);
  return 0;
}

obj exform (nodeType * p)
{
  obj o;
  if (!p || brk || err)
    return o;
  switch (p->type)
    {
    case typeCon:
      {
	o = p->con.value;
	PRINTOBJ return o;
      }
    case typeId:
      {
	Idval *val;
	if (p->id.id.type == BUILTINFUNCTION)
	  {
	    o = check4property (p->id.id);
	    if (o.type != BUILTINFUNCTION)
	      return o;
	  }
	if (p->id.id.type == PROPERTY)
	  {
	    o = property2obj (p->id.id);
	    return o;
	  }
	val = look (p->id.id.label, 1);

	o.rec.s = (char *) val;
	o.type = p->id.id.type;
	o.label = p->id.id.label;

	PRINTOBJ return o;

      }
    case typeOpr:
      switch (p->opr.oper.rec.i)
	{
	case CALL:
	  {
	    argcall ();
	    exform (p->opr.op[1]);
	    switch ((p->opr.op[0])->id.id.type)
	      {
	      case IDENTIFIER:
		o = mkcall (exform (p->opr.op[0]));
		break;
	      case BUILTINFUNCTION:
		o = mkcallbuiltin ((p->opr.op[0])->id.id);
		break;
	      }
	    argendcall ();
	    PRINTOBJ return o;
	  }
	case ARG:
	  {
	    switch (p->opr.nops)
	      {
	      case 0:
		return o;
	      case 1:
		{
		  o = mkarg (p->opr.op[0]);
		  PRINTOBJ return o;
		}
	      case 2:
		{
		  o = exform (p->opr.op[0]);
		  o = mkarg (p->opr.op[1]);
		  PRINTOBJ return o;
		}
	      }
	    PRINTOBJ return o;
	  }
	case BUILTINFUNCTION:
	  {
	    argcall ();
	    exform (p->opr.op[1]);
	    o = mkcallbuiltin ((p->opr.op[0])->id.id);
	    argendcall ();

	    PRINTOBJ return o;
	  }

	case UMINUS:
	  return mkuminus (exform (p->opr.op[0]));
	case '+':
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mksum (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case '-':
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkdiff (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case '*':
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkmult (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case '/':
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkdiv (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case MOD:
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkmod (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case '\\':
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkintdiv (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case '^':
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkpow (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case LT:
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mklt (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case GT:
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkgt (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case GE:
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkge (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case LE:
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkle (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case NE:
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkne (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case EQ:
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkeq (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case OR:
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkor (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case AND:
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkand (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case XOR:
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkxor (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case '&':
	  {
	    obj o1, o2, o3;
	    o1 = exform (p->opr.op[0]);
	    o2 = exform (p->opr.op[1]);
	    o3 = mkconcat (o1, o2);
	    freenocstobj (o1);
	    freenocstobj (o2);
	    return o3;
	  }
	case NOT:
	  {
	    obj o1, o3;
	    o1 = exform (p->opr.op[0]);
	    o3 = mknot (o1);
	    freenocstobj (o1);
	    return o3;
	  }
	}
    default:
      break;
    }
  return o;
}
