/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "fac_vb.h"
#include "libfct.h"
#ifdef SAMCEF
#include "fac.h"
#endif

obj vb_openfac (int narg, obj * arg)
{
  obj o;
  o.label = NULL;
  o.type = FAC;
  o.rec.s = NULL;
#ifdef SAMCEF
  if (narg == 1)
    {

      o.rec.s = (char *) inifac (obj2string (arg[0]));
    }
#endif

  return o;
}

obj vb_fac_setname (int narg, obj * arg)
{
  obj o;
  o.label = NULL;
  o.type = STRING_CONSTANT;
  o.rec.s = NULL;
  return o;
}

obj vb_fac_getname (int narg, obj * arg)
{
  obj o;
#ifdef SAMCEF
  obj *facobj;
#endif
  o.label = NULL;
  o.type = STRING_CONSTANT;
  o.rec.s = NULL;

#ifdef SAMCEF
  if (narg > 0)
    {
      facobj = (obj *) arg[0].rec.s;
      if (facobj->type == FAC)
	o.rec.s = ((Fac *) facobj->rec.s)->filename;
    }
#endif

  return o;
}

obj vb_fac_setnumcase (int narg, obj * arg)
{
  obj o;
  o.label = NULL;
  o.type = INTEGER;
  o.rec.i = 0;
  return o;
}

obj vb_fac_getnumcase (int narg, obj * arg)
{
  obj o;
#ifdef SAMCEF
  obj *facobj;
#endif
  o.label = NULL;
  o.type = INTEGER;
  o.rec.i = 0;

#ifdef SAMCEF
  if (narg > 0)
    {
      facobj = (obj *) arg[0].rec.s;
      if (facobj->type == FAC)
	o.rec.i = ((Fac *) facobj->rec.s)->samdb->ncase;
    }
#endif

  return o;
}

obj vb_fac_ept (int narg, obj * arg)
{
  obj o;
  o.label = NULL;
  o.type = DOUBLE;
  o.rec.d = 0.0;

#ifdef SAMCEF
  if (narg > 1)
    {
      Fac *fac;
      if (arg[0].type == FAC)
	fac = (Fac *) arg[0].rec.s;
      o.rec.d = getept (fac, obj2int (arg[1]));
    }
#endif
  return o;
}

obj vb_fac_gpf (int narg, obj * arg)
{
  obj o;
  o.label = NULL;
  o.type = DOUBLE;
  o.rec.d = 0.0;

#ifdef SAMCEF
  if (narg > 4)
    {
      Fac *fac;
      if (arg[0].type == FAC)
	fac = (Fac *) arg[0].rec.s;
      o.rec.d =
	getgpf (fac, obj2int (arg[1]), obj2int (arg[2]), obj2int (arg[3]),
		obj2int (arg[4]));
    }
#endif
  return o;
}

obj vb_fac_gpd (int narg, obj * arg)
{
  obj o;
  o.label = NULL;
  o.type = DOUBLE;
  o.rec.d = 0.0;

#ifdef SAMCEF
  if (narg > 1)
    {
      Fac *fac;
      if (arg[0].type == FAC)
	fac = (Fac *) arg[0].rec.s;
      o.rec.d =
	getgpd (fac, obj2int (arg[1]), obj2int (arg[2]), obj2int (arg[3]));
    }
#endif
  return o;
}
