/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/


#ifndef STYLE_H
#define STYLE_H

#include "stdlib.h"
#include <stdio.h>

#define STY_CELL 0
#define STY_GRAPH 1
#define STY_DRAW 2
#define STY_DEF_CELL 3

#define STY_FG 0
#define STY_BG 1
#define STY_BORDER 2
#define STY_JUSTIF 3
#define STY_DECIMAL 4
#define STY_FORMAT 5
#define STY_FONT 6
#define STY_FONTW 7
#define STY_FONTS 8
#define STY_BORDER_TOP 9
#define STY_BORDER_BOT 10
#define STY_BORDER_LEF 11
#define STY_BORDER_RIG 12
#define STY_MAXCELL 13

#define STY_MAXGRAPH 1

#define STY_MAXDRAW  1

typedef struct
{
  int *value;
  int dim;
}
Style;

extern Style *newstyle ();
extern int freestyle ();
extern int setstyle ();
extern int getstyle ();
extern int style_write (Style * style, FILE * fp);
extern int style_read (Style * style, FILE * fp);
extern Style *style_cpy (Style * style1, Style * style2);

#endif
