/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "draw.h"
#include <math.h>
#include "memory.h"
#include "worksheet.h"

Drawing *ActiveDrawing = NULL;

Drawing *
newdrawing ()
{

  Drawing *drawing;
  drawing = (Drawing *) absmalloc (sizeof (Drawing), "newdrawing:drawing ");
  drawing->worksheet = NULL;
  return drawing;

}

Drawing *
newdrawing1 (dr)
     Drawing *dr;
{

  Drawing *drawing;
  drawing = (Drawing *) absmalloc (sizeof (Drawing), "newdrawing:drawing ");
  drawing->x1 = dr->x1;
  drawing->y1 = dr->y1;
  drawing->x2 = dr->x2;
  drawing->y2 = dr->y2;
  drawing->type = dr->type;
  drawing->style = NULL;
  drawing->worksheet = NULL;
  return drawing;

}

int
drawing_copy (drawing, dr)
     Drawing *drawing;
     Drawing *dr;
{

  drawing->x1 = dr->x1;
  drawing->y1 = dr->y1;
  drawing->x2 = dr->x2;
  drawing->y2 = dr->y2;
  drawing->type = dr->type;
  drawing->style = NULL;
  drawing->worksheet = NULL;
  return 0;
}

static int infreedrawing = 0;

int
freedrawing (dr)
     Drawing *dr;
{
  if (infreedrawing)
    return 0;
  infreedrawing = 1;
  if (dr == NULL)
    {
      infreedrawing = 0;
      return -1;
    }
  if (dr->worksheet != NULL)
    worksheet_deldrawing (dr->worksheet, dr);
  absfree (dr, "freedrawing:drawing ");
  infreedrawing = 0;
  return 0;
}

Drawing *
drawing_read (fp)
     FILE *fp;
{
  Drawing *dr = newdrawing ();
  fscanf (fp, "%d %d %d %d %d",
	  &(dr->type), &(dr->x1), &(dr->y1), &(dr->x2), &(dr->y2));

  return dr;

}

int
drawing_write (dr, fp)
     Drawing *dr;
     FILE *fp;
{
  char *type;

  if (dr->type == 0)
    {
      fprintf (fp, "ActiveSheet.Shapes.AddLine(%d, %d,%d,%d)\n", dr->x1,
	       dr->y1, dr->x2, dr->y2);
      return 1;
    }
  switch (dr->type)
    {
    case 25:
      type = "msoShapeArc";
      break;
    case 1:
      type = "msoShapeRectangle";
      break;
    case 9:
      type = "msoShapeOval";
      break;
    default:
      type = "msoShapeRectangle";
      break;
    }
  fprintf (fp, "ActiveSheet.Shapes.AddShape(%s,%d, %d,%d,%d)\n", type, dr->x1,
	   dr->y1, dr->x2, dr->y2);
  return 0;

}

Drawing *
ActivateDrawing (drawing)
     Drawing *drawing;
{
  ActiveDrawing = drawing;
  return ActiveDrawing;
}

int
drawing_pointed (dr, x, y, dx, dy)
     Drawing *dr;
     int x, y, dx, dy;
{
  int mx, my;
  int x1, x2, y1, y2;

  x1 = dr->x1;
  x2 = dr->x2;
  y1 = dr->y1;
  y2 = dr->y2;

  mx = (x1 + x2) / 2;
  my = (y1 + y2) / 2;
  switch (dr->type)
    {
    case 0:
      {
	if ((abs (x1 - x) <= dx && abs (y1 - y) <= dy) ||
	    (abs (x2 - x) <= dx && abs (y2 - y) <= dy))
	  return 1;
      }
      break;
    case 1:
      {
	if (
	    ((x1 - dx < x && x < x1 + dx) && (y1 - dy < y && y < y2 + dy)) ||
	    ((x2 - dx < x && x < x2 + dx) && (y1 - dy < y && y < y2 + dy)) ||
	    ((y1 - dy < y && y < y1 + dy) && (x1 - dx < x && x < x2 + dx)) ||
	    ((y2 - dy < y && y < y2 + dy) && (x1 - dx < x && x < x2 + dx)))
	  return 1;
	break;
      }
    case 2:
      {
	if ((fabs (x1 - x) <= dx && fabs (y1 - y) <= dy) ||
	    (fabs (x2 - x) <= dx && fabs (y2 - y) <= dy))
	  return 1;
      }
      break;
    case 3:
      {
	if ((fabs (x1 - x) <= dx && fabs (y1 - y) <= dy) ||
	    (fabs (x2 - x) <= dx && fabs (y2 - y) <= dy))
	  return 1;
      }
      break;
    default:
      {
	if ((fabs (x1 - x) <= dx && fabs (y1 - y) <= dy) ||
	    (fabs (x2 - x) <= dx && fabs (y2 - y) <= dy))
	  return 1;
      }
    }

  return 0;
}
