/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "button.h"
#include <math.h>
#include "memory.h"
#include "project.h"
#include "callback.h"

Button *ActiveButton = NULL;

Button *
newbutton ()
{

  Button *button;
  button = (Button *) absmalloc (sizeof (Button), "newbutton:button ");
  button->label = NULL;
  button->macro = NULL;
  return button;

}

int
freebutton (btn)
     Button *btn;
{
  if (btn == NULL)
    return 0;
  if (btn->label != NULL)
    absfree (btn->label, "freebutton:btn->label");
  if (btn->macro != NULL)
    absfree (btn->macro, "freebutton:btn->macro");
  absfree (btn, "freebutton:button ");
  return 0;
}

int
button_setlabel (Button * button, char *label)
{
  int len = 0;
  if (button == NULL || label == NULL)
    return -1;
  len = strlen (label);
  if (len < 1)
    return -1;
  button->label =
    absmalloc (sizeof (char) * (len + 1), "button_setlabel:button->label");
  strcpy (button->label, label);
  button->label[len] = '\0';
  return 0;
}

char *
button_getlabel (Button * btn)
{
  if (btn == NULL)
    return NULL;
  if (btn->label == NULL)
    return "Button";
  return btn->label;
}

int
button_setmacro (Button * button, char *macro)
{
  int len = 0;
  if (button == NULL || macro == NULL)
    return -1;
  len = strlen (macro);
  if (len < 1)
    return -1;
  button->macro =
    absmalloc (sizeof (char) * (len + 1), "button_setmacro:button->macro");
  strcpy (button->macro, macro);
  button->macro[len] = '\0';
  return 0;
}

char *
button_getmacro (Button * btn)
{
  if (btn == NULL)
    return NULL;
  if (btn->macro == NULL)
    return "NoMacroAssociated";
  return btn->macro;
}

int
button_write (btn, fp)
     Button *btn;
     FILE *fp;
{
  fprintf (fp, "Set objbutton = ActiveSheet.Buttons.Add (%d,%d,%d,%d)\n",
	   btn->x1, btn->y1, btn->x2 - btn->x1, btn->y2 - btn->y1);
  fprintf (fp, "objbutton.OnAction = \"%s\"\n", btn->macro);
  fprintf (fp, "objbutton.Text = \"%s\"\n", btn->label);

  return 0;

}

Button *
ActivateButton (button)
     Button *button;
{
  ActiveButton = button;
  return ActiveButton;
}

int
button_click (btn)
     Button *btn;
{
  if (btn == NULL)
    return -1;
  if (btn->macro == NULL)
    return -2;
  gotolabel (btn->macro);
  xrepaint ();
  return 0;
}

int
button_pointed (btn, x, y, dx, dy)
     Button *btn;
     int x, y, dx, dy;
{
  int mx, my;
  int x1, x2, y1, y2;

  x1 = btn->x1;
  x2 = btn->x2;
  y1 = btn->y1;
  y2 = btn->y2;

  mx = (x1 + x2) / 2;
  my = (y1 + y2) / 2;

  if (
      ((x1 - dx < x && x < x1 + dx) && (y1 - dy < y && y < y2 + dy)) ||
      ((x2 - dx < x && x < x2 + dx) && (y1 - dy < y && y < y2 + dy)) ||
      ((y1 - dy < y && y < y1 + dy) && (x1 - dx < x && x < x2 + dx)) ||
      ((y2 - dy < y && y < y2 + dy) && (x1 - dx < x && x < x2 + dx)))
    return 1;

  return 0;
}
